package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.AddBenthosFrequencyLengthStepCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.CancelEditBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.GenerateBenthosFrequencyLengthStepsAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.ResetBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.SaveAndCloseBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.SaveAndContinueBenthosFrequencyAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class BenthosFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosFrequencyUIModel, BenthosFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_LENGTH_STEP_CARACTERISTIC_BUTTON_ENABLED = "addLengthStepCaracteristicButton.enabled";
    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE = "dataInFrequenciesWarningContainer.visible";
    public static final String BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED = "generateLengthStepsAction.enabled";
    public static final String BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE = "lengthstepSettingsBlock.visible";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_VALUE = "maxStepField.numberValue";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_VALUE = "minStepField.numberValue";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_SAVE_AND_CLOSE_ACTION_ENABLED = "saveAndCloseAction.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED = "saveAndContinueAction.enabled";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_SIMPLE_COUNTING_NUMBER_FIELD_NUMBER_VALUE = "simpleCountingNumberField.numberValue";
    public static final String BINDING_SIMPLE_COUNTING_WEIGHT_FIELD_BEAN = "simpleCountingWeightField.bean";
    public static final String BINDING_SIMPLE_COUNTING_WEIGHT_FIELD_NUMBER_VALUE = "simpleCountingWeightField.numberValue";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_NUMBER_VALUE = "stepField.numberValue";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";
    public static final String BINDING_TOTAL_NUMBER_FIELD_TEXT = "totalNumberField.text";
    public static final String BINDING_TOTAL_NUMBER_LABEL_ENABLED = "totalNumberLabel.enabled";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_BEAN = "totalWeightField.bean";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE = "totalWeightField.numberValue";
    public static final String BINDING_TOTAL_WEIGHT_LABEL_ENABLED = "totalWeightLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected AddBenthosFrequencyLengthStepCaracteristicAction addLengthStepCaracteristicAction;
    protected JButton addLengthStepCaracteristicButton;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected TuttiHelpBroker broker;
    protected CancelEditBenthosFrequencyAction cancelAction;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected JLabel dataInFrequenciesWarning;
    protected JPanel dataInFrequenciesWarningContainer;
    protected BenthosFrequencyUI editBenthosFrequenciesTopPanel = this;
    protected JSplitPane firstSplitPane;
    protected JButton generateButton;
    protected GenerateBenthosFrequencyLengthStepsAction generateLengthStepsAction;
    protected final BenthosFrequencyUIHandler handler = createHandler();
    protected JPanel histogramPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected Table lengthstepSettingsBlock;
    protected JScrollPane logsScrollPane;
    protected JXTable logsTable;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected BenthosFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected ResetBenthosFrequencyAction resetAction;
    protected JButton resetButton;
    protected SaveAndCloseBenthosFrequencyAction saveAndCloseAction;
    protected JButton saveAndCloseButton;
    protected SaveAndContinueBenthosFrequencyAction saveAndContinueAction;
    protected JButton saveAndContinueButton;
    protected JSplitPane secondSplitPane;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    protected NumberEditor simpleCountingNumberField;
    protected JLabel simpleCountingNumberLabel;
    protected NumberEditor simpleCountingWeightField;
    protected JLabel simpleCountingWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "step",  editorName = "stepField")
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    protected JTextField totalNumberField;
    protected JLabel totalNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected ComputableDataEditor<Float> totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosFrequencyUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public BenthosFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI() {
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.SIMPLE_COUNTING);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public AddBenthosFrequencyLengthStepCaracteristicAction getAddLengthStepCaracteristicAction() {
        return addLengthStepCaracteristicAction;
    }

    public JButton getAddLengthStepCaracteristicButton() {
        return addLengthStepCaracteristicButton;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public CancelEditBenthosFrequencyAction getCancelAction() {
        return cancelAction;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JLabel getDataInFrequenciesWarning() {
        return dataInFrequenciesWarning;
    }

    public JPanel getDataInFrequenciesWarningContainer() {
        return dataInFrequenciesWarningContainer;
    }

    public JSplitPane getFirstSplitPane() {
        return firstSplitPane;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public GenerateBenthosFrequencyLengthStepsAction getGenerateLengthStepsAction() {
        return generateLengthStepsAction;
    }

    public BenthosFrequencyUIHandler getHandler() {
        return handler;
    }

    public JPanel getHistogramPanel() {
        return histogramPanel;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public Table getLengthstepSettingsBlock() {
        return lengthstepSettingsBlock;
    }

    public JScrollPane getLogsScrollPane() {
        return logsScrollPane;
    }

    public JXTable getLogsTable() {
        return logsTable;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public BenthosFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public ResetBenthosFrequencyAction getResetAction() {
        return resetAction;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public SaveAndCloseBenthosFrequencyAction getSaveAndCloseAction() {
        return saveAndCloseAction;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public SaveAndContinueBenthosFrequencyAction getSaveAndContinueAction() {
        return saveAndContinueAction;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public JSplitPane getSecondSplitPane() {
        return secondSplitPane;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public NumberEditor getSimpleCountingNumberField() {
        return simpleCountingNumberField;
    }

    public JLabel getSimpleCountingNumberLabel() {
        return simpleCountingNumberLabel;
    }

    public NumberEditor getSimpleCountingWeightField() {
        return simpleCountingWeightField;
    }

    public JLabel getSimpleCountingWeightLabel() {
        return simpleCountingWeightLabel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalNumberField() {
        return totalNumberField;
    }

    public JLabel getTotalNumberLabel() {
        return totalNumberLabel;
    }

    public ComputableDataEditor<Float> getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<BenthosFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(resetButton);
        actionPanel.add(saveAndContinueButton);
        actionPanel.add(saveAndCloseButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(modePanel, BorderLayout.WEST);
        configurationPanel.add(modeConfigurationPanel, BorderLayout.CENTER);
        configurationPanel.add(lengthstepSettingsBlock, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(firstSplitPane, "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table2, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToDataInFrequenciesWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        dataInFrequenciesWarningContainer.add(dataInFrequenciesWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToEditBenthosFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToFirstSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        firstSplitPane.add(secondSplitPane, JSplitPane.LEFT);
        firstSplitPane.add(histogramPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToLengthstepSettingsBlock() {
        if (!allComponentsCreated) {
            return;
        }
        lengthstepSettingsBlock.add($JSeparator0, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add($JPanel1, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(stepField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToLogsScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        logsScrollPane.getViewport().add(logsTable);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSecondSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        secondSplitPane.add(logsScrollPane, JSplitPane.LEFT);
        secondSplitPane.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), JSplitPane.RIGHT);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight(actionPanel,50);
    }

    protected void createAddLengthStepCaracteristicAction() {
        $objectMap.put("addLengthStepCaracteristicAction", addLengthStepCaracteristicAction = new AddBenthosFrequencyLengthStepCaracteristicAction(this));
    }

    protected void createAddLengthStepCaracteristicButton() {
        $objectMap.put("addLengthStepCaracteristicButton", addLengthStepCaracteristicButton = new JButton());
        
        addLengthStepCaracteristicButton.setName("addLengthStepCaracteristicButton");
        addLengthStepCaracteristicButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.addLengthStepCaracteristic.help");
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
        autoGenModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.autoGen.help");
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosFrequencies.help"));
    }

    protected void createCancelAction() {
        $objectMap.put("cancelAction", cancelAction = new CancelEditBenthosFrequencyAction(this));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createDataInFrequenciesWarning() {
        $objectMap.put("dataInFrequenciesWarning", dataInFrequenciesWarning = new JLabel());
        
        dataInFrequenciesWarning.setName("dataInFrequenciesWarning");
        dataInFrequenciesWarning.setText(t("tutti.editBenthosFrequencies.simpleCountingAndFrequencies"));
    }

    protected void createDataInFrequenciesWarningContainer() {
        $objectMap.put("dataInFrequenciesWarningContainer", dataInFrequenciesWarningContainer = new JPanel());
        
        dataInFrequenciesWarningContainer.setName("dataInFrequenciesWarningContainer");
        dataInFrequenciesWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createFirstSplitPane() {
        $objectMap.put("firstSplitPane", firstSplitPane = new JSplitPane());
        
        firstSplitPane.setName("firstSplitPane");
        firstSplitPane.setOneTouchExpandable(true);
        firstSplitPane.setResizeWeight(0.6);
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.generate.help");
    }

    protected void createGenerateLengthStepsAction() {
        $objectMap.put("generateLengthStepsAction", generateLengthStepsAction = new GenerateBenthosFrequencyLengthStepsAction(this));
    }

    protected BenthosFrequencyUIHandler createHandler() {
        return new BenthosFrequencyUIHandler();
    }

    protected void createHistogramPanel() {
        $objectMap.put("histogramPanel", histogramPanel = new JPanel());
        
        histogramPanel.setName("histogramPanel");
        histogramPanel.setLayout(new BorderLayout());
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
        lengthStepCaracteristicComboBox.putClientProperty("help", "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        lengthStepCaracteristicComboBox.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic"));
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic"));
        lengthStepCaracteristicLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.lengthStepCaracteristic.tip"));
        lengthStepCaracteristicLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
    }

    protected void createLengthstepSettingsBlock() {
        $objectMap.put("lengthstepSettingsBlock", lengthstepSettingsBlock = new Table());
        
        lengthstepSettingsBlock.setName("lengthstepSettingsBlock");
    }

    protected void createLogsScrollPane() {
        $objectMap.put("logsScrollPane", logsScrollPane = new JScrollPane());
        
        logsScrollPane.setName("logsScrollPane");
    }

    protected void createLogsTable() {
        $objectMap.put("logsTable", logsTable = new JXTable());
        
        logsTable.setName("logsTable");
        logsTable.setSortable(false);
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setShowReset(true);
        maxStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.maxStep.help");
        maxStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(t("tutti.editBenthosFrequencies.field.maxStep"));
        maxStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.maxStep.tip"));
        maxStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.maxStep.help");
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setShowReset(true);
        minStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.minStep.help");
        minStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(t("tutti.editBenthosFrequencies.field.minStep"));
        minStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.minStep.tip"));
        minStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.minStep.help");
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
        rafaleModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.rafale.help");
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setShowReset(true);
        rafaleStepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.rafaleStep.help");
        rafaleStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(t("tutti.editBenthosFrequencies.field.rafaleStep"));
        rafaleStepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.rafaleStep.tip"));
        rafaleStepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.rafaleStep.help");
    }

    protected void createResetAction() {
        $objectMap.put("resetAction", resetAction = new ResetBenthosFrequencyAction(this));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.reset.help");
    }

    protected void createSaveAndCloseAction() {
        $objectMap.put("saveAndCloseAction", saveAndCloseAction = new SaveAndCloseBenthosFrequencyAction(this));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.saveAndClose.help");
    }

    protected void createSaveAndContinueAction() {
        $objectMap.put("saveAndContinueAction", saveAndContinueAction = new SaveAndContinueBenthosFrequencyAction(this));
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.putClientProperty("help", "tutti.editBenthosFrequencies.action.saveAndContinue.help");
    }

    protected void createSecondSplitPane() {
        $objectMap.put("secondSplitPane", secondSplitPane = new JSplitPane());
        
        secondSplitPane.setName("secondSplitPane");
        secondSplitPane.setOneTouchExpandable(true);
        secondSplitPane.setResizeWeight(0.1);
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(t("tutti.editBenthosFrequencies.field.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(t("tutti.editBenthosFrequencies.field.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
        simpleCountingModeButton.putClientProperty("help", "tutti.editBenthosFrequencies.field.mode.simpleCounting.help");
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setText(t("tutti.editBenthosFrequencies.label.no.configuration"));
        simpleCountingModeLabel.setEnabled(false);
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createSimpleCountingNumberField() {
        $objectMap.put("simpleCountingNumberField", simpleCountingNumberField = new NumberEditor(this));
        
        simpleCountingNumberField.setName("simpleCountingNumberField");
        simpleCountingNumberField.setProperty("simpleCount");
        simpleCountingNumberField.setShowReset(true);
        simpleCountingNumberField.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCountingNumber.help");
        simpleCountingNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createSimpleCountingNumberLabel() {
        $objectMap.put("simpleCountingNumberLabel", simpleCountingNumberLabel = new JLabel());
        
        simpleCountingNumberLabel.setName("simpleCountingNumberLabel");
        simpleCountingNumberLabel.setText(t("tutti.editBenthosFrequencies.field.simpleCountingNumber"));
        simpleCountingNumberLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.simpleCountingNumber.tip"));
        simpleCountingNumberLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCountingNumber.help");
    }

    protected void createSimpleCountingWeightField() {
        $objectMap.put("simpleCountingWeightField", simpleCountingWeightField = new NumberEditor(this));
        
        simpleCountingWeightField.setName("simpleCountingWeightField");
        simpleCountingWeightField.setProperty("data");
        simpleCountingWeightField.setShowReset(true);
        simpleCountingWeightField.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCountingWeight.help");
        simpleCountingWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSimpleCountingWeightLabel() {
        $objectMap.put("simpleCountingWeightLabel", simpleCountingWeightLabel = new JLabel());
        
        simpleCountingWeightLabel.setName("simpleCountingWeightLabel");
        simpleCountingWeightLabel.setText(t("tutti.editBenthosFrequencies.field.simpleCountingWeight"));
        simpleCountingWeightLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.simpleCountingWeight.tip"));
        simpleCountingWeightLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.simpleCountingWeight.help");
        simpleCountingWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setShowReset(true);
        stepField.putClientProperty("help", "tutti.editBenthosFrequencies.field.step.help");
        stepField.putClientProperty("selectOnFocus", true);
        stepField.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.step"));
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(t("tutti.editBenthosFrequencies.field.step"));
        stepLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.step.tip"));
        stepLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.step.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
        tableScrollPane.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.rows"));
    }

    protected void createTotalNumberField() {
        $objectMap.put("totalNumberField", totalNumberField = new JTextField());
        
        totalNumberField.setName("totalNumberField");
        totalNumberField.setColumns(15);
        totalNumberField.setEnabled(false);
        totalNumberField.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalNumber.help");
        totalNumberField.putClientProperty("computed", true);
    }

    protected void createTotalNumberLabel() {
        $objectMap.put("totalNumberLabel", totalNumberLabel = new JLabel());
        
        totalNumberLabel.setName("totalNumberLabel");
        totalNumberLabel.setText(t("tutti.editBenthosFrequencies.field.totalNumber"));
        totalNumberLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.totalNumber.tip"));
        totalNumberLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalNumber.help");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new ComputableDataEditor<Float>(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setShowReset(true);
        totalWeightField.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalWeight.help");
        totalWeightField.putClientProperty("selectOnFocus", true);
        totalWeightField.putClientProperty("validatorLabel", t("tutti.editBenthosFrequencies.field.totalWeight"));
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(t("tutti.editBenthosFrequencies.field.totalWeight"));
        totalWeightLabel.setToolTipText(t("tutti.editBenthosFrequencies.field.totalWeight.tip"));
        totalWeightLabel.putClientProperty("help", "tutti.editBenthosFrequencies.field.totalWeight.help");
        totalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToModePanel();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        addChildrenToLengthstepSettingsBlock();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), BorderLayout.CENTER);
        $JPanel1.add(addLengthStepCaracteristicButton, BorderLayout.EAST);
        addChildrenToDataFieldPanel();
        addChildrenToFirstSplitPane();
        addChildrenToSecondSplitPane();
        addChildrenToLogsScrollPane();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table2
        $Table2.add(dataInFrequenciesWarningContainer, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingNumberField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingWeightField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataInFrequenciesWarningContainer();
        addChildrenToActionPanel();
        
        // apply 29 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 74 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, null));
        autoGenModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.autoGen.mnemonic"),'Z'));
        rafaleModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.rafale.mnemonic"),'Z'));
        simpleCountingModeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosFrequencies.field.mode.simpleCounting.mnemonic"),'Z'));
        minStepLabel.setLabelFor(minStepField);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setNumberType(Float.class);
        minStepField.setNumberPattern(DECIMAL1_PATTERN);
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        minStepField.setBean(model);
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setNumberType(Float.class);
        maxStepField.setNumberPattern(DECIMAL1_PATTERN);
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepField.setBean(model);
        generateButton.setAction(generateLengthStepsAction);
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setNumberType(Float.class);
        rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        rafaleStepField.setBean(model);
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        addLengthStepCaracteristicButton.setAction(addLengthStepCaracteristicAction);
        stepLabel.setLabelFor(stepField);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setNumberType(Float.class);
        stepField.setNumberPattern(DECIMAL1_PATTERN);
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        stepField.setBean(model);
        totalNumberLabel.setLabelFor(totalNumberField);
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setNumberType(Float.class);
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        logsTable.setSelectionBackground(null);
        logsTable.setSelectionForeground(Color.BLACK);
        logsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionBackground(null);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        dataInFrequenciesWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        dataInFrequenciesWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        dataInFrequenciesWarning.setIcon(SwingUtil.createActionIcon("warning"));
        simpleCountingNumberLabel.setLabelFor(simpleCountingNumberField);
        simpleCountingNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingNumberField.setNumberType(Integer.class);
        simpleCountingNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
        simpleCountingNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingNumberField.setBean(model);
        simpleCountingWeightLabel.setLabelFor(simpleCountingWeightField);
        simpleCountingWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingWeightField.setNumberType(Float.class);
        simpleCountingWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setAction(cancelAction);
        resetButton.setAction(resetAction);
        saveAndContinueButton.setAction(saveAndContinueAction);
        saveAndCloseButton.setAction(saveAndCloseAction);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosFrequenciesTopPanel, "tutti.editBenthosFrequencies.help");
        registerHelpId(_broker, autoGenModeButton, "tutti.editBenthosFrequencies.field.mode.autoGen.help");
        registerHelpId(_broker, rafaleModeButton, "tutti.editBenthosFrequencies.field.mode.rafale.help");
        registerHelpId(_broker, simpleCountingModeButton, "tutti.editBenthosFrequencies.field.mode.simpleCounting.help");
        registerHelpId(_broker, minStepLabel, "tutti.editBenthosFrequencies.field.minStep.help");
        registerHelpId(_broker, minStepField, "tutti.editBenthosFrequencies.field.minStep.help");
        registerHelpId(_broker, maxStepLabel, "tutti.editBenthosFrequencies.field.maxStep.help");
        registerHelpId(_broker, maxStepField, "tutti.editBenthosFrequencies.field.maxStep.help");
        registerHelpId(_broker, generateButton, "tutti.editBenthosFrequencies.action.generate.help");
        registerHelpId(_broker, rafaleStepLabel, "tutti.editBenthosFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, rafaleStepField, "tutti.editBenthosFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, lengthStepCaracteristicLabel, "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, lengthStepCaracteristicComboBox, "tutti.editBenthosFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, addLengthStepCaracteristicButton, "tutti.editBenthosFrequencies.action.addLengthStepCaracteristic.help");
        registerHelpId(_broker, stepLabel, "tutti.editBenthosFrequencies.field.step.help");
        registerHelpId(_broker, stepField, "tutti.editBenthosFrequencies.field.step.help");
        registerHelpId(_broker, totalNumberLabel, "tutti.editBenthosFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalNumberField, "tutti.editBenthosFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalWeightLabel, "tutti.editBenthosFrequencies.field.totalWeight.help");
        registerHelpId(_broker, totalWeightField, "tutti.editBenthosFrequencies.field.totalWeight.help");
        registerHelpId(_broker, simpleCountingNumberLabel, "tutti.editBenthosFrequencies.field.simpleCountingNumber.help");
        registerHelpId(_broker, simpleCountingNumberField, "tutti.editBenthosFrequencies.field.simpleCountingNumber.help");
        registerHelpId(_broker, simpleCountingWeightLabel, "tutti.editBenthosFrequencies.field.simpleCountingWeight.help");
        registerHelpId(_broker, simpleCountingWeightField, "tutti.editBenthosFrequencies.field.simpleCountingWeight.help");
        registerHelpId(_broker, cancelButton, "tutti.editBenthosFrequencies.action.cancel.help");
        registerHelpId(_broker, resetButton, "tutti.editBenthosFrequencies.action.reset.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.editBenthosFrequencies.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.editBenthosFrequencies.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editBenthosFrequenciesTopPanel", editBenthosFrequenciesTopPanel);
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createAddLengthStepCaracteristicAction();
        createGenerateLengthStepsAction();
        createCancelAction();
        createResetAction();
        createSaveAndCloseAction();
        createSaveAndContinueAction();
        createConfigurationPanel();
        createModePanel();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        createLengthstepSettingsBlock();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createLengthStepCaracteristicComboBox();
        createAddLengthStepCaracteristicButton();
        createStepLabel();
        createStepField();
        createTotalNumberLabel();
        createTotalNumberField();
        createTotalWeightLabel();
        createTotalWeightField();
        createDataFieldPanel();
        createFirstSplitPane();
        createSecondSplitPane();
        createLogsScrollPane();
        createLogsTable();
        createTableScrollPane();
        createTable();
        createHistogramPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createDataInFrequenciesWarningContainer();
        createDataInFrequenciesWarning();
        createSimpleCountingNumberLabel();
        createSimpleCountingNumberField();
        createSimpleCountingWeightLabel();
        createSimpleCountingWeightField();
        createActionPanel();
        createCancelButton();
        createResetButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        createMode();
        // inline creation of editBenthosFrequenciesTopPanel
        setName("editBenthosFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editBenthosFrequenciesTopPanel.putClientProperty("help", "tutti.editBenthosFrequencies.help");
        
        // registers 29 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 29 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_LENGTH_STEPS_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateLengthStepsAction.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseAction.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_ACTION_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueAction.setEnabled(model.getNextEditableRowIndex() != null && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setNumberValue(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setNumberValue(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthstepSettingsBlock.setVisible(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_LENGTH_STEP_CARACTERISTIC_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addLengthStepCaracteristicButton.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setNumberValue(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("canEditLengthStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode() && model.isCanEditLengthStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("canEditLengthStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalNumberLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalNumberField, getStringValue(model.getTotalNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightLabel.setEnabled(model.getTotalWeight() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setNumberValue(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setBean(model.getTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null && model.getStep() > 0f);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rows", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getRows() != null && model.getEmptyRows() != null && model.getRowsInError() != null) {
                    dataInFrequenciesWarningContainer.setVisible((model.getRowsInError().size() + model.getEmptyRows().size()) != model.getRows().size());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rows", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_NUMBER_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingNumberField.setNumberValue(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingWeightField.setNumberValue(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingWeightField.setBean(model.getTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        });
    }

}