package fr.ifremer.tutti.ui.swing.content.genericformat;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ImportDataSelectTreeCellRenderer;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class GenericFormatImportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<GenericFormatImportUIModel, GenericFormatImportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTHORIZE_OBSOLETE_REFERENTIALS_CHECK_BOX_SELECTED = "authorizeObsoleteReferentialsCheckBox.selected";
    public static final String BINDING_CHECK_WEIGHTS_CHECK_BOX_ENABLED = "checkWeightsCheckBox.enabled";
    public static final String BINDING_CHECK_WEIGHTS_CHECK_BOX_SELECTED = "checkWeightsCheckBox.selected";
    public static final String BINDING_CLEAN_WEIGHTS_CHECK_BOX_ENABLED = "cleanWeightsCheckBox.enabled";
    public static final String BINDING_CLEAN_WEIGHTS_CHECK_BOX_SELECTED = "cleanWeightsCheckBox.selected";
    public static final String BINDING_DATA_SELECTION_TREE_ENABLED = "dataSelectionTree.enabled";
    public static final String BINDING_FOLD_ALL_BUTTON_ENABLED = "foldAllButton.enabled";
    public static final String BINDING_IMPORT_ACCIDENTAL_CATCH_CHECK_BOX_ENABLED = "importAccidentalCatchCheckBox.enabled";
    public static final String BINDING_IMPORT_ACCIDENTAL_CATCH_CHECK_BOX_SELECTED = "importAccidentalCatchCheckBox.selected";
    public static final String BINDING_IMPORT_ATTACHMENTS_CHECK_BOX_ENABLED = "importAttachmentsCheckBox.enabled";
    public static final String BINDING_IMPORT_ATTACHMENTS_CHECK_BOX_SELECTED = "importAttachmentsCheckBox.selected";
    public static final String BINDING_IMPORT_BENTHOS_CHECK_BOX_ENABLED = "importBenthosCheckBox.enabled";
    public static final String BINDING_IMPORT_BENTHOS_CHECK_BOX_SELECTED = "importBenthosCheckBox.selected";
    public static final String BINDING_IMPORT_BUTTON_ENABLED = "importButton.enabled";
    public static final String BINDING_IMPORT_FILE_SELECTED_FILE = "importFile.selectedFile";
    public static final String BINDING_IMPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_ENABLED = "importIndividualObservationCheckBox.enabled";
    public static final String BINDING_IMPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_SELECTED = "importIndividualObservationCheckBox.selected";
    public static final String BINDING_IMPORT_MARINE_LITTER_CHECK_BOX_ENABLED = "importMarineLitterCheckBox.enabled";
    public static final String BINDING_IMPORT_MARINE_LITTER_CHECK_BOX_SELECTED = "importMarineLitterCheckBox.selected";
    public static final String BINDING_IMPORT_PANEL_VISIBLE = "importPanel.visible";
    public static final String BINDING_IMPORT_RESULT_PANEL_VISIBLE = "importResultPanel.visible";
    public static final String BINDING_IMPORT_SPECIES_CHECK_BOX_ENABLED = "importSpeciesCheckBox.enabled";
    public static final String BINDING_IMPORT_SPECIES_CHECK_BOX_SELECTED = "importSpeciesCheckBox.selected";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_SELECT_ALL_BUTTON_ENABLED = "selectAllButton.enabled";
    public static final String BINDING_UNFOLD_ALL_BUTTON_ENABLED = "unfoldAllButton.enabled";
    public static final String BINDING_UNSELECT_ALL_BUTTON_ENABLED = "unselectAllButton.enabled";
    public static final String BINDING_UPDATE_CRUISES_CHECK_BOX_ENABLED = "updateCruisesCheckBox.enabled";
    public static final String BINDING_UPDATE_CRUISES_CHECK_BOX_SELECTED = "updateCruisesCheckBox.selected";
    public static final String BINDING_UPDATE_OPERATIONS_CHECK_BOX_ENABLED = "updateOperationsCheckBox.enabled";
    public static final String BINDING_UPDATE_OPERATIONS_CHECK_BOX_SELECTED = "updateOperationsCheckBox.selected";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";
    public static final String BINDING_VALIDATE_RESULT_PANEL_VISIBLE = "validateResultPanel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(GenericFormatImportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox authorizeObsoleteReferentialsCheckBox;
    protected TuttiHelpBroker broker;
    protected JCheckBox checkWeightsCheckBox;
    protected JCheckBox cleanWeightsCheckBox;
    protected JButton closeButton;
    protected JScrollPane dataSelectionPane;
    protected JTree dataSelectionTree;
    protected JToolBar dataSelectionTreeHeader;
    protected JButton foldAllButton;
    protected GenericFormatImportUI genericFormatImportTopPanel = this;
    protected final GenericFormatImportUIHandler handler = createHandler();
    protected JCheckBox importAccidentalCatchCheckBox;
    protected JCheckBox importAttachmentsCheckBox;
    protected JCheckBox importBenthosCheckBox;
    protected JButton importButton;
    protected JPanel importConfiguration;
    @ValidatorField( validatorId = "validator",  propertyName = "importFile",  editorName = "importFile")
    protected FileEditor importFile;
    protected JLabel importFileLabel;
    protected JCheckBox importIndividualObservationCheckBox;
    protected JCheckBox importMarineLitterCheckBox;
    protected JPanel importOptions;
    protected Table importPanel;
    protected JPanel importResultPanel;
    protected JLabel importResultText;
    protected JCheckBox importSpeciesCheckBox;
    protected GenericFormatImportUIModel model;
    protected JButton openImportReportButton;
    protected JButton openValidateReportButton;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    protected JButton saveImportReportButton;
    protected JButton saveValidateReportButton;
    protected JButton selectAllButton;
    protected DataSelectTreeModel treeModel;
    protected JButton unfoldAllButton;
    protected JButton unselectAllButton;
    protected JCheckBox updateCruisesCheckBox;
    protected JCheckBox updateOperationsCheckBox;
    protected JButton validateButton;
    protected Table validateFilePanel;
    protected JPanel validateResultPanel;
    protected JLabel validateResultText;
    @Validator( validatorId = "validator")
    protected SwingValidator<GenericFormatImportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JToolBar $JToolBar0;
    private JToolBar $JToolBar1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GenericFormatImportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public GenericFormatImportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI() {
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__importFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, "importFile");
    }

    public void doItemStateChanged__on__authorizeObsoleteReferentialsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "authorizeObsoleteReferentials");
    }

    public void doItemStateChanged__on__checkWeightsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "checkWeights");
    }

    public void doItemStateChanged__on__cleanWeightsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "cleanWeights");
    }

    public void doItemStateChanged__on__importAccidentalCatchCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importAccidentalCatch");
    }

    public void doItemStateChanged__on__importAttachmentsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importAttachments");
    }

    public void doItemStateChanged__on__importBenthosCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importBenthos");
    }

    public void doItemStateChanged__on__importIndividualObservationCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importIndividualObservation");
    }

    public void doItemStateChanged__on__importMarineLitterCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importMarineLitter");
    }

    public void doItemStateChanged__on__importSpeciesCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "importSpecies");
    }

    public void doItemStateChanged__on__updateCruisesCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "updateCruises");
    }

    public void doItemStateChanged__on__updateOperationsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "updateOperations");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAuthorizeObsoleteReferentialsCheckBox() {
        return authorizeObsoleteReferentialsCheckBox;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JCheckBox getCheckWeightsCheckBox() {
        return checkWeightsCheckBox;
    }

    public JCheckBox getCleanWeightsCheckBox() {
        return cleanWeightsCheckBox;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JScrollPane getDataSelectionPane() {
        return dataSelectionPane;
    }

    public JTree getDataSelectionTree() {
        return dataSelectionTree;
    }

    public JToolBar getDataSelectionTreeHeader() {
        return dataSelectionTreeHeader;
    }

    public JButton getFoldAllButton() {
        return foldAllButton;
    }

    public GenericFormatImportUIHandler getHandler() {
        return handler;
    }

    public JCheckBox getImportAccidentalCatchCheckBox() {
        return importAccidentalCatchCheckBox;
    }

    public JCheckBox getImportAttachmentsCheckBox() {
        return importAttachmentsCheckBox;
    }

    public JCheckBox getImportBenthosCheckBox() {
        return importBenthosCheckBox;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JPanel getImportConfiguration() {
        return importConfiguration;
    }

    public FileEditor getImportFile() {
        return importFile;
    }

    public JLabel getImportFileLabel() {
        return importFileLabel;
    }

    public JCheckBox getImportIndividualObservationCheckBox() {
        return importIndividualObservationCheckBox;
    }

    public JCheckBox getImportMarineLitterCheckBox() {
        return importMarineLitterCheckBox;
    }

    public JPanel getImportOptions() {
        return importOptions;
    }

    public Table getImportPanel() {
        return importPanel;
    }

    public JPanel getImportResultPanel() {
        return importResultPanel;
    }

    public JLabel getImportResultText() {
        return importResultText;
    }

    public JCheckBox getImportSpeciesCheckBox() {
        return importSpeciesCheckBox;
    }

    public GenericFormatImportUIModel getModel() {
        return model;
    }

    public JButton getOpenImportReportButton() {
        return openImportReportButton;
    }

    public JButton getOpenValidateReportButton() {
        return openValidateReportButton;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSaveImportReportButton() {
        return saveImportReportButton;
    }

    public JButton getSaveValidateReportButton() {
        return saveValidateReportButton;
    }

    public JButton getSelectAllButton() {
        return selectAllButton;
    }

    public DataSelectTreeModel getTreeModel() {
        return treeModel;
    }

    public JButton getUnfoldAllButton() {
        return unfoldAllButton;
    }

    public JButton getUnselectAllButton() {
        return unselectAllButton;
    }

    public JCheckBox getUpdateCruisesCheckBox() {
        return updateCruisesCheckBox;
    }

    public JCheckBox getUpdateOperationsCheckBox() {
        return updateOperationsCheckBox;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Table getValidateFilePanel() {
        return validateFilePanel;
    }

    public JPanel getValidateResultPanel() {
        return validateResultPanel;
    }

    public JLabel getValidateResultText() {
        return validateResultText;
    }

    public SwingValidator<GenericFormatImportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDataSelectionPane() {
        if (!allComponentsCreated) {
            return;
        }
        dataSelectionPane.getViewport().add(dataSelectionTree);
    }

    protected void addChildrenToDataSelectionTreeHeader() {
        if (!allComponentsCreated) {
            return;
        }
        dataSelectionTreeHeader.add(unfoldAllButton);
        dataSelectionTreeHeader.add(foldAllButton);
        dataSelectionTreeHeader.add(selectAllButton);
        dataSelectionTreeHeader.add(unselectAllButton);
    }

    protected void addChildrenToGenericFormatImportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(validateFilePanel, BorderLayout.NORTH);
        add(importPanel, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToImportConfiguration() {
        if (!allComponentsCreated) {
            return;
        }
        importConfiguration.add(dataSelectionPane, BorderLayout.CENTER);
        importConfiguration.add(importOptions, BorderLayout.EAST);
        importConfiguration.add(dataSelectionTreeHeader, BorderLayout.SOUTH);
    }

    protected void addChildrenToImportOptions() {
        if (!allComponentsCreated) {
            return;
        }
        importOptions.add($JPanel1, BorderLayout.NORTH);
    }

    protected void addChildrenToImportPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importPanel.add(importConfiguration, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        importPanel.add($JPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
        importPanel.add(importResultPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToImportResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importResultPanel.add(importResultText, BorderLayout.WEST);
        importResultPanel.add($JToolBar1, BorderLayout.EAST);
    }

    protected void addChildrenToValidateFilePanel() {
        if (!allComponentsCreated) {
            return;
        }
        validateFilePanel.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(importFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(SwingUtil.boxComponentWithJxLayer(importFile), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(authorizeObsoleteReferentialsCheckBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(validateResultPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidateResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        validateResultPanel.add(validateResultText, BorderLayout.WEST);
        validateResultPanel.add($JToolBar0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAuthorizeObsoleteReferentialsCheckBox() {
        $objectMap.put("authorizeObsoleteReferentialsCheckBox", authorizeObsoleteReferentialsCheckBox = new JCheckBox());
        
        authorizeObsoleteReferentialsCheckBox.setName("authorizeObsoleteReferentialsCheckBox");
        authorizeObsoleteReferentialsCheckBox.setText(t("tutti.genericFormatImport.field.authorizeObsoleteReferentials"));
        authorizeObsoleteReferentialsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.authorizeObsoleteReferentials.tip"));
        authorizeObsoleteReferentialsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__authorizeObsoleteReferentialsCheckBox"));
        authorizeObsoleteReferentialsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.authorizeObsoleteReferentials.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.genericFormatimport.help"));
    }

    protected void createCheckWeightsCheckBox() {
        $objectMap.put("checkWeightsCheckBox", checkWeightsCheckBox = new JCheckBox());
        
        checkWeightsCheckBox.setName("checkWeightsCheckBox");
        checkWeightsCheckBox.setText(t("tutti.genericFormatImport.field.checkWeights"));
        checkWeightsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.checkWeights.tip"));
        checkWeightsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__checkWeightsCheckBox"));
        checkWeightsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.checkWeights.help");
    }

    protected void createCleanWeightsCheckBox() {
        $objectMap.put("cleanWeightsCheckBox", cleanWeightsCheckBox = new JCheckBox());
        
        cleanWeightsCheckBox.setName("cleanWeightsCheckBox");
        cleanWeightsCheckBox.setText(t("tutti.genericFormatImport.field.cleanWeights"));
        cleanWeightsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.cleanWeights.tip"));
        cleanWeightsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__cleanWeightsCheckBox"));
        cleanWeightsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.cleanWeights.help");
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.genericFormatImport.action.closeGenericFormatImport"));
        closeButton.setToolTipText(t("tutti.genericFormatImport.action.closeGenericFormatImport.tip"));
        closeButton.putClientProperty("help", "tutti.genericFormatImport.action.closeGenericFormatImport.help");
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
    }

    protected void createDataSelectionPane() {
        $objectMap.put("dataSelectionPane", dataSelectionPane = new JScrollPane());
        
        dataSelectionPane.setName("dataSelectionPane");
    }

    protected void createDataSelectionTree() {
        $objectMap.put("dataSelectionTree", dataSelectionTree = new JTree());
        
        dataSelectionTree.setName("dataSelectionTree");
        dataSelectionTree.setEditable(false);
        dataSelectionTree.setToggleClickCount(2);
        dataSelectionTree.setScrollsOnExpand(true);
        dataSelectionTree.setRootVisible(false);
    }

    protected void createDataSelectionTreeHeader() {
        $objectMap.put("dataSelectionTreeHeader", dataSelectionTreeHeader = new JToolBar());
        
        dataSelectionTreeHeader.setName("dataSelectionTreeHeader");
        dataSelectionTreeHeader.setBorderPainted(false);
        dataSelectionTreeHeader.setFloatable(false);
    }

    protected void createFoldAllButton() {
        $objectMap.put("foldAllButton", foldAllButton = new JButton());
        
        foldAllButton.setName("foldAllButton");
        foldAllButton.setToolTipText(t("tutti.genericFormatImport.action.foldAll.tip"));
        foldAllButton.putClientProperty("help", "tutti.genericFormatImport.action.foldAll.help");
        foldAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ImportFoldAllDataAction.class);
    }

    protected GenericFormatImportUIHandler createHandler() {
        return new GenericFormatImportUIHandler();
    }

    protected void createImportAccidentalCatchCheckBox() {
        $objectMap.put("importAccidentalCatchCheckBox", importAccidentalCatchCheckBox = new JCheckBox());
        
        importAccidentalCatchCheckBox.setName("importAccidentalCatchCheckBox");
        importAccidentalCatchCheckBox.setText(t("tutti.genericFormatImport.field.importAccidentalCatch"));
        importAccidentalCatchCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importAccidentalCatch.tip"));
        importAccidentalCatchCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importAccidentalCatchCheckBox"));
        importAccidentalCatchCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importAccidentalCatch.help");
    }

    protected void createImportAttachmentsCheckBox() {
        $objectMap.put("importAttachmentsCheckBox", importAttachmentsCheckBox = new JCheckBox());
        
        importAttachmentsCheckBox.setName("importAttachmentsCheckBox");
        importAttachmentsCheckBox.setText(t("tutti.genericFormatImport.field.importAttachments"));
        importAttachmentsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importAttachments.tip"));
        importAttachmentsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importAttachmentsCheckBox"));
        importAttachmentsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importAttachments.help");
    }

    protected void createImportBenthosCheckBox() {
        $objectMap.put("importBenthosCheckBox", importBenthosCheckBox = new JCheckBox());
        
        importBenthosCheckBox.setName("importBenthosCheckBox");
        importBenthosCheckBox.setText(t("tutti.genericFormatImport.field.importBenthos"));
        importBenthosCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importBenthos.tip"));
        importBenthosCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importBenthosCheckBox"));
        importBenthosCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importBenthos.help");
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setText(t("tutti.genericFormatImport.action.import"));
        importButton.setToolTipText(t("tutti.genericFormatImport.action.import.tip"));
        importButton.putClientProperty("help", "tutti.genericFormatImport.action.import.help");
        importButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatImportAction.class);
    }

    protected void createImportConfiguration() {
        $objectMap.put("importConfiguration", importConfiguration = new JPanel());
        
        importConfiguration.setName("importConfiguration");
        importConfiguration.setLayout(new BorderLayout());
    }

    protected void createImportFile() {
        $objectMap.put("importFile", importFile = new FileEditor());
        
        importFile.setName("importFile");
        importFile.setAcceptAllFileFilterUsed(false);
        importFile.setShowReset(true);
        importFile.setDirectoryEnabled(false);
        importFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importFile"));
    }

    protected void createImportFileLabel() {
        $objectMap.put("importFileLabel", importFileLabel = new JLabel());
        
        importFileLabel.setName("importFileLabel");
        importFileLabel.setText(t("tutti.genericFormatImport.field.importFile"));
        importFileLabel.setToolTipText(t("tutti.genericFormatImport.field.importFile.tip"));
    }

    protected void createImportIndividualObservationCheckBox() {
        $objectMap.put("importIndividualObservationCheckBox", importIndividualObservationCheckBox = new JCheckBox());
        
        importIndividualObservationCheckBox.setName("importIndividualObservationCheckBox");
        importIndividualObservationCheckBox.setText(t("tutti.genericFormatImport.field.importIndividualObservation"));
        importIndividualObservationCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importIndividualObservation.tip"));
        importIndividualObservationCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importIndividualObservationCheckBox"));
        importIndividualObservationCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importIndividualObservation.help");
    }

    protected void createImportMarineLitterCheckBox() {
        $objectMap.put("importMarineLitterCheckBox", importMarineLitterCheckBox = new JCheckBox());
        
        importMarineLitterCheckBox.setName("importMarineLitterCheckBox");
        importMarineLitterCheckBox.setText(t("tutti.genericFormatImport.field.importMarineLitter"));
        importMarineLitterCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importMarineLitter.tip"));
        importMarineLitterCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importMarineLitterCheckBox"));
        importMarineLitterCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importMarineLitter.help");
    }

    protected void createImportOptions() {
        $objectMap.put("importOptions", importOptions = new JPanel());
        
        importOptions.setName("importOptions");
        importOptions.setLayout(new BorderLayout());
    }

    protected void createImportPanel() {
        $objectMap.put("importPanel", importPanel = new Table());
        
        importPanel.setName("importPanel");
    }

    protected void createImportResultPanel() {
        $objectMap.put("importResultPanel", importResultPanel = new JPanel());
        
        importResultPanel.setName("importResultPanel");
        importResultPanel.setLayout(new BorderLayout());
        SwingUtil.setComponentHeight(importResultPanel,50);
        importResultPanel.putClientProperty("help", "tutti.genericFormatImport.field.importResult.help");
    }

    protected void createImportResultText() {
        $objectMap.put("importResultText", importResultText = new JLabel());
        
        importResultText.setName("importResultText");
        importResultText.putClientProperty("help", "tutti.genericFormatImport.field.importResult.help");
    }

    protected void createImportSpeciesCheckBox() {
        $objectMap.put("importSpeciesCheckBox", importSpeciesCheckBox = new JCheckBox());
        
        importSpeciesCheckBox.setName("importSpeciesCheckBox");
        importSpeciesCheckBox.setText(t("tutti.genericFormatImport.field.importSpecies"));
        importSpeciesCheckBox.setToolTipText(t("tutti.genericFormatImport.field.importSpecies.tip"));
        importSpeciesCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importSpeciesCheckBox"));
        importSpeciesCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.importSpecies.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(GenericFormatImportUIModel.class));
    }

    protected void createOpenImportReportButton() {
        $objectMap.put("openImportReportButton", openImportReportButton = new JButton());
        
        openImportReportButton.setName("openImportReportButton");
        openImportReportButton.setToolTipText(t("tutti.genericFormatImport.action.openImportReport.tip"));
        SwingUtil.setComponentHeight(openImportReportButton,50);
        openImportReportButton.putClientProperty("help", "tutti.genericFormatImport.action.openImportReport.help");
        openImportReportButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.OpenGenericFormatImportReportAction.class);
    }

    protected void createOpenValidateReportButton() {
        $objectMap.put("openValidateReportButton", openValidateReportButton = new JButton());
        
        openValidateReportButton.setName("openValidateReportButton");
        openValidateReportButton.setToolTipText(t("tutti.genericFormatImport.action.openValidateReport.tip"));
        SwingUtil.setComponentHeight(openValidateReportButton,50);
        openValidateReportButton.putClientProperty("help", "tutti.genericFormatImport.action.openValidateReport.help");
        openValidateReportButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.OpenGenericFormatValidateReportAction.class);
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("help", "tutti.genericFormatImport.field.program.help");
        programComboBox.putClientProperty("validatorLabel", t("tutti.genericFormatImport.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.genericFormatImport.field.program"));
        programLabel.setToolTipText(t("tutti.genericFormatImport.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.genericFormatImport.field.program.help");
    }

    protected void createSaveImportReportButton() {
        $objectMap.put("saveImportReportButton", saveImportReportButton = new JButton());
        
        saveImportReportButton.setName("saveImportReportButton");
        saveImportReportButton.setToolTipText(t("tutti.genericFormatImport.action.saveImportReport.tip"));
        SwingUtil.setComponentHeight(saveImportReportButton,50);
        saveImportReportButton.putClientProperty("help", "tutti.genericFormatImport.action.saveImportReport.help");
        saveImportReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.SaveGenericFormatImportReportAction.class);
    }

    protected void createSaveValidateReportButton() {
        $objectMap.put("saveValidateReportButton", saveValidateReportButton = new JButton());
        
        saveValidateReportButton.setName("saveValidateReportButton");
        saveValidateReportButton.setToolTipText(t("tutti.genericFormatImport.action.saveValidateReport.tip"));
        SwingUtil.setComponentHeight(saveValidateReportButton,50);
        saveValidateReportButton.putClientProperty("help", "tutti.genericFormatValidate.action.saveValidateReport.help");
        saveValidateReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.SaveGenericFormatValidateReportAction.class);
    }

    protected void createSelectAllButton() {
        $objectMap.put("selectAllButton", selectAllButton = new JButton());
        
        selectAllButton.setName("selectAllButton");
        selectAllButton.setToolTipText(t("tutti.genericFormatImport.action.selectAll.tip"));
        selectAllButton.putClientProperty("help", "tutti.genericFormatImport.action.selectAll.help");
        selectAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ImportSelectAllDataAction.class);
    }

    protected void createTreeModel() {
        $objectMap.put("treeModel", treeModel = new DataSelectTreeModel());
    }

    protected void createUnfoldAllButton() {
        $objectMap.put("unfoldAllButton", unfoldAllButton = new JButton());
        
        unfoldAllButton.setName("unfoldAllButton");
        unfoldAllButton.setToolTipText(t("tutti.genericFormatImport.action.unfoldAll.tip"));
        unfoldAllButton.putClientProperty("help", "tutti.genericFormatImport.action.unfoldAll.help");
        unfoldAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ImportUnfoldAllDataAction.class);
    }

    protected void createUnselectAllButton() {
        $objectMap.put("unselectAllButton", unselectAllButton = new JButton());
        
        unselectAllButton.setName("unselectAllButton");
        unselectAllButton.setToolTipText(t("tutti.genericFormatImport.action.unselectAll.tip"));
        unselectAllButton.putClientProperty("help", "tutti.genericFormatImport.action.unselectAll.help");
        unselectAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ImportUnselectAllDataAction.class);
    }

    protected void createUpdateCruisesCheckBox() {
        $objectMap.put("updateCruisesCheckBox", updateCruisesCheckBox = new JCheckBox());
        
        updateCruisesCheckBox.setName("updateCruisesCheckBox");
        updateCruisesCheckBox.setText(t("tutti.genericFormatImport.field.updateCruises"));
        updateCruisesCheckBox.setToolTipText(t("tutti.genericFormatImport.field.updateCruises.tip"));
        updateCruisesCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__updateCruisesCheckBox"));
        updateCruisesCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.updateCruises.help");
    }

    protected void createUpdateOperationsCheckBox() {
        $objectMap.put("updateOperationsCheckBox", updateOperationsCheckBox = new JCheckBox());
        
        updateOperationsCheckBox.setName("updateOperationsCheckBox");
        updateOperationsCheckBox.setText(t("tutti.genericFormatImport.field.updateOperations"));
        updateOperationsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.updateOperations.tip"));
        updateOperationsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__updateOperationsCheckBox"));
        updateOperationsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.updateOperations.help");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.genericFormatImport.action.validate"));
        validateButton.setToolTipText(t("tutti.genericFormatImport.action.validate.tip"));
        validateButton.putClientProperty("help", "tutti.genericFormatImport.action.validate.help");
        validateButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatValidateAction.class);
    }

    protected void createValidateFilePanel() {
        $objectMap.put("validateFilePanel", validateFilePanel = new Table());
        
        validateFilePanel.setName("validateFilePanel");
    }

    protected void createValidateResultPanel() {
        $objectMap.put("validateResultPanel", validateResultPanel = new JPanel());
        
        validateResultPanel.setName("validateResultPanel");
        validateResultPanel.setLayout(new BorderLayout());
        SwingUtil.setComponentHeight(validateResultPanel,50);
        validateResultPanel.putClientProperty("help", "tutti.genericFormatImport.field.validateResult.help");
    }

    protected void createValidateResultText() {
        $objectMap.put("validateResultText", validateResultText = new JLabel());
        
        validateResultText.setName("validateResultText");
        validateResultText.putClientProperty("help", "tutti.genericFormatImport.field.validateResult.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(GenericFormatImportUIModel.class, "edit"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToGenericFormatImportTopPanel();
        addChildrenToValidator();
        addChildrenToValidateFilePanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(validateButton);
        addChildrenToValidateResultPanel();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(openValidateReportButton);
        $JToolBar0.add(saveValidateReportButton);
        addChildrenToImportPanel();
        addChildrenToImportConfiguration();
        addChildrenToDataSelectionPane();
        addChildrenToImportOptions();
        // inline complete setup of $JPanel1
        $JPanel1.add(updateCruisesCheckBox);
        $JPanel1.add(updateOperationsCheckBox);
        $JPanel1.add(importSpeciesCheckBox);
        $JPanel1.add(importBenthosCheckBox);
        $JPanel1.add(importMarineLitterCheckBox);
        $JPanel1.add(importAccidentalCatchCheckBox);
        $JPanel1.add(importIndividualObservationCheckBox);
        $JPanel1.add(importAttachmentsCheckBox);
        $JPanel1.add(cleanWeightsCheckBox);
        $JPanel1.add(checkWeightsCheckBox);
        addChildrenToDataSelectionTreeHeader();
        // inline complete setup of $JPanel2
        $JPanel2.add(importButton);
        addChildrenToImportResultPanel();
        // inline complete setup of $JToolBar1
        $JToolBar1.add(openImportReportButton);
        $JToolBar1.add(saveImportReportButton);
        // inline complete setup of $Table0
        $Table0.add($JPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel3
        $JPanel3.add(closeButton);
        
        // apply 33 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 36 property setters
        programComboBox.setBeanType(Program.class);
        validateFilePanel.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.validateImport.legend")));
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        importFileLabel.setLabelFor(importFile);
        importFile.setExtsDescription(t("tutti.genericFormatImport.importFile.extension.description"));
        importFile.setExts(t("tutti.genericFormatImport.importFile.extension"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.validate.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
        openValidateReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        saveValidateReportButton.setIcon(SwingUtil.createActionIcon("save"));
        importPanel.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.import.legend")));
        dataSelectionPane.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.selectData.legend")));
        dataSelectionPane.setColumnHeaderView(dataSelectionTreeHeader);
        dataSelectionTree.setCellRenderer(new ImportDataSelectTreeCellRenderer());
        dataSelectionTree.setModel(treeModel);
        importOptions.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.importOptions.legend")));
        unfoldAllButton.setIcon(SwingUtil.createActionIcon("expand"));
        foldAllButton.setIcon(SwingUtil.createActionIcon("collapse"));
        selectAllButton.setIcon(SwingUtil.createActionIcon("select"));
        unselectAllButton.setIcon(SwingUtil.createActionIcon("unselect"));
        importButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.import.mnemonic"),'Z'));
        importButton.setIcon(SwingUtil.createActionIcon("import"));
        openImportReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        saveImportReportButton.setIcon(SwingUtil.createActionIcon("save"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.closeGenericFormatImport.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, genericFormatImportTopPanel, "tutti.genericFormatImport.help");
        registerHelpId(_broker, programLabel, "tutti.genericFormatImport.field.program.help");
        registerHelpId(_broker, programComboBox, "tutti.genericFormatImport.field.program.help");
        registerHelpId(_broker, authorizeObsoleteReferentialsCheckBox, "tutti.genericFormatImport.field.authorizeObsoleteReferentials.help");
        registerHelpId(_broker, validateButton, "tutti.genericFormatImport.action.validate.help");
        registerHelpId(_broker, validateResultPanel, "tutti.genericFormatImport.field.validateResult.help");
        registerHelpId(_broker, validateResultText, "tutti.genericFormatImport.field.validateResult.help");
        registerHelpId(_broker, openValidateReportButton, "tutti.genericFormatImport.action.openValidateReport.help");
        registerHelpId(_broker, saveValidateReportButton, "tutti.genericFormatValidate.action.saveValidateReport.help");
        registerHelpId(_broker, updateCruisesCheckBox, "tutti.genericFormatImport.field.updateCruises.help");
        registerHelpId(_broker, updateOperationsCheckBox, "tutti.genericFormatImport.field.updateOperations.help");
        registerHelpId(_broker, importSpeciesCheckBox, "tutti.genericFormatImport.field.importSpecies.help");
        registerHelpId(_broker, importBenthosCheckBox, "tutti.genericFormatImport.field.importBenthos.help");
        registerHelpId(_broker, importMarineLitterCheckBox, "tutti.genericFormatImport.field.importMarineLitter.help");
        registerHelpId(_broker, importAccidentalCatchCheckBox, "tutti.genericFormatImport.field.importAccidentalCatch.help");
        registerHelpId(_broker, importIndividualObservationCheckBox, "tutti.genericFormatImport.field.importIndividualObservation.help");
        registerHelpId(_broker, importAttachmentsCheckBox, "tutti.genericFormatImport.field.importAttachments.help");
        registerHelpId(_broker, cleanWeightsCheckBox, "tutti.genericFormatImport.field.cleanWeights.help");
        registerHelpId(_broker, checkWeightsCheckBox, "tutti.genericFormatImport.field.checkWeights.help");
        registerHelpId(_broker, unfoldAllButton, "tutti.genericFormatImport.action.unfoldAll.help");
        registerHelpId(_broker, foldAllButton, "tutti.genericFormatImport.action.foldAll.help");
        registerHelpId(_broker, selectAllButton, "tutti.genericFormatImport.action.selectAll.help");
        registerHelpId(_broker, unselectAllButton, "tutti.genericFormatImport.action.unselectAll.help");
        registerHelpId(_broker, importButton, "tutti.genericFormatImport.action.import.help");
        registerHelpId(_broker, importResultPanel, "tutti.genericFormatImport.field.importResult.help");
        registerHelpId(_broker, importResultText, "tutti.genericFormatImport.field.importResult.help");
        registerHelpId(_broker, openImportReportButton, "tutti.genericFormatImport.action.openImportReport.help");
        registerHelpId(_broker, saveImportReportButton, "tutti.genericFormatImport.action.saveImportReport.help");
        registerHelpId(_broker, closeButton, "tutti.genericFormatImport.action.closeGenericFormatImport.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("genericFormatImportTopPanel", genericFormatImportTopPanel);
        createModel();
        createTreeModel();
        createBroker();
        createValidator();
        createValidateFilePanel();
        createProgramLabel();
        createProgramComboBox();
        createImportFileLabel();
        createImportFile();
        createAuthorizeObsoleteReferentialsCheckBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight($JPanel0,50);
        createValidateButton();
        createValidateResultPanel();
        createValidateResultText();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        createOpenValidateReportButton();
        createSaveValidateReportButton();
        createImportPanel();
        createImportConfiguration();
        createDataSelectionPane();
        createDataSelectionTree();
        createImportOptions();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0, 1));
        createUpdateCruisesCheckBox();
        createUpdateOperationsCheckBox();
        createImportSpeciesCheckBox();
        createImportBenthosCheckBox();
        createImportMarineLitterCheckBox();
        createImportAccidentalCatchCheckBox();
        createImportIndividualObservationCheckBox();
        createImportAttachmentsCheckBox();
        createCleanWeightsCheckBox();
        createCheckWeightsCheckBox();
        createDataSelectionTreeHeader();
        createUnfoldAllButton();
        createFoldAllButton();
        createSelectAllButton();
        createUnselectAllButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight($JPanel2,50);
        createImportButton();
        createImportResultPanel();
        createImportResultText();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setBorderPainted(false);
        $JToolBar1.setFloatable(false);
        createOpenImportReportButton();
        createSaveImportReportButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight($JPanel3,50);
        createCloseButton();
        // inline creation of genericFormatImportTopPanel
        setName("genericFormatImportTopPanel");
        setLayout(new BorderLayout());
        genericFormatImportTopPanel.putClientProperty("help", "tutti.genericFormatImport.help");
        
        // registers 33 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 33 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_FILE_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importFile.setSelectedFile(model.getImportFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTHORIZE_OBSOLETE_REFERENTIALS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("authorizeObsoleteReferentials", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    authorizeObsoleteReferentialsCheckBox.setSelected(model.isAuthorizeObsoleteReferentials());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("authorizeObsoleteReferentials", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canValidate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateButton.setEnabled(model.isCanValidate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canValidate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_RESULT_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validateResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateResultPanel.setVisible(model.getValidateResult() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validateResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validateDone", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("validateValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importPanel.setVisible(model.isValidateDone() && model.isValidateValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validateDone", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("validateValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_SELECTION_TREE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataSelectionTree.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPDATE_CRUISES_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    updateCruisesCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPDATE_CRUISES_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("updateCruises", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    updateCruisesCheckBox.setSelected(model.isUpdateCruises());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("updateCruises", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPDATE_OPERATIONS_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    updateOperationsCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPDATE_OPERATIONS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("updateOperations", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    updateOperationsCheckBox.setSelected(model.isUpdateOperations());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("updateOperations", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_SPECIES_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importSpeciesCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_SPECIES_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importSpeciesCheckBox.setSelected(model.isImportSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_BENTHOS_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importBenthosCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_BENTHOS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importBenthos", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importBenthosCheckBox.setSelected(model.isImportBenthos());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importBenthos", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_MARINE_LITTER_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importMarineLitterCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_MARINE_LITTER_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importMarineLitter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importMarineLitterCheckBox.setSelected(model.isImportMarineLitter());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importMarineLitter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_ACCIDENTAL_CATCH_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importAccidentalCatchCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_ACCIDENTAL_CATCH_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importAccidentalCatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importAccidentalCatchCheckBox.setSelected(model.isImportAccidentalCatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importAccidentalCatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importIndividualObservationCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importIndividualObservation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importIndividualObservationCheckBox.setSelected(model.isImportIndividualObservation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importIndividualObservation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_ATTACHMENTS_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importAttachmentsCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_ATTACHMENTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importAttachmentsCheckBox.setSelected(model.isImportAttachments());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLEAN_WEIGHTS_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cleanWeightsCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLEAN_WEIGHTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cleanWeights", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cleanWeightsCheckBox.setSelected(model.isCleanWeights());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cleanWeights", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHECK_WEIGHTS_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    checkWeightsCheckBox.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHECK_WEIGHTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("checkWeights", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    checkWeightsCheckBox.setSelected(model.isCheckWeights());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("checkWeights", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNFOLD_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    unfoldAllButton.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FOLD_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    foldAllButton.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECT_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectAllButton.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNSELECT_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    unselectAllButton.setEnabled(model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canImport", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importButton.setEnabled(model.isCanImport() && model.getImportResult() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canImport", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_RESULT_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importResultPanel.setVisible(model.getImportResult() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
    }

}