/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorComparator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class SnapshotGeneratorFactory {
    private static SnapshotGeneratorFactory instance;
    private List<SnapshotGenerator> generators = new ArrayList<SnapshotGenerator>();

    private SnapshotGeneratorFactory() {
        try {
            Class<SnapshotGenerator>[] classes;
            Class<SnapshotGenerator>[] classArray = classes = ServiceLocator.getInstance().findClasses(SnapshotGenerator.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<SnapshotGenerator> clazz = classArray[n2];
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static SnapshotGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new SnapshotGeneratorFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new SnapshotGeneratorFactory();
    }

    public void register(SnapshotGenerator generator) {
        this.generators.add(generator);
    }

    public void unregister(SnapshotGenerator generator) {
        this.generators.remove(generator);
    }

    public void unregister(Class generatorClass) {
        SnapshotGenerator toRemove = null;
        for (SnapshotGenerator existingGenerator : this.generators) {
            if (!existingGenerator.getClass().equals(generatorClass)) continue;
            toRemove = existingGenerator;
        }
        this.unregister(toRemove);
    }

    protected SortedSet<SnapshotGenerator> getGenerators(Class<? extends DatabaseObject> generatorClass, Database database) {
        TreeSet<SnapshotGenerator> validGenerators = new TreeSet<SnapshotGenerator>(new SnapshotGeneratorComparator(generatorClass, database));
        for (SnapshotGenerator generator : this.generators) {
            if (generator.getPriority(generatorClass, database) <= 0) continue;
            validGenerators.add(generator);
        }
        return validGenerators;
    }

    public boolean has(DatabaseObject example, Database database) throws DatabaseException, InvalidExampleException {
        ArrayList<Class<? extends DatabaseObject>> types = new ArrayList<Class<? extends DatabaseObject>>(this.getContainerTypes(example.getClass(), database));
        types.add(example.getClass());
        if (this.createSnapshot(example, database, new SnapshotControl(database, types.toArray(new Class[types.size()]))) != null) {
            return true;
        }
        CatalogAndSchema catalogAndSchema = example.getSchema() == null ? database.getDefaultSchema() : example.getSchema().toCatalogAndSchema();
        DatabaseSnapshot snapshot = this.createSnapshot(catalogAndSchema, database, new SnapshotControl(database, example.getClass()));
        for (DatabaseObject obj : snapshot.get(example.getClass())) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(example, obj, database)) continue;
            return true;
        }
        return false;
    }

    public DatabaseSnapshot createSnapshot(CatalogAndSchema example, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        return this.createSnapshot(new CatalogAndSchema[]{example}, database, snapshotControl);
    }

    public DatabaseSnapshot createSnapshot(CatalogAndSchema[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        if (database == null) {
            return null;
        }
        DatabaseObject[] schemas = new Schema[examples.length];
        int i = 0;
        while (i < schemas.length) {
            examples[i] = database.correctSchema(examples[i]);
            schemas[i] = new Schema(examples[i].getCatalogName(), examples[i].getSchemaName());
            ++i;
        }
        return this.createSnapshot(schemas, database, snapshotControl);
    }

    public DatabaseSnapshot createSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        if (database.getConnection() instanceof OfflineConnection) {
            throw new DatabaseException("Cannot snapshot offline database");
        }
        return new JdbcDatabaseSnapshot(examples, database, snapshotControl);
    }

    public <T extends DatabaseObject> T createSnapshot(T example, Database database) throws DatabaseException, InvalidExampleException {
        return this.createSnapshot(example, database, new SnapshotControl(database));
    }

    public <T extends DatabaseObject> T createSnapshot(T example, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        DatabaseSnapshot snapshot = this.createSnapshot(new DatabaseObject[]{example}, database, snapshotControl);
        return snapshot.get(example);
    }

    public Table getDatabaseChangeLogTable(SnapshotControl snapshotControl, Database database) throws DatabaseException {
        try {
            Table liquibaseTable = (Table)new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            return this.createSnapshot(liquibaseTable, database, snapshotControl);
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public Table getDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        try {
            Table example = (Table)new Table().setName(database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            return this.createSnapshot(example, database);
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public boolean hasDatabaseChangeLogTable(Database database) throws DatabaseException {
        try {
            return this.has(new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName())), database);
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public boolean hasDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        try {
            return this.has(new Table().setName(database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName())), database);
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static void resetAll() {
        instance = null;
    }

    public Set<Class<? extends DatabaseObject>> getContainerTypes(Class<? extends DatabaseObject> type, Database database) {
        HashSet<Class<? extends DatabaseObject>> returnSet = new HashSet<Class<? extends DatabaseObject>>();
        this.getContainerTypes(type, database, returnSet);
        return returnSet;
    }

    private void getContainerTypes(Class<? extends DatabaseObject> type, Database database, Set<Class<? extends DatabaseObject>> returnSet) {
        SnapshotGenerator generator;
        if (!returnSet.add(type)) {
            return;
        }
        SortedSet<SnapshotGenerator> generators = this.getGenerators(type, database);
        if (generators != null && generators.size() > 0 && (generator = (SnapshotGenerator)generators.iterator().next()).addsTo() != null) {
            Class<? extends DatabaseObject>[] classArray = generator.addsTo();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends DatabaseObject> newType = classArray[n2];
                returnSet.add(newType);
                this.getContainerTypes(newType, database, returnSet);
                ++n2;
            }
        }
    }
}

