/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.JCLLoggerAdapter;

public class JCLLoggerFactory
implements ILoggerFactory {
    private static final String JCL_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#jclDelegationLoop";
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger slf4jLogger = (Logger)this.loggerMap.get(name);
        if (slf4jLogger != null) {
            return slf4jLogger;
        }
        Log jclLogger = LogFactory.getLog((String)name);
        JCLLoggerAdapter newInstance = new JCLLoggerAdapter(jclLogger, name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    static {
        try {
            Class.forName("org.apache.commons.logging.impl.SLF4JLogFactory");
            String part1 = "Detected both jcl-over-slf4j.jar AND slf4j-jcl.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#jclDelegationLoop for more details.";
            Util.report((String)part1);
            Util.report((String)part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

