/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private Icon[] icons;
    private Layout layout;
    private int gap;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public CompoundIcon(Icon ... icons) {
        this(Layout.HORIZONTAL, icons);
    }

    public CompoundIcon(Layout layout, Icon ... icons) {
        this(layout, 0, icons);
    }

    public CompoundIcon(Layout layout, int gap, Icon ... icons) {
        this(layout, gap, 0.5f, 0.5f, icons);
    }

    public CompoundIcon(Layout layout, int gap, float alignmentX, float alignmentY, Icon ... icons) {
        this.layout = layout;
        this.gap = gap;
        float f = alignmentX > 1.0f ? 1.0f : (this.alignmentX = alignmentX < 0.0f ? 0.0f : alignmentX);
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] != null) continue;
            throw new IllegalArgumentException("Icon (" + i + ") cannot be null");
        }
        this.icons = icons;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    @Override
    public int getIconWidth() {
        int width = 0;
        if (this.layout == Layout.HORIZONTAL) {
            width += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                width += icon.getIconWidth();
            }
        } else {
            for (Icon icon : this.icons) {
                width = Math.max(width, icon.getIconWidth());
            }
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        int height = 0;
        if (this.layout == Layout.VERTICAL) {
            height += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                height += icon.getIconHeight();
            }
        } else {
            for (Icon icon : this.icons) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        return height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.layout == Layout.HORIZONTAL) {
            int height = this.getIconHeight();
            for (Icon icon : this.icons) {
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x, y + iconY);
                x += icon.getIconWidth() + this.gap;
            }
        } else if (this.layout == Layout.VERTICAL) {
            int width = this.getIconWidth();
            for (Icon icon : this.icons) {
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                icon.paintIcon(c, g, x + iconX, y);
                y += icon.getIconHeight() + this.gap;
            }
        } else {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            for (Icon icon : this.icons) {
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x + iconX, y + iconY);
            }
        }
    }

    private int getOffset(int maxValue, int iconValue, float alignment) {
        float offset = (float)(maxValue - iconValue) * alignment;
        return Math.round(offset);
    }

    public static enum Layout {
        HORIZONTAL,
        VERTICAL,
        STACKED;

    }
}

