/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class ImportMultiPostBenthosAction
extends ImportMultiPostActionSupport<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    public ImportMultiPostBenthosAction(BenthosBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiBenthos";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n.t((String)"tutti.common.file.tuttiBenthos", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n.t((String)"tutti.editBenthosBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n.t((String)"tutti.editBenthosBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    protected String getSuccessMessage(File file) {
        return I18n.t((String)"tutti.editBenthosBatch.action.importMultiPost.success", (Object[])new Object[]{file});
    }

    @Override
    protected Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        Map notImportedData = multiPostImportExportService.importBenthos(file, operation);
        return notImportedData;
    }

    @Override
    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        WeightUnit benthosWeightUnit = this.getConfig().getBenthosWeightUnit();
        StringBuilder builder = new StringBuilder();
        Float totalSortedWeight = (Float)notImportedData.get("benthosTotalSortedWeight");
        this.addNotImportedWeightToReport(builder, totalSortedWeight, benthosWeightUnit, I18n.n((String)"tutti.multiPostImportLog.totalSortedWeight", (Object[])new Object[0]));
        Float inertWeight = (Float)notImportedData.get("benthosTotalInertWeight");
        this.addNotImportedWeightToReport(builder, inertWeight, benthosWeightUnit, I18n.n((String)"tutti.multiPostImportLog.inertWeight", (Object[])new Object[0]));
        Float livingNotItemizedWeight = (Float)notImportedData.get("benthosTotalLivingNotItemizedWeight");
        this.addNotImportedWeightToReport(builder, livingNotItemizedWeight, benthosWeightUnit, I18n.n((String)"tutti.multiPostImportLog.livingNotItemizedWeight", (Object[])new Object[0]));
        Collection notImportedBenthosBatches = (Collection)notImportedData.get("batchesKey");
        for (BenthosBatch sb : notImportedBenthosBatches) {
            builder.append("- ").append(this.decorate(sb.getSpecies())).append(" / ").append(this.decorate(sb.getSampleCategoryValue())).append("\n");
        }
        return builder.toString();
    }
}

