/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.ObjectTypes;
import fr.ifremer.tutti.persistence.service.referential.ObjectTypePersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.type.StringType;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;

@Service(value="objectTypePersistenceService")
public class ObjectTypePersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements ObjectTypePersistenceService {
    @Override
    public List<ObjectType> getAllObjectType() {
        Iterator<Object[]> sources = this.queryList("allObjectType", new Object[0]);
        ArrayList result = Lists.newArrayList();
        Cache cache = this.cacheService.getCache("objectTypeByCode");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            String code = (String)source[0];
            ObjectType target = this.loadObjectType(source);
            cache.put((Object)code, (Object)target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        Object[] source = this.queryUnique("objectType", "objectTypeCode", StringType.INSTANCE, objectTypeCode);
        ObjectType target = this.loadObjectType(source);
        return target;
    }

    protected ObjectType loadObjectType(Object[] source) {
        ObjectType result = ObjectTypes.newObjectType();
        result.setId((String)source[0]);
        result.setName((String)source[1]);
        result.setDescription((String)source[2]);
        return result;
    }
}

