/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher {
    private String text;
    private Pattern[] patterns;
    private boolean allMatched;

    public RegexMatcher(String text, String[] regexToMatch) {
        assert (text != null && regexToMatch != null);
        this.text = text;
        this.patterns = new Pattern[regexToMatch.length];
        int i = 0;
        while (i < regexToMatch.length) {
            this.patterns[i] = Pattern.compile(regexToMatch[i], 10);
            ++i;
        }
        this.allMatched = this.checkMatchingInSequentialOrder();
    }

    private boolean checkMatchingInSequentialOrder() {
        int index = 0;
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            Matcher m = p.matcher(this.text.substring(index));
            if (!m.find()) {
                return false;
            }
            index += m.end();
            ++n2;
        }
        return true;
    }

    public boolean allMatchedInSequentialOrder() {
        return this.allMatched;
    }
}

