/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.pupitri.csv.SpeciesRow;
import fr.ifremer.tutti.service.pupitri.csv.SpeciesRowModel;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class PupitriExportService
extends AbstractTuttiService {
    public void exportSpecies(List<Species> species, File target) {
        SpeciesRowModel speciesCsvModel = new SpeciesRowModel(';');
        List rows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(species)) {
            rows = Lists.transform(species, (Function)new Function<Species, SpeciesRow>(){

                public SpeciesRow apply(Species input) {
                    SpeciesRow row = new SpeciesRow(input);
                    return row;
                }
            });
        }
        try {
            Export.exportToFile((ExportModel)speciesCsvModel, (Iterable)rows, (File)target, (Charset)Charsets.UTF_8, (boolean)false);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.export.species.error", (Object[])new Object[]{target}), (Throwable)e);
        }
    }
}

