/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameSpeciesBatchAction
extends LongActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        List referents = this.getDataContext().getReferentSpecies();
        Map<String, Species> referentsById = Speciess.splitReferenceSpeciesByReferenceTaxonId(referents);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)((SpeciesBatchUIHandler)this.handler).getModel();
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Object categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsedForFirstCategory = model.getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        ArrayList speciesList = Lists.newArrayList((Iterable)this.getDataContext().getReferentSpeciesWithSurveyCode(true));
        speciesList.removeAll(speciesUsedForFirstCategory);
        ArrayList<Species> allSpeciesList = new ArrayList<Species>(this.getDataContext().getSpecies());
        allSpeciesList.removeAll(speciesUsedForFirstCategory);
        allSpeciesList.removeAll(this.getDataContext().getReferentBenthosWithSurveyCode(true));
        Multimap<String, Species> speciesByReferent = Speciess.splitByReferenceTaxonId(allSpeciesList);
        for (Species species : speciesUsedForFirstCategory) {
            Collection synonyms = speciesByReferent.get((Object)String.valueOf(species.getReferenceTaxonId()));
            allSpeciesList.removeAll(synonyms);
        }
        this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpecies.title", (Object[])new Object[0]), allSpeciesList, speciesList);
        if (this.selectedSpecies != null && !this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies, "fromProtocol");
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies, "fromProtocol");
            this.sendMessage(I18n.t((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        return result &= this.selectedSpecies != null;
    }

    public void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        persistenceService.changeSpeciesBatchSpecies(row.getId(), this.selectedSpecies);
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Object categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsed = ((SpeciesBatchUIModel)this.getModel()).getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

