/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential.synchro;

import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroDatabaseMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroResult;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroServiceImpl;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableMetadata;
import fr.ifremer.tutti.persistence.service.referential.synchro.ReferentialUpdateTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="referentialSynchroServiceTutti")
@Lazy
public class TuttiReferentialSynchroServiceImpl
extends ReferentialSynchroServiceImpl {
    private static final Log log = LogFactory.getLog(TuttiReferentialSynchroServiceImpl.class);
    protected Map<String, ReferentialUpdateTask> updateTasks;

    protected Map<String, ReferentialUpdateTask> getUpdateTasks() {
        if (this.updateTasks == null) {
            this.updateTasks = Maps.newHashMap();
            ServiceLoader<ReferentialUpdateTask> loader = ServiceLoader.load(ReferentialUpdateTask.class);
            for (ReferentialUpdateTask task : loader) {
                this.updateTasks.put(task.getTable(), task);
            }
        }
        return this.updateTasks;
    }

    protected void synchronizeTable(ReferentialSynchroDatabaseMetadata dbMetas, ReferentialSynchroTableMetadata table, Connection localConnection, Connection remoteConnection, ReferentialSynchroResult result) throws SQLException {
        Timestamp lastUpdate = this.getLastUpdateDate(localConnection, table);
        super.synchronizeTable(dbMetas, table, localConnection, remoteConnection, result);
        String tableName = table.getName();
        ReferentialUpdateTask updateTask = this.getUpdateTasks().get(tableName);
        if (updateTask != null && log.isInfoEnabled()) {
            log.info((Object)(table.getTableLogPrefix() + " - " + result.getNbRows(tableName) + " Will use specific update task: " + updateTask));
        }
        if (updateTask != null) {
            updateTask.update(localConnection, lastUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timestamp getLastUpdateDate(Connection connection, ReferentialSynchroTableMetadata table) throws SQLException {
        Timestamp result = null;
        if (table.isWithUpdateDateColumn()) {
            String sql = table.getSelectMaxUpdateDateQuery();
            PreparedStatement statement = connection.prepareStatement(sql);
            try {
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getTimestamp(1);
                }
                statement.close();
            }
            finally {
                this.closeSilently(statement);
            }
        }
        return result;
    }

    protected void closeSilently(Statement statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }
}

