/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PdfGeneratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.csv.ImportModelWithHeader;
import fr.ifremer.tutti.service.pupitri.CarrouselImportRequestResult;
import fr.ifremer.tutti.service.pupitri.PupitriImportResult;
import fr.ifremer.tutti.service.pupitri.PupitriSpeciesContext;
import fr.ifremer.tutti.service.pupitri.Signs;
import fr.ifremer.tutti.service.pupitri.csv.CarrouselRow;
import fr.ifremer.tutti.service.pupitri.csv.CarrouselRowModel;
import fr.ifremer.tutti.service.pupitri.csv.TrunkRow;
import fr.ifremer.tutti.service.pupitri.csv.TrunkRowModel;
import fr.ifremer.tutti.service.pupitri.report.PupitriImportReportModel;
import fr.ifremer.tutti.service.pupitri.report.PupitriImportReportRow;
import fr.ifremer.tutti.util.Weights;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class PupitriImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(PupitriImportService.class);
    protected DecoratorService decoratorService;
    protected PersistenceService persistenceService;
    protected PdfGeneratorService pdfGeneratorService;
    protected TuttiDataContext dataContext;
    protected CaracteristicQualitativeValue sortedCaracteristic;
    protected CaracteristicQualitativeValue unsortedCaracteristic;
    protected Map<Signs, CaracteristicQualitativeValue> signsToCaracteristicValue;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.pdfGeneratorService = this.getService(PdfGeneratorService.class);
        this.dataContext = context.getDataContext();
        this.signsToCaracteristicValue = Maps.newEnumMap(Signs.class);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.sortedCaracteristic = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)QualitativeValueId.SORTED_VRAC.getValue());
        this.unsortedCaracteristic = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)QualitativeValueId.SORTED_HORS_VRAC.getValue());
        caracteristic = this.persistenceService.getSexCaracteristic();
        Signs.DEFAULT.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.FEMALE.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.MALE.registerSign(caracteristic, this.signsToCaracteristicValue);
        caracteristic = this.persistenceService.getSizeCategoryCaracteristic();
        Signs.SMALL.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.MEDIUM.registerSign(caracteristic, this.signsToCaracteristicValue);
        Signs.BIG.registerSign(caracteristic, this.signsToCaracteristicValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PupitriImportResult importPupitri(File trunkFile, File carrouselFile, FishingOperation operation, CatchBatch catchBatch) {
        PupitriImportResult result = new PupitriImportResult();
        this.importPupitriTrunk(result, trunkFile, operation);
        this.importPupitriCarrousel(result, carrouselFile, operation);
        if (result.isFishingOperationFound()) {
            File reportFile = this.generatePupitriReport(operation, result);
            Decorator<Species> decorator = this.getService(DecoratorService.class).getDecoratorByType(Species.class);
            result.prepareMelag(decorator);
            try {
                this.savePupitriImportResult(result, operation, catchBatch);
                this.addFileAsAttachment(trunkFile, catchBatch);
                this.addFileAsAttachment(carrouselFile, catchBatch);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd__HH_mm");
                String reportAttachmentFilename = "rapport-pupitri-" + simpleDateFormat.format(this.context.currentDate()) + ".pdf";
                if (log.isInfoEnabled()) {
                    log.info((Object)("Save report with attachment filename: " + reportAttachmentFilename));
                }
                String reportId = this.addFileAsAttachment(reportFile, reportAttachmentFilename, catchBatch);
                result.setReportAttachmentId(reportId);
                result.setReportAttachmentFilename(reportAttachmentFilename);
            }
            finally {
                FileUtils.deleteQuietly((File)reportFile);
            }
        }
        return result;
    }

    protected File generatePupitriReport(FishingOperation operation, PupitriImportResult result) {
        TaxonCache taxonCache = TaxonCaches.createSpeciesCache((TuttiPersistence)this.persistenceService, (TuttiProtocol)this.context.getDataContext().getProtocol());
        PupitriImportReportModel reportModel = new PupitriImportReportModel(operation, result);
        for (PupitriSpeciesContext aCatch : result.getCatches()) {
            this.addCatchEntry(taxonCache, aCatch, reportModel);
        }
        reportModel.sortRows();
        File reportFile = this.context.getConfig().newTempFile("puputri-report", ".pdf");
        Locale locale = this.context.getConfig().getI18nLocale();
        this.pdfGeneratorService.generatePdf(reportFile, locale, "pupitriReport.ftl", reportModel);
        return reportFile;
    }

    protected void addCatchEntry(TaxonCache taxonCache, PupitriSpeciesContext aCatch, PupitriImportReportModel reportModel) {
        Species species = aCatch.getSpecies();
        taxonCache.load(species);
        String code = Speciess.getSurveyCodeOrRefTaxCode((Species)species);
        String name = species.getName();
        String vernacularCode = species.getVernacularCode();
        for (Signs signs : aCatch.getSigns()) {
            PupitriImportReportRow reportCatch = PupitriImportReportRow.newRow(code, name, vernacularCode, aCatch.isSorted(), aCatch.getSignContext(signs));
            reportModel.addRow(reportCatch);
        }
    }

    protected String addFileAsAttachment(File f, CatchBatch catchBatch) {
        return this.addFileAsAttachment(f, f.getName(), catchBatch);
    }

    protected String addFileAsAttachment(File f, String attachmentName, CatchBatch catchBatch) {
        Attachment attachment = Attachments.newAttachment();
        attachment.setObjectType(ObjectTypeCode.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(attachmentName);
        String date = DateFormat.getDateTimeInstance().format(this.context.currentDate());
        String comment = I18n.t((String)"tutti.service.pupitri.import.attachment.comment", (Object[])new Object[]{date});
        attachment.setComment(comment);
        Attachment savedAttachment = this.persistenceService.createAttachment(attachment, f);
        return savedAttachment.getId();
    }

    protected void importPupitriTrunk(PupitriImportResult result, File file, FishingOperation operation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] trunk from file: " + file));
        }
        float sortedWeight = 0.0f;
        float rejectedWeight = 0.0f;
        TrunkRowModel csvModel = new TrunkRowModel(',');
        File fileWithHeaders = this.createFileWithHeaders(csvModel, file);
        try (Reader reader = ApplicationIOUtil.newReader((File)fileWithHeaders, (String)I18n.n((String)"tutti.service.pupitri.import.trunk.error", (Object[])new Object[0]));
             Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
            for (TrunkRow bean : importer) {
                if (bean.acceptOperation(operation)) {
                    switch (bean.getDirection()) {
                        case VAT: {
                            sortedWeight += bean.getWeight().floatValue();
                            break;
                        }
                        case VNT: {
                            rejectedWeight += bean.getWeight().floatValue();
                        }
                    }
                    result.incrementNbTrunkImported();
                    continue;
                }
                result.incrementNbTrunkNotImported();
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.import.trunk.error", (Object[])new Object[]{operation.toString(), file}), (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)fileWithHeaders);
        }
        result.setSortedWeight(Float.valueOf(Weights.roundKiloGram((float)sortedWeight)));
        if (rejectedWeight > 0.0f) {
            result.setRejectedWeight(Float.valueOf(Weights.roundKiloGram((float)rejectedWeight)));
        }
    }

    protected void importPupitriCarrousel(PupitriImportResult result, File carrouselFile, FishingOperation operation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import pupitri operation [" + operation.toString() + "] carrousel from file: " + carrouselFile));
        }
        CarrouselImportRequestResult carrouselImportRequestResult = this.processCarrouselImportFile(carrouselFile, operation);
        result.flushCarrouselResult(carrouselImportRequestResult);
    }

    protected CarrouselImportRequestResult processCarrouselImportFile(File carrouselFile, FishingOperation operation) {
        ArrayListMultimap speciesBySurveyCode = ArrayListMultimap.create();
        speciesBySurveyCode.putAll(Speciess.splitBySurveyCode(this.dataContext.getReferentSpeciesWithSurveyCode()));
        speciesBySurveyCode.putAll(Speciess.splitByRefTaxCode(this.dataContext.getReferentSpecies()));
        CarrouselImportRequestResult result = new CarrouselImportRequestResult((ListMultimap<String, Species>)speciesBySurveyCode);
        CarrouselRowModel carrouselCsvModel = new CarrouselRowModel(',');
        File fileWithHeaders = this.createFileWithHeaders(carrouselCsvModel, carrouselFile);
        try (Reader reader = ApplicationIOUtil.newReader((File)fileWithHeaders, (String)I18n.n((String)"tutti.service.pupitri.import.carrousel.error", (Object[])new Object[0]));
             Import importer = Import.newImport((ImportModel)carrouselCsvModel, (Reader)reader);){
            for (CarrouselRow bean : importer) {
                this.importCarrouselRow(result, operation, bean);
            }
        }
        catch (Exception e) {
            DecoratorService service = this.getService(DecoratorService.class);
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.pupitri.import.carrousel.error", (Object[])new Object[]{carrouselFile, service.getDecorator(operation).toString((Object)operation)}), (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)fileWithHeaders);
        }
        return result;
    }

    protected void importCarrouselRow(CarrouselImportRequestResult result, FishingOperation operation, CarrouselRow bean) {
        boolean sorted;
        if (!bean.acceptOperation(operation)) {
            return;
        }
        result.incrementNbCarrousselImported();
        Float beanWeight = bean.getWeight();
        if (beanWeight.floatValue() < 0.0f) {
            beanWeight = Float.valueOf(0.0f);
        }
        if (sorted = bean.isSorted()) {
            result.addCarrouselSortedWeight(beanWeight);
        } else {
            result.addCarrouselUnsortedWeight(beanWeight);
        }
        String speciesId = bean.getSpeciesId();
        List<Species> speciesList = result.getSpecies(speciesId);
        if (CollectionUtils.isEmpty(speciesList)) {
            result.addNotImportedSpeciesId(speciesId);
        } else {
            PupitriSpeciesContext pupitriSpeciesContext = result.getOrCreateCatch(speciesList, sorted);
            pupitriSpeciesContext.addToSignContext(bean.getSign(), bean.getBoxType(), beanWeight);
        }
    }

    protected void savePupitriImportResult(PupitriImportResult result, FishingOperation operation, CatchBatch catchBatch) {
        catchBatch.setCatchTotalSortedTremisWeight(result.getSortedWeight());
        catchBatch.setCatchTotalRejectedWeight(result.getRejectedWeight());
        catchBatch.setCatchTotalSortedCarousselWeight(result.getCarrouselSortedWeight());
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId(), false);
        for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
            this.persistenceService.deleteSpeciesBatch(batch.getId());
        }
        String melagComment = result.getMelagComment();
        Decorator<Species> speciesDecorator = this.decoratorService.getDecoratorByType(Species.class);
        for (PupitriSpeciesContext pupitriSpeciesContext : result.getCatches()) {
            Species species = pupitriSpeciesContext.getSpecies();
            CaracteristicQualitativeValue cqv = pupitriSpeciesContext.isSorted() ? this.sortedCaracteristic : this.unsortedCaracteristic;
            boolean splitSpecies = pupitriSpeciesContext.isSplitSpecies();
            String speciesStr = speciesDecorator.toString((Object)species);
            if (splitSpecies) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create a categorized batches for species " + speciesStr));
                }
                SpeciesBatch batch = this.createSpeciesBatch(operation, species, null, PmfmId.SORTED_UNSORTED.getValue(), (Serializable)cqv);
                batch = this.persistenceService.createSpeciesBatch(batch, null, true);
                String parentBatchId = batch.getId();
                for (Signs signs : pupitriSpeciesContext.getSigns()) {
                    boolean addMelagComment = pupitriSpeciesContext.isAddMelagComment(signs);
                    float catchWeight = pupitriSpeciesContext.getWeight(signs);
                    Integer categoryId = signs.getCategory();
                    CaracteristicQualitativeValue splitCqv = this.signsToCaracteristicValue.get((Object)signs);
                    SpeciesBatch childBatch = this.createSpeciesBatch(operation, species, Float.valueOf(catchWeight), categoryId, (Serializable)splitCqv);
                    if (addMelagComment) {
                        childBatch.setComment(melagComment);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Add melag comment for sign " + (Object)((Object)signs) + " on " + speciesStr));
                        }
                    }
                    this.persistenceService.createSpeciesBatch(childBatch, parentBatchId, true);
                }
                continue;
            }
            float totalWeight = pupitriSpeciesContext.getTotalWeight();
            if (log.isInfoEnabled()) {
                log.info((Object)("Create a unique batch for species " + speciesStr + " with total weight: " + totalWeight));
            }
            SpeciesBatch batch = this.createSpeciesBatch(operation, species, Float.valueOf(totalWeight), PmfmId.SORTED_UNSORTED.getValue(), (Serializable)cqv);
            boolean addMelagComment = pupitriSpeciesContext.isAddMelagComment(Signs.DEFAULT);
            if (addMelagComment) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Add melag comment for simple batch " + speciesStr));
                }
                batch.setComment(melagComment);
            }
            this.persistenceService.createSpeciesBatch(batch, null, true);
        }
        this.persistenceService.saveCatchBatch(catchBatch);
    }

    protected SpeciesBatch createSpeciesBatch(FishingOperation operation, Species species, Float catchWeight, Integer categoryId, Serializable cqv) {
        SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
        batch.setFishingOperation(operation);
        batch.setSampleCategoryId(categoryId);
        batch.setSampleCategoryValue(cqv);
        batch.setSpecies(species);
        batch.setSampleCategoryWeight(catchWeight == null ? null : Float.valueOf(Weights.roundKiloGram((float)catchWeight.floatValue())));
        return batch;
    }

    protected File createFileWithHeaders(ImportModelWithHeader<?> model, File file) {
        File fileWithHeaders = new File(FileUtils.getTempDirectory(), file.getName());
        String headers = StringUtils.join((Object[])model.getHeader(), (char)model.getSeparator());
        try {
            FileUtils.writeLines((File)fileWithHeaders, Collections.singletonList(headers));
            FileUtils.writeLines((File)fileWithHeaders, (Collection)FileUtils.readLines((File)file), (boolean)true);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create file with header " + file, (Throwable)e);
        }
        return fileWithHeaders;
    }
}

