/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentModel;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class CsvProducerForAttachment
extends CsvProducer<AttachmentRow, AttachmentModel> {
    private final Path sourcePath;
    private final Path targetPath;

    public CsvProducerForAttachment(Path file, AttachmentModel model, Path sourcePath, Path targetPath) {
        super(file, model);
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
    }

    @Override
    public void write(List<AttachmentRow> rows) throws Exception {
        super.write(rows);
        for (AttachmentRow row : rows) {
            String path = row.getPath();
            Path source = this.sourcePath.resolve(path);
            Path target = this.targetPath.resolve(path);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, new CopyOption[0]);
        }
    }

    public void addAttachments(List<Attachment> attachments, List<AttachmentRow> rows) {
        for (Attachment attachment : attachments) {
            AttachmentRow row = new AttachmentRow();
            row.setAttachment(attachment);
            rows.add(row);
        }
    }
}

