/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.update;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ui.swing.update.TuttiUpdaterCallBackSupport;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.updater.DownloadMonitor;

public class Updates {
    public static ApplicationInfo getDatabaseUpdateVersion(TuttiConfiguration config) {
        ApplicationUpdater up = new ApplicationUpdater();
        String updateDataUrl = config.getUpdateDataUrl();
        File dataDirectory = config.getDataDirectory();
        Map dbVersions = up.getVersions(updateDataUrl, dataDirectory);
        ApplicationInfo applicationInfo = (ApplicationInfo)dbVersions.get(UpdateModule.db.name());
        return applicationInfo;
    }

    public static <C extends TuttiUpdaterCallBackSupport> void doUpdate(TuttiConfiguration config, C callback, File current) {
        File dest = new File(config.getBasedir(), "NEW");
        ApplicationUpdater up = new ApplicationUpdater();
        String url = callback.getUrl();
        up.update(url, current, dest, false, callback, (DownloadMonitor)callback.getProgressionModel());
    }

    public static UpdateModule[] getApplicationModules() {
        HashSet<UpdateModule> result = new HashSet<UpdateModule>();
        for (UpdateModule updateModule : UpdateModule.values()) {
            if (!updateModule.getModuleConfiguration().isApplication()) continue;
            result.add(updateModule);
        }
        return result.toArray(new UpdateModule[result.size()]);
    }
}

