package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class CreateMarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterCategoryComboBox.selectedItem";
    public static final String BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_PATTERN = "marineLitterNumberField.numberPattern";
    public static final String BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_VALUE = "marineLitterNumberField.numberValue";
    public static final String BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterSizeCategoryComboBox.selectedItem";
    public static final String BINDING_MARINE_LITTER_WEIGHT_FIELD_NUMBER_VALUE = "marineLitterWeightField.numberValue";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateMarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateMarineLitterBatchUI createMarineLitterBatchTopPanel = this;
    protected final CreateMarineLitterBatchUIHandler handler = createHandler();
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterCategory",  editorName = "marineLitterCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterCategoryComboBox;
    protected JLabel marineLitterCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "number",  editorName = "marineLitterNumberField")
    protected NumberEditor marineLitterNumberField;
    protected JLabel marineLitterNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterSizeCategory",  editorName = "marineLitterSizeCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterSizeCategoryComboBox;
    protected JLabel marineLitterSizeCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "marineLitterWeightField")
    protected NumberEditor marineLitterWeightField;
    protected JLabel marineLitterWeightLabel;
    protected CreateMarineLitterBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateMarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateMarineLitterBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI() {
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateMarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterCategoryComboBox() {
        return marineLitterCategoryComboBox;
    }

    public JLabel getMarineLitterCategoryLabel() {
        return marineLitterCategoryLabel;
    }

    public NumberEditor getMarineLitterNumberField() {
        return marineLitterNumberField;
    }

    public JLabel getMarineLitterNumberLabel() {
        return marineLitterNumberLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterSizeCategoryComboBox() {
        return marineLitterSizeCategoryComboBox;
    }

    public JLabel getMarineLitterSizeCategoryLabel() {
        return marineLitterSizeCategoryLabel;
    }

    public NumberEditor getMarineLitterWeightField() {
        return marineLitterWeightField;
    }

    public JLabel getMarineLitterWeightLabel() {
        return marineLitterWeightLabel;
    }

    public CreateMarineLitterBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateMarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(marineLitterCategoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterCategoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterSizeCategoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterSizeCategoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterNumberLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterNumberField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterWeightField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createMarineLitterBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createMarineLitterBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createMarineLitterBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.actions.CreateMarineLitterBatchBatchCancelAction.class);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateMarineLitterBatchUIHandler createHandler() {
        return new CreateMarineLitterBatchUIHandler();
    }

    protected void createMarineLitterCategoryComboBox() {
        $objectMap.put("marineLitterCategoryComboBox", marineLitterCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterCategoryComboBox.setName("marineLitterCategoryComboBox");
        marineLitterCategoryComboBox.setProperty("marineLitterCategory");
        marineLitterCategoryComboBox.setShowReset(true);
        marineLitterCategoryComboBox.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
    }

    protected void createMarineLitterCategoryLabel() {
        $objectMap.put("marineLitterCategoryLabel", marineLitterCategoryLabel = new JLabel());
        
        marineLitterCategoryLabel.setName("marineLitterCategoryLabel");
        marineLitterCategoryLabel.setText(t("tutti.createMarineLitterBatch.field.marineLitterCategory"));
        marineLitterCategoryLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.marineLitterCategory.tip"));
        marineLitterCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
    }

    protected void createMarineLitterNumberField() {
        $objectMap.put("marineLitterNumberField", marineLitterNumberField = new NumberEditor(this));
        
        marineLitterNumberField.setName("marineLitterNumberField");
        marineLitterNumberField.setProperty("number");
        marineLitterNumberField.setShowReset(true);
        marineLitterNumberField.putClientProperty("help", "tutti.createMarineLitterBatch.field.number.help");
    }

    protected void createMarineLitterNumberLabel() {
        $objectMap.put("marineLitterNumberLabel", marineLitterNumberLabel = new JLabel());
        
        marineLitterNumberLabel.setName("marineLitterNumberLabel");
        marineLitterNumberLabel.setText(t("tutti.createMarineLitterBatch.field.number"));
        marineLitterNumberLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.number.tip"));
        marineLitterNumberLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.number.help");
    }

    protected void createMarineLitterSizeCategoryComboBox() {
        $objectMap.put("marineLitterSizeCategoryComboBox", marineLitterSizeCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterSizeCategoryComboBox.setName("marineLitterSizeCategoryComboBox");
        marineLitterSizeCategoryComboBox.setProperty("marineLitterSizeCategory");
        marineLitterSizeCategoryComboBox.setShowReset(true);
        marineLitterSizeCategoryComboBox.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
    }

    protected void createMarineLitterSizeCategoryLabel() {
        $objectMap.put("marineLitterSizeCategoryLabel", marineLitterSizeCategoryLabel = new JLabel());
        
        marineLitterSizeCategoryLabel.setName("marineLitterSizeCategoryLabel");
        marineLitterSizeCategoryLabel.setText(t("tutti.createMarineLitterBatch.field.marineLitterSizeCategory"));
        marineLitterSizeCategoryLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.marineLitterSizeCategory.tip"));
        marineLitterSizeCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
    }

    protected void createMarineLitterWeightField() {
        $objectMap.put("marineLitterWeightField", marineLitterWeightField = new NumberEditor(this));
        
        marineLitterWeightField.setName("marineLitterWeightField");
        marineLitterWeightField.setProperty("weight");
        marineLitterWeightField.setShowReset(true);
        marineLitterWeightField.putClientProperty("help", "tutti.createMarineLitterBatch.field.weight.help");
    }

    protected void createMarineLitterWeightLabel() {
        $objectMap.put("marineLitterWeightLabel", marineLitterWeightLabel = new JLabel());
        
        marineLitterWeightLabel.setName("marineLitterWeightLabel");
        marineLitterWeightLabel.setText(t("tutti.createMarineLitterBatch.field.weight"));
        marineLitterWeightLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.weight.tip"));
        marineLitterWeightLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.weight.help");
        marineLitterWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getMarineLitterWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateMarineLitterBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createMarineLitterBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createMarineLitterBatch.action.saveAndClose.tip"));
        saveAndCloseButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.saveAndClose.help");
        saveAndCloseButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.actions.CreateMarineLitterBatchBatchAndCloseAction.class);
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createMarineLitterBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createMarineLitterBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.saveAndContinue.help");
        saveAndContinueButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.actions.CreateMarineLitterBatchBatchAndContinueAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateMarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 24 property setters
        marineLitterCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterSizeCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterCategoryLabel.setLabelFor(marineLitterCategoryComboBox);
        marineLitterCategoryComboBox.setBean(model);
        marineLitterSizeCategoryLabel.setLabelFor(marineLitterSizeCategoryComboBox);
        marineLitterSizeCategoryComboBox.setBean(model);
        marineLitterNumberLabel.setLabelFor(marineLitterNumberField);
        marineLitterNumberField.setBean(model);
        marineLitterNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        marineLitterNumberField.setNumberType(Integer.class);
        marineLitterWeightLabel.setLabelFor(marineLitterWeightField);
        marineLitterWeightField.setBean(model);
        marineLitterWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        marineLitterWeightField.setNumberType(Float.class);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createMarineLitterBatchTopPanel, "tutti.createMarineLitterBatch.help");
        registerHelpId(_broker, marineLitterCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
        registerHelpId(_broker, marineLitterCategoryComboBox, "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
        registerHelpId(_broker, marineLitterSizeCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
        registerHelpId(_broker, marineLitterSizeCategoryComboBox, "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
        registerHelpId(_broker, marineLitterNumberLabel, "tutti.createMarineLitterBatch.field.number.help");
        registerHelpId(_broker, marineLitterNumberField, "tutti.createMarineLitterBatch.field.number.help");
        registerHelpId(_broker, marineLitterWeightLabel, "tutti.createMarineLitterBatch.field.weight.help");
        registerHelpId(_broker, marineLitterWeightField, "tutti.createMarineLitterBatch.field.weight.help");
        registerHelpId(_broker, cancelButton, "tutti.createMarineLitterBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createMarineLitterBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createMarineLitterBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createMarineLitterBatchTopPanel", createMarineLitterBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createMarineLitterCategoryLabel();
        createMarineLitterCategoryComboBox();
        createMarineLitterSizeCategoryLabel();
        createMarineLitterSizeCategoryComboBox();
        createMarineLitterNumberLabel();
        createMarineLitterNumberField();
        createMarineLitterWeightLabel();
        createMarineLitterWeightField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createMarineLitterBatchTopPanel
        setName("createMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        createMarineLitterBatchTopPanel.putClientProperty("help", "tutti.createMarineLitterBatch.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterCategoryComboBox.setSelectedItem(model.getMarineLitterCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterSizeCategoryComboBox.setSelectedItem(model.getMarineLitterSizeCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("number", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterNumberField.setNumberValue(model.getNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("number", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                marineLitterNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterWeightField.setNumberValue(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}