package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class EnterMelagWeightUI extends JDialog implements TuttiUI<TuttiUIContext, EnterMelagWeightUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_WEIGHT_UNIT = "weightUnit";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DIALOG_TITLE = "dialog.title";
    public static final String BINDING_EDITOR_NUMBER_PATTERN = "editor.numberPattern";
    public static final String BINDING_MESSAGE_TEXT = "message.text";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8bRRieuLFTO00DiVoVJUhu+ZDTVuuWEyh8NJhEJHLSKHZohQ90vDuxp5qdnc7M1g5WET+BnwB3LkjcOCEOnDlwQfwFhDhwRbwzu971xwZbIod1dub9eN73fZ53v/0D5ZVEN5/ift+RIdfUJ87BzuPHD9tPias/IsqVVOhAouhvIYdyLbTsJedKo9dadeNejd2rtcAXASd8xHu7jkpKnzOiuoRojV4d93CVqjaS6+2+COUwagIqK+rXf/2Z+8r78pscQn0B6IpQSnmWV1rJYh3lqKfRGmR6jqsM8w7AkJR3AO+KOasxrNQR9skz9AVaqqOCwBKCaXRr/pJtDOvfFxoVPIpZ0NHonTPp0DNJfCIdHWpNnZA6qgfJnVBT5ihBXEqUs8s1kYeE4c4jQjtdfbovhA1X0CjvBx5hGlUujtU0r6f7tQDC9HXqWupF0TiFaspT/vpcEOdRYjKSUuM2IxrdGGtznMtcGbtiYr7kE6VwBxzWTD/7seVBHbcJMzZriWmBeBT6ptGdQHYcHsILd2yWHvUggoIzvw0Ij+zPrrUeD3H59YNjzAm7N5nOno4ju+Ji7hL2IZQLvUHrY/bRqbHcSByuPseMeliT9LIcW0i0MdYO4LOT8jkl3EIL5WUIx9C/1rQETuAqIv+NCfKbgPb2n+vrv/7w+/d7Q8YvQe5rmaYjggUmChkIIjU1qVcjuhuWVQ+x2G6BbggDtVs1b2YAa8TXAA7yvWzcI5J+jFUXQuSXfvvxp+tPfrmEcnuoxALs7WFjv4+KuiuhCwHz+uKDBxbRld5leL5ksBk6UW3odGvQxdxjMF2YdJMyUoHflH+Vra0XfejLZkZfEnDt4s9/rze+ezDszQJgfeVC87Q/+U9RgXJGObH7IJZ6pv6XhSKhF6SSzhI5SlQuYt1U7PPuVANywLtuIOnnwEDMdhjtcN+ul9VBpBCntnvU3D15odGika9Gb4z26TDSVlarTL57tgfmv7dQqsRZmIxoQ0UagAXGc4aZgvEUcaiD40CEIj1bieR4jDUsKLC9PZjAYSCOajW2rGxBOUXgRO+EKPMxWNQyhHir5sjmGGoyvihFiZqwkiDrYA/4pR3XNDyz0HiPzKozn/T0zWjluZKAuBvR2rUL1wESU1hC0aYAINH7vmvAFYanK58p6gtGduylRo3BnJs9ija94Ws28E6c29YJ64ref5sfcuIHnLoaVefD7PiJx7IOAtakomlrvj2nv6Yiq8djy3MeRhFuvg3wrd0YROOx/DVfr8pW+eZ7ZR4ylrK8MgvdcBVPzgS7LhF6eian/3cmn8QJ/3sq9+fFfeFc7s4d4YLJTHylZs0GVnCB4fMAjNHVd8EPl9uUe9CX96eiL5hnaWZEc/zMPGR2hE2I8C92ZlEudwoAAA==";
    private static final Log log = LogFactory.getLog(EnterMelagWeightUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected EnterMelagWeightUI dialog = this;
    protected NumberEditor editor;
    protected final EnterMelagWeightUIHandler handler = createHandler();
    protected JLabel message;
    protected TuttiUIContext model;
    protected Table table;
    protected JButton validateButton;
    protected WeightUnit weightUnit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public Float openAndGetWeightValue(WeightUnit weightUnit) {
        return handler.openAndGetWeightValue(weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnterMelagWeightUI(TuttiUIContext context) {
        super(context.getMainUI(), true);
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public EnterMelagWeightUI() {
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Window param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterMelagWeightUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterMelagWeightUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public EnterMelagWeightUIHandler getHandler() {
        return handler;
    }

    public JLabel getMessage() {
        return message;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public Table getTable() {
        return table;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public WeightUnit getWeightUnit() {
        return weightUnit;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setWeightUnit(WeightUnit weightUnit) {
        WeightUnit oldValue = this.weightUnit;
        this.weightUnit = weightUnit;
        firePropertyChange(PROPERTY_WEIGHT_UNIT, oldValue, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        table.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createSpeciesMelag.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createSpeciesMelag.action.cancel.tip"));
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.species.actions.EnterMelagWeightCancelAction.class);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
        editor.setAutoPopup(false);
        editor.setShowReset(true);
        editor.setShowPopupButton(true);
    }

    protected EnterMelagWeightUIHandler createHandler() {
        return new EnterMelagWeightUIHandler();
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.createSpeciesMelag.action.validate"));
        validateButton.setToolTipText(t("tutti.createSpeciesMelag.action.validate.tip"));
        validateButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.species.actions.EnterMelagWeightValidateAction.class);
    }

    protected void createWeightUnit() {
        $objectMap.put("weightUnit", weightUnit = WeightUnit.KG);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        message.setHorizontalAlignment(JLabel.CENTER);
        editor.setNumberType(Float.class);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesMelag.action.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("accept"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesMelag.action.validate.mnemonic"),'Z'));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("dialog", dialog);
        createModel();
        createWeightUnit();
        createTable();
        createMessage();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DIALOG_TITLE, true ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                setTitle(t(handler.getTile(getWeightUnit())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MESSAGE_TEXT, true ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                message.setText(t(handler.getMessage(getWeightUnit())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_NUMBER_PATTERN, true ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                if (getWeightUnit() != null) {
                    editor.setNumberPattern(getWeightUnit().getNumberEditorPattern());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    validateButton.setEnabled(editor.getModel() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}