package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MultiPostImportLogDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz28bRRR+NrVjJ00LRP2BCMi4FaQSGrdwqRQETVMiEjm0alK1wod2vDt2pprdmc68bTayQPwJ/Alw54LEjRPiwJkDF8S/gBAHrog3u9u13ThNVEu7Xs1775v3vve99/1fUHMW3nnM05TZJEYZCba19uDB7f5jEeAt4QIrDWoL+a9ShWoPFsLy3CFc6nV9eKcI76zryOhYxBPRq12Yd3ighNsTAhHemo4InOvslObV1CT2GWqZ1CzUb//5u/pN+PV3VYDUUHa+lNZxUeNKTnWhKkOE1+mmp7yjeDykNKyMh5Tvoj9bV9y5z3kknsBXMNeFuuGWwBDaJy85w8jiU4NwUZKnxe1EobyjHXb18JbkSg8RugPL5MCKSFiGCaJkiWRun9JhgY6R0Jk2wnKUOmYBx2BPOFYCbWa4JZwx2Z11hLlIOMeHAuGcLyktILd2RYprVnDv1iy9Fy9v7QRWK3WHx+IqwoWpmLFpOqrZ9+l0pUN/cMa/zpbGhUBpJ25SRVQFLE0B5qcFmIU3p5pHsmBjWYz7VulBzSZ0THT2DivpLplyDV18TkMeMLP+d37p95/+/HFjUjjnZrpO6J4aaqzvAEp/9dlcNQlK1dnmZrUHTScUDU02FMszEtspzJQc3feaD2c+nH3G3R5B1Ob++PmX849+ewWqGzCvNA83uPffhCbuWWJBqzA1n9zIMjq936D3q/RUEWooURFFb+e6iQ6JghUOtUiHXCGcQpuIlChankFRmWe/+eu/Szs/3HhGU4XSfuNI9zFVtS+gLmMlY5FNWDE8MydqwTiRhHo8JLPGBl4wN6ZQ+nL2bh1ip4nQ8Jnct9wUdZNeBzpIHO9nlAy4csKbaCAQ3hvhSvtIGotZal/5EqEeJNbROTRGrThRquXPtOFPkknUgfb7ojNqTer+3uY2jwnHMprLDfJYaXd5XyjmvdtXMqS+tiFpDT4ctW5mn7kYDlhAQ4vi08jgQW5YuXb1/dYH9OT/WfjiPtWbDc998ikLb4hQ4mTdaeJpezdrrv9agfHGOI7aygnxxtvhOMRa2YajlZxtEyrwoSNJKEGkSL9X9Ohl1qczIqBpZjnKrHW67q/LpbYW5LFemUTxfB606dGh8ZQrGVJfEE7La9fj7VhEOpYBCerFlbCo9FxArdWuNLsZA0eLMI9DaWaRPbltT9DAuuIHmpzhzEeUPW/1ZRwSZR8fgq749zwh/g/7YrihMwgAAA==";
    private static final Log log = LogFactory.getLog(MultiPostImportLogDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea batchList;
    protected JButton closeButton;
    protected MultiPostImportLogDialog importMultiPostLogDialog = this;
    protected JTextArea message;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultiPostImportLogDialog() {
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultiPostImportLogDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultiPostImportLogDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getBatchList() {
        return batchList;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getMessage() {
        return message;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportMultiPostLogDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(message, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add(closeButton, BorderLayout.SOUTH);
    }

    protected void createBatchList() {
        $objectMap.put("batchList", batchList = new JTextArea());
        
        batchList.setName("batchList");
        batchList.setColumns(15);
        batchList.setLineWrap(true);
        batchList.setWrapStyleWord(true);
        batchList.setEditable(false);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.multiPostImportLog.close"));
        closeButton.setToolTipText(t("tutti.multiPostImportLog.close.tip"));
        closeButton.putClientProperty("simpleaction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.MultiPostImportLogCloseDialogAction.class);
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JTextArea());
        
        message.setName("message");
        message.setColumns(15);
        message.setLineWrap(true);
        message.setWrapStyleWord(true);
        message.setLineWrap(true);
        message.setFocusable(false);
        message.setOpaque(false);
        message.setEditable(false);
        message.setWrapStyleWord(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportMultiPostLogDialog();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(batchList);
        
        // apply 7 property setters
        SwingUtil.setText(message, t("tutti.multiPostImportLog.message"));
        
        message.setCursor( null );
        message.setFont( javax.swing.UIManager.getFont("Label.font") );
        message.setBorder( BorderFactory.createEmptyBorder(10, 20, 10, 20) );
        closeButton.setIcon(SwingUtil.createActionIcon("validate"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.multiPostImportLog.close.mnemonic"),'Z'));
        // late initializer
        importMultiPostLogDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("importMultiPostLogDialog", importMultiPostLogDialog);
        createMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createBatchList();
        createCloseButton();
        // inline creation of importMultiPostLogDialog
        setName("importMultiPostLogDialog");
        importMultiPostLogDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.multiPostImportLog.title"));
        setModal(true);
        
        $completeSetup();
    }

}