/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.TableBasedDeleteHandlerImpl;
import org.hibernate.hql.spi.TableBasedUpdateHandlerImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.persister.entity.Queryable;
import org.jboss.logging.Logger;

public class TemporaryTableBulkIdStrategy
implements MultiTableBulkIdStrategy {
    public static final TemporaryTableBulkIdStrategy INSTANCE = new TemporaryTableBulkIdStrategy();
    public static final String SHORT_NAME = "temporary";
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TemporaryTableBulkIdStrategy.class.getName());
    private static SqlExceptionHelper.WarningHandler CREATION_WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        @Override
        public boolean doProcess() {
            return log.isDebugEnabled();
        }

        @Override
        public void prepare(SQLWarning warning) {
            log.warningsCreatingTempTable(warning);
        }

        @Override
        protected void logWarning(String description, String message) {
            log.debug(description);
            log.debug(message);
        }
    };

    @Override
    public void prepare(JdbcServices jdbcServices, JdbcConnectionAccess connectionAccess, Mappings mappings, Mapping mapping, Map settings) {
    }

    @Override
    public void release(JdbcServices jdbcServices, JdbcConnectionAccess connectionAccess) {
    }

    @Override
    public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        return new TableBasedUpdateHandlerImpl(factory, walker){

            @Override
            protected void prepareForUse(Queryable persister, SessionImplementor session) {
                TemporaryTableBulkIdStrategy.this.createTempTable(persister, session);
            }

            @Override
            protected void releaseFromUse(Queryable persister, SessionImplementor session) {
                TemporaryTableBulkIdStrategy.this.releaseTempTable(persister, session);
            }
        };
    }

    @Override
    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        return new TableBasedDeleteHandlerImpl(factory, walker){

            @Override
            protected void prepareForUse(Queryable persister, SessionImplementor session) {
                TemporaryTableBulkIdStrategy.this.createTempTable(persister, session);
            }

            @Override
            protected void releaseFromUse(Queryable persister, SessionImplementor session) {
                TemporaryTableBulkIdStrategy.this.releaseTempTable(persister, session);
            }
        };
    }

    protected void createTempTable(Queryable persister, SessionImplementor session) {
        TemporaryTableCreationWork work = new TemporaryTableCreationWork(persister);
        if (this.shouldIsolateTemporaryTableDDL(session)) {
            session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(work, this.shouldTransactIsolatedTemporaryTableDDL(session));
        } else {
            Connection connection = session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getConnection();
            work.execute(connection);
            session.getTransactionCoordinator().getJdbcCoordinator().afterStatementExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseTempTable(Queryable persister, SessionImplementor session) {
        if (session.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            TemporaryTableDropWork work = new TemporaryTableDropWork(persister, session);
            if (this.shouldIsolateTemporaryTableDDL(session)) {
                session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(work, this.shouldTransactIsolatedTemporaryTableDDL(session));
                return;
            }
            Connection connection = session.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getConnection();
            work.execute(connection);
            session.getTransactionCoordinator().getJdbcCoordinator().afterStatementExecution();
            return;
        }
        PreparedStatement ps = null;
        try {
            String sql = "delete from " + persister.getTemporaryIdTableName();
            ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
            session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
            if (ps == null) return;
        }
        catch (Throwable t) {
            try {
                log.unableToCleanupTemporaryIdTable(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (ps != null) {
                    try {
                        session.getTransactionCoordinator().getJdbcCoordinator().release(ps);
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
        try {
            session.getTransactionCoordinator().getJdbcCoordinator().release(ps);
            return;
        }
        catch (Throwable ignore) {
            return;
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL(SessionImplementor session) {
        Boolean dialectVote = session.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (dialectVote != null) {
            return dialectVote;
        }
        return session.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }

    protected boolean shouldTransactIsolatedTemporaryTableDDL(SessionImplementor session) {
        return false;
    }

    private static class TemporaryTableDropWork
    extends AbstractWork {
        private final Queryable persister;
        private final SessionImplementor session;

        private TemporaryTableDropWork(Queryable persister, SessionImplementor session) {
            this.persister = persister;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            String command = this.session.getFactory().getDialect().getDropTemporaryTableString() + ' ' + this.persister.getTemporaryIdTableName();
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(command);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
            catch (Exception e) {
                log.warn("unable to drop temporary id table after use [" + e.getMessage() + "]");
            }
        }
    }

    private static class TemporaryTableCreationWork
    extends AbstractWork {
        private final Queryable persister;

        private TemporaryTableCreationWork(Queryable persister) {
            this.persister = persister;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(this.persister.getTemporaryIdTableDDL());
                    this.persister.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper().handleAndClearWarnings(statement, CREATION_WARNING_HANDLER);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e) {
                log.debug("unable to create temporary id table [" + e.getMessage() + "]");
            }
        }
    }
}

