// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Liste des rangs taxinomiques possibles.
 * C’est le nom du rang dans la classification systématique ; les niveaux systématiques sont
 * désignés par des termes consacrés (ex. : espèce, genre, famille, etc.). Le niveau systématique
 * d’un taxon peut changer avec l’évolution de la classification ; dans ce cas, son libellé est
 * susceptible de changer également car les suffixes notamment obéissent à des règles strictes de
 * nomenclature (règle [R0018]).
 * Les niveaux systématiques pris en compte dans le référentiel taxinomique Quadrige² sont (par
 * ordre de rang) (le nom anglais de chaque niveau est indiqué entre parenthèses) :
 * -	Règne (kingdom)
 * -	Sous-règne (subkingdom)
 * -	Division (division) / Embranchement (phylum)
 * -	Subdivision (subdivision) / Sous-embranchement (subphylum)
 * -	Super-classe (superclass)
 * -	Classe (class)
 * -	Sous-classe (subclass)
 * -	Infra-classe (infraclass)
 * -	Super-ordre (superordo)
 * -	Ordre (ordo)
 * -	Sous-ordre (subordo)
 * -	Infra-ordre (infraordo)
 * -	Section (section)
 * -	Sous-section (subsection)
 * -	Super-famille (superfamily)
 * -	Famille (family)
 * -	Sous-famille (subfamily)
 * -	Tribu (tribe)
 * -	Sous-tribu (subtribe)
 * -	Genre (genus)
 * -	Sous-genre (subgenus)
 * -	Espèce (species)
 * -	Sous-espèce (subspecies)
 * -	Variété (variety)
 * -	Sous-variété (subvariety)
 * -	Forme (forma)
 * -	Sous-forme (subforma)
 * -	Incertae sedis (dummy = taxons inclassables)
 * @see TaxonomicLevel
 */
public interface TaxonomicLevelDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link TaxonomicLevel}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of TaxonomicLevel from the persistent store.
     * @param code
     * @return TaxonomicLevel
     */
    public TaxonomicLevel get(String code);

    /**
     * <p>
     * Does the same thing as {@link #get(String)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param code the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, String code);

    /**
     * Loads an instance of TaxonomicLevel from the persistent store.
     * @param code
     * @return TaxonomicLevel
     */
    public TaxonomicLevel load(String code);

    /**
     * <p>
     * Does the same thing as {@link #load(String)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param code the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, String code);

    /**
     * Loads all entities of type {@link TaxonomicLevel}.
     *
     * @return the loaded entities.
     */
    public Collection<TaxonomicLevel> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of TaxonomicLevel and adds it to the persistent store.
     * @param taxonomicLevel
     * @return TaxonomicLevel
     */
    public TaxonomicLevel create(TaxonomicLevel taxonomicLevel);

    /**
     * <p>
     * Does the same thing as {@link #create(TaxonomicLevel)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param taxonomicLevel
     * @return Object
     */
    public Object create(int transform, TaxonomicLevel taxonomicLevel);

    /**
     * Creates a new instance of TaxonomicLevel and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of TaxonomicLevel
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<TaxonomicLevel> create(Collection<TaxonomicLevel> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(TaxonomicLevel)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<TaxonomicLevel> entities);

    /**
     * <p>
     * Creates a new <code>TaxonomicLevel</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param code Code unique identifiant le rang taxinomique.
     * @param rank Numéro du rang taxinomique.
Croissant du règne vers l'espèce
Ceci permet de limiter le choix des niveaux fils aux numéros supérieurs
     * @param name Libellé du rang taxinomique
     * @param label Mnémonique du rang taxinomique
     * @param comments Commentaire décrivant le rang taxinomique
     * @param creationDate Date de création système du niveau. Renseigné automatiquement par le système.
     * @param updateDate Date de mise à jour système du niveau. Renseigné automatiquement par le système.
     * @return TaxonomicLevel
     */
    public TaxonomicLevel create(
        String code,
        Integer rank,
        String name,
        String label,
        String comments,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Does the same thing as {@link #create(Integer, String, String, String, Date, Timestamp)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param code Code unique identifiant le rang taxinomique.
     * @param rank Numéro du rang taxinomique.
Croissant du règne vers l'espèce
Ceci permet de limiter le choix des niveaux fils aux numéros supérieurs
     * @param name Libellé du rang taxinomique
     * @param label Mnémonique du rang taxinomique
     * @param comments Commentaire décrivant le rang taxinomique
     * @param creationDate Date de création système du niveau. Renseigné automatiquement par le système.
     * @param updateDate Date de mise à jour système du niveau. Renseigné automatiquement par le système.
     * @return TaxonomicLevel
     */
    public Object create(
        int transform,
        String code,
        Integer rank,
        String name,
        String label,
        String comments,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Creates a new <code>TaxonomicLevel</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param creationDate
     * @param name
     * @param rank
     * @param status
     * @return TaxonomicLevel
     */
    public TaxonomicLevel create(
        Date creationDate,
        String name,
        Integer rank,
        Status status);

    /**
     * <p>
     * Does the same thing as {@link #create(Integer, String, Date)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param creationDate
     * @param name
     * @param rank
     * @param status
     * @return Object
     */
    public Object create(
        int transform,
        Date creationDate,
        String name,
        Integer rank,
        Status status);

    /**
     * Updates the <code>taxonomicLevel</code> instance in the persistent store.
     * @param taxonomicLevel
     */
    public void update(TaxonomicLevel taxonomicLevel);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<TaxonomicLevel> entities);

    /**
     * Removes the instance of TaxonomicLevel from the persistent store.
     * @param taxonomicLevel
     */
    public void remove(TaxonomicLevel taxonomicLevel);

    /**
     * Removes the instance of TaxonomicLevel having the given
     * <code>identifier</code> from the persistent store.
     * @param code
     */
    public void remove(String code);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<TaxonomicLevel> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<TaxonomicLevel> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final TaxonomicLevel entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,TaxonomicLevel)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,TaxonomicLevel)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}