// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeatures;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.VesselType;
import fr.ifremer.adagio.core.dao.referential.regulation.RightToProduce;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Vessel
    implements Serializable, Comparable<Vessel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -6166084732904526931L;

    // Generate 2 attributes
    private String code;

    /**
     * Code du navire, c'est à dire son immatriculation. L'immatriculation d'un navire ne change
     * jamais, quelque soit sont quartier maritime.
     * Le code est sur 12 caractères pour permettre de stocker les 6 caractères du code Harmonie un
     * prefix (ex, dans Allegro : "#TEMP¿").
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * Code du navire, c'est à dire son immatriculation. L'immatriculation d'un navire ne change
     * jamais, quelque soit sont quartier maritime.
     * Le code est sur 12 caractères pour permettre de stocker les 6 caractères du code Harmonie un
     * prefix (ex, dans Allegro : "#TEMP¿").
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 33 associations
    private Collection<VesselFleetEvent> vesselFleetEvents = new HashSet<VesselFleetEvent>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Evènement d'entrée ou sortie de flotte (entrée ou sortie du registre des
     * navires).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <ul>
     * <li>
     * Pour le flux FPC :
     * </li>
     * </ul>
     * <!--StartFragment-->
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * IMP<span style="white-space:pre-wrap;"> </span>Importation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CHA<span style="white-space:pre-wrap;"> </span>Entrée dans le FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CST<span style="white-space:pre-wrap;"> </span>Construction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * EXP<span style="white-space:pre-wrap;"> </span>Exportation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * COR<span style="white-space:pre-wrap;"> </span>Correction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * RET<span style="white-space:pre-wrap;"> </span>Retrait du FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * DES<span style="white-space:pre-wrap;"> </span>Destruction
     * </p>
     * </div>
     * <div style="font-size:13px;font-style:normal;font-variant:normal;color:rgb(0, 0,
     * 0);font-family:arial, sans-serif;">
     * </div>
     * </body>
     * </html>
     * @return this.vesselFleetEvents Collection<VesselFleetEvent>
     */
    public Collection<VesselFleetEvent> getVesselFleetEvents()
    {
        return this.vesselFleetEvents;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Evènement d'entrée ou sortie de flotte (entrée ou sortie du registre des
     * navires).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <ul>
     * <li>
     * Pour le flux FPC :
     * </li>
     * </ul>
     * <!--StartFragment-->
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * IMP<span style="white-space:pre-wrap;"> </span>Importation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CHA<span style="white-space:pre-wrap;"> </span>Entrée dans le FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CST<span style="white-space:pre-wrap;"> </span>Construction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * EXP<span style="white-space:pre-wrap;"> </span>Exportation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * COR<span style="white-space:pre-wrap;"> </span>Correction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * RET<span style="white-space:pre-wrap;"> </span>Retrait du FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * DES<span style="white-space:pre-wrap;"> </span>Destruction
     * </p>
     * </div>
     * <div style="font-size:13px;font-style:normal;font-variant:normal;color:rgb(0, 0,
     * 0);font-family:arial, sans-serif;">
     * </div>
     * </body>
     * </html>
     * @param vesselFleetEventsIn Collection<VesselFleetEvent>
     */
    public void setVesselFleetEvents(Collection<VesselFleetEvent> vesselFleetEventsIn)
    {
        this.vesselFleetEvents = vesselFleetEventsIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Evènement d'entrée ou sortie de flotte (entrée ou sortie du registre des
     * navires).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <ul>
     * <li>
     * Pour le flux FPC :
     * </li>
     * </ul>
     * <!--StartFragment-->
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * IMP<span style="white-space:pre-wrap;"> </span>Importation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CHA<span style="white-space:pre-wrap;"> </span>Entrée dans le FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CST<span style="white-space:pre-wrap;"> </span>Construction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * EXP<span style="white-space:pre-wrap;"> </span>Exportation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * COR<span style="white-space:pre-wrap;"> </span>Correction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * RET<span style="white-space:pre-wrap;"> </span>Retrait du FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * DES<span style="white-space:pre-wrap;"> </span>Destruction
     * </p>
     * </div>
     * <div style="font-size:13px;font-style:normal;font-variant:normal;color:rgb(0, 0,
     * 0);font-family:arial, sans-serif;">
     * </div>
     * </body>
     * </html>
     * @param elementToAdd VesselFleetEvent
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselFleetEvents(VesselFleetEvent elementToAdd)
    {
        return this.vesselFleetEvents.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Evènement d'entrée ou sortie de flotte (entrée ou sortie du registre des
     * navires).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <ul>
     * <li>
     * Pour le flux FPC :
     * </li>
     * </ul>
     * <!--StartFragment-->
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * IMP<span style="white-space:pre-wrap;"> </span>Importation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CHA<span style="white-space:pre-wrap;"> </span>Entrée dans le FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * CST<span style="white-space:pre-wrap;"> </span>Construction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * EXP<span style="white-space:pre-wrap;"> </span>Exportation
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * COR<span style="white-space:pre-wrap;"> </span>Correction
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * RET<span style="white-space:pre-wrap;"> </span>Retrait du FPC
     * </p>
     * </div>
     * <div style="color:rgb(0, 0,
     * 0);white-space:normal;font-size:13px;text-indent:0px;font-weight:normal;letter-spacing:normal;font-variant:normal;word-spacing:0px;text-align:-webkit-auto;font-style:normal;background-color:rgb(255,
     * 255, 255);line-height:normal;font-family:arial, sans-serif;text-transform:none;">
     * <p style="margin-left:50.0px;">
     * DES<span style="white-space:pre-wrap;"> </span>Destruction
     * </p>
     * </div>
     * <div style="font-size:13px;font-style:normal;font-variant:normal;color:rgb(0, 0,
     * 0);font-family:arial, sans-serif;">
     * </div>
     * </body>
     * </html>
     * @param elementToRemove VesselFleetEvent
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselFleetEvents(VesselFleetEvent elementToRemove)
    {
        return this.vesselFleetEvents.remove(elementToRemove);
    }

    private Collection<VesselFeatures> vesselFeatures = new HashSet<VesselFeatures>();

    /**
     * Caractéristiques d'un navire, sur une période donnée.
     * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
     * jauge_brute).
     * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques
     * FPC (à
     * utiliser de préférence si présent), et les caractéristiques d'autres sources.
     * Nombre de lignes : 67375
     * @return this.vesselFeatures Collection<VesselFeatures>
     */
    public Collection<VesselFeatures> getVesselFeatures()
    {
        return this.vesselFeatures;
    }

    /**
     * Caractéristiques d'un navire, sur une période donnée.
     * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
     * jauge_brute).
     * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques
     * FPC (à
     * utiliser de préférence si présent), et les caractéristiques d'autres sources.
     * Nombre de lignes : 67375
     * @param vesselFeaturesIn Collection<VesselFeatures>
     */
    public void setVesselFeatures(Collection<VesselFeatures> vesselFeaturesIn)
    {
        this.vesselFeatures = vesselFeaturesIn;
    }

    /**
     * Caractéristiques d'un navire, sur une période donnée.
     * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
     * jauge_brute).
     * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques
     * FPC (à
     * utiliser de préférence si présent), et les caractéristiques d'autres sources.
     * Nombre de lignes : 67375
     * @param elementToAdd VesselFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselFeatures(VesselFeatures elementToAdd)
    {
        return this.vesselFeatures.add(elementToAdd);
    }

    /**
     * Caractéristiques d'un navire, sur une période donnée.
     * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
     * jauge_brute).
     * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques
     * FPC (à
     * utiliser de préférence si présent), et les caractéristiques d'autres sources.
     * Nombre de lignes : 67375
     * @param elementToRemove VesselFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselFeatures(VesselFeatures elementToRemove)
    {
        return this.vesselFeatures.remove(elementToRemove);
    }

    private Collection<VesselRegistrationPeriod> vesselRegistrationPeriods = new HashSet<VesselRegistrationPeriod>();

    /**
     * Définit le lieu d'immatriculation d'un navire statistique et la période associée.
     * Nombre de lignes : 72700
     * @return this.vesselRegistrationPeriods Collection<VesselRegistrationPeriod>
     */
    public Collection<VesselRegistrationPeriod> getVesselRegistrationPeriods()
    {
        return this.vesselRegistrationPeriods;
    }

    /**
     * Définit le lieu d'immatriculation d'un navire statistique et la période associée.
     * Nombre de lignes : 72700
     * @param vesselRegistrationPeriodsIn Collection<VesselRegistrationPeriod>
     */
    public void setVesselRegistrationPeriods(Collection<VesselRegistrationPeriod> vesselRegistrationPeriodsIn)
    {
        this.vesselRegistrationPeriods = vesselRegistrationPeriodsIn;
    }

    /**
     * Définit le lieu d'immatriculation d'un navire statistique et la période associée.
     * Nombre de lignes : 72700
     * @param elementToAdd VesselRegistrationPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselRegistrationPeriods(VesselRegistrationPeriod elementToAdd)
    {
        return this.vesselRegistrationPeriods.add(elementToAdd);
    }

    /**
     * Définit le lieu d'immatriculation d'un navire statistique et la période associée.
     * Nombre de lignes : 72700
     * @param elementToRemove VesselRegistrationPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselRegistrationPeriods(VesselRegistrationPeriod elementToRemove)
    {
        return this.vesselRegistrationPeriods.remove(elementToRemove);
    }

    private VesselType vesselType;

    /**
     * Type de navire. Exemple : 1 pour les navires professionnels, 2 pour les pecheurs à pied, 3
     * pour les navires scientifiques
     * @return this.vesselType VesselType
     */
    public VesselType getVesselType()
    {
        return this.vesselType;
    }

    /**
     * Type de navire. Exemple : 1 pour les navires professionnels, 2 pour les pecheurs à pied, 3
     * pour les navires scientifiques
     * @param vesselTypeIn VesselType
     */
    public void setVesselType(VesselType vesselTypeIn)
    {
        this.vesselType = vesselTypeIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Status status;

    /**
     * Etat du navire à la date actuelle du système. Sert notamment à déterminer si le navire est
     * encore actif à la date du jour.
     * Cet état sert également pour les navires temporaires, lors de leur création dans la base
     * locale d'Allegro.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Etat du navire à la date actuelle du système. Sert notamment à déterminer si le navire est
     * encore actif à la date du jour.
     * Cet état sert également pour les navires temporaires, lors de leur création dans la base
     * locale d'Allegro.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    private Collection<VesselOwnerPeriod> vesselOwnerPeriods = new HashSet<VesselOwnerPeriod>();

    /**
     * Période d'appartenance d'un navire à un armateur (période d'armement).
     * Nombre de lignes : 25600
     * @return this.vesselOwnerPeriods Collection<VesselOwnerPeriod>
     */
    public Collection<VesselOwnerPeriod> getVesselOwnerPeriods()
    {
        return this.vesselOwnerPeriods;
    }

    /**
     * Période d'appartenance d'un navire à un armateur (période d'armement).
     * Nombre de lignes : 25600
     * @param vesselOwnerPeriodsIn Collection<VesselOwnerPeriod>
     */
    public void setVesselOwnerPeriods(Collection<VesselOwnerPeriod> vesselOwnerPeriodsIn)
    {
        this.vesselOwnerPeriods = vesselOwnerPeriodsIn;
    }

    /**
     * Période d'appartenance d'un navire à un armateur (période d'armement).
     * Nombre de lignes : 25600
     * @param elementToAdd VesselOwnerPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselOwnerPeriods(VesselOwnerPeriod elementToAdd)
    {
        return this.vesselOwnerPeriods.add(elementToAdd);
    }

    /**
     * Période d'appartenance d'un navire à un armateur (période d'armement).
     * Nombre de lignes : 25600
     * @param elementToRemove VesselOwnerPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselOwnerPeriods(VesselOwnerPeriod elementToRemove)
    {
        return this.vesselOwnerPeriods.remove(elementToRemove);
    }

    private Collection<VesselCommissioningPeriod> vesselCommissioningPeriods = new HashSet<VesselCommissioningPeriod>();

    /**
     * Période d'armement, ou de mise en service, du navire.
     * La mise en service est rattaché à un lieu terrestre de mise en service. Cela peut etre le
     * pays
     * d'armement ou le quartier d'armement.
     * @return this.vesselCommissioningPeriods Collection<VesselCommissioningPeriod>
     */
    public Collection<VesselCommissioningPeriod> getVesselCommissioningPeriods()
    {
        return this.vesselCommissioningPeriods;
    }

    /**
     * Période d'armement, ou de mise en service, du navire.
     * La mise en service est rattaché à un lieu terrestre de mise en service. Cela peut etre le
     * pays
     * d'armement ou le quartier d'armement.
     * @param vesselCommissioningPeriodsIn Collection<VesselCommissioningPeriod>
     */
    public void setVesselCommissioningPeriods(Collection<VesselCommissioningPeriod> vesselCommissioningPeriodsIn)
    {
        this.vesselCommissioningPeriods = vesselCommissioningPeriodsIn;
    }

    /**
     * Période d'armement, ou de mise en service, du navire.
     * La mise en service est rattaché à un lieu terrestre de mise en service. Cela peut etre le
     * pays
     * d'armement ou le quartier d'armement.
     * @param elementToAdd VesselCommissioningPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselCommissioningPeriods(VesselCommissioningPeriod elementToAdd)
    {
        return this.vesselCommissioningPeriods.add(elementToAdd);
    }

    /**
     * Période d'armement, ou de mise en service, du navire.
     * La mise en service est rattaché à un lieu terrestre de mise en service. Cela peut etre le
     * pays
     * d'armement ou le quartier d'armement.
     * @param elementToRemove VesselCommissioningPeriod
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselCommissioningPeriods(VesselCommissioningPeriod elementToRemove)
    {
        return this.vesselCommissioningPeriods.remove(elementToRemove);
    }

    private Collection<RightToProduce> rightToProduces = new HashSet<RightToProduce>();

    /**
     * Un droit de produire est une autorisation administrative pour prélever de ou exploiter de la
     * ressource. Il peut concerner un ensemble de navires de peche, ou un seul navire ou pecheur à
     * pied.
     * L'autorisation peut etre relative à une espèce, ou bien à un couple engin/espèce (=métier)
     * il peut etre défini dans le cadre d'un corpus ou non (ex : droit de produire défini par les
     * autorités locales).
     * @return this.rightToProduces Collection<RightToProduce>
     */
    public Collection<RightToProduce> getRightToProduces()
    {
        return this.rightToProduces;
    }

    /**
     * Un droit de produire est une autorisation administrative pour prélever de ou exploiter de la
     * ressource. Il peut concerner un ensemble de navires de peche, ou un seul navire ou pecheur à
     * pied.
     * L'autorisation peut etre relative à une espèce, ou bien à un couple engin/espèce (=métier)
     * il peut etre défini dans le cadre d'un corpus ou non (ex : droit de produire défini par les
     * autorités locales).
     * @param rightToProducesIn Collection<RightToProduce>
     */
    public void setRightToProduces(Collection<RightToProduce> rightToProducesIn)
    {
        this.rightToProduces = rightToProducesIn;
    }

    /**
     * Un droit de produire est une autorisation administrative pour prélever de ou exploiter de la
     * ressource. Il peut concerner un ensemble de navires de peche, ou un seul navire ou pecheur à
     * pied.
     * L'autorisation peut etre relative à une espèce, ou bien à un couple engin/espèce (=métier)
     * il peut etre défini dans le cadre d'un corpus ou non (ex : droit de produire défini par les
     * autorités locales).
     * @param elementToAdd RightToProduce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addRightToProduces(RightToProduce elementToAdd)
    {
        return this.rightToProduces.add(elementToAdd);
    }

    /**
     * Un droit de produire est une autorisation administrative pour prélever de ou exploiter de la
     * ressource. Il peut concerner un ensemble de navires de peche, ou un seul navire ou pecheur à
     * pied.
     * L'autorisation peut etre relative à une espèce, ou bien à un couple engin/espèce (=métier)
     * il peut etre défini dans le cadre d'un corpus ou non (ex : droit de produire défini par les
     * autorités locales).
     * @param elementToRemove RightToProduce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeRightToProduces(RightToProduce elementToRemove)
    {
        return this.rightToProduces.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Vessel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Vessel))
        {
            return false;
        }
        final Vessel that = (Vessel)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Vessel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Vessel}.
         * @return new VesselImpl()
         */
        public static Vessel newInstance()
        {
            return new VesselImpl();
        }

        /**
         * Constructs a new instance of {@link Vessel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param vesselType VesselType
         * @param program Program
         * @param status Status
         * @return newInstance
         */
        public static Vessel newInstance(VesselType vesselType, Program program, Status status)
        {
            final Vessel entity = new VesselImpl();
            entity.setVesselType(vesselType);
            entity.setProgram(program);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Vessel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param updateDate Timestamp
         * @param vesselFleetEvents Collection<VesselFleetEvent>
         * @param vesselFeatures Collection<VesselFeatures>
         * @param vesselRegistrationPeriods Collection<VesselRegistrationPeriod>
         * @param vesselType VesselType
         * @param program Program
         * @param status Status
         * @param vesselOwnerPeriods Collection<VesselOwnerPeriod>
         * @param vesselCommissioningPeriods Collection<VesselCommissioningPeriod>
         * @param rightToProduces Collection<RightToProduce>
         * @return newInstance Vessel
         */
        public static Vessel newInstance(Timestamp updateDate, Collection<VesselFleetEvent> vesselFleetEvents, Collection<VesselFeatures> vesselFeatures, Collection<VesselRegistrationPeriod> vesselRegistrationPeriods, VesselType vesselType, Program program, Status status, Collection<VesselOwnerPeriod> vesselOwnerPeriods, Collection<VesselCommissioningPeriod> vesselCommissioningPeriods, Collection<RightToProduce> rightToProduces)
        {
            final Vessel entity = new VesselImpl();
            entity.setUpdateDate(updateDate);
            entity.setVesselFleetEvents(vesselFleetEvents);
            entity.setVesselFeatures(vesselFeatures);
            entity.setVesselRegistrationPeriods(vesselRegistrationPeriods);
            entity.setVesselType(vesselType);
            entity.setProgram(program);
            entity.setStatus(status);
            entity.setVesselOwnerPeriods(vesselOwnerPeriods);
            entity.setVesselCommissioningPeriods(vesselCommissioningPeriods);
            entity.setRightToProduces(rightToProduces);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Vessel o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
private java.util.Collection	personSessionVessels	= new java.util.HashSet();
	
	/**
	 * 
	 */
	public java.util.Collection getPersonSessionVessels() {
		return this.personSessionVessels;
	}

	public void setPersonSessionVessels(java.util.Collection personSessionVessels) {
		this.personSessionVessels = personSessionVessels;
	}
}