package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 1/1/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.11
 */
public class ApplySpeciesFrequencyRafaleAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ApplySpeciesFrequencyRafaleAction.class);

    private final SpeciesFrequencyUI ui;

    public ApplySpeciesFrequencyRafaleAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {

        if (log.isDebugEnabled()) {
            log.debug("Will apply rafale step: " + step);
        }
        SpeciesFrequencyUIModel model = ui.getModel();
        SpeciesFrequencyUIHandler handler = ui.getHandler();

        SpeciesFrequencyTableModel tableModel = handler.getTableModel();

        Map<Float, SpeciesFrequencyRowModel> rowsByStep = model.getRowCache();

        float aroundLengthStep = model.getLengthStep(step);

        SpeciesFrequencyRowModel row = rowsByStep.get(aroundLengthStep);

        int rowIndex;

        if (row != null) {

            // increments current row
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);

        } else {

            // create a new row

            row = tableModel.createNewRow();
            row.setLengthStep(aroundLengthStep);
            row.setNumber(1);
            row.setValid(handler.isRowValid(row));

            // get new index
            List<Float> steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(aroundLengthStep);

            Collections.sort(steps);

            rowIndex = steps.indexOf(aroundLengthStep);

            tableModel.addNewRow(rowIndex, row);
        }

        int totalNumber = model.computeTotalNumber();
        model.setTotalNumber(totalNumber);

        ui.getTable().scrollRowToVisible(rowIndex);

        if (fromIchtyometer) {
            String unit = model.getLengthStepCaracteristicUnit();
            handler.showInformationMessage(t("tutti.editSpeciesFrequencies.addMeasure", step, aroundLengthStep, unit));
        }

        JXTable logsTable = ui.getLogsTable();
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel) logsTable.getModel();
        SpeciesFrequencyLogRowModel newRow = logsTableModel.createNewRow();
        newRow.setDate(new Date());
        newRow.setLengthStep(step);
        logsTableModel.addNewRow(0, newRow);

    }

}
