// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.observedLocation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.survey.activity.DailyActivityCalendar;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Lieu observé (ex: un site de débarquement, etc.).
 * An observed location (i.e. a landing site).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class ObservedLocation
    implements Serializable, Comparable<ObservedLocation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7137905334968925122L;

    // Generate 11 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * 
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * 
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private Date startDateTime;

    /**
     * 
     * @return this.startDateTime Date
     */
    public Date getStartDateTime()
    {
        return this.startDateTime;
    }

    /**
     * 
     * @param startDateTimeIn Date
     */
    public void setStartDateTime(Date startDateTimeIn)
    {
        this.startDateTime = startDateTimeIn;
    }

    private Date endDateTime;

    /**
     * 
     * @return this.endDateTime Date
     */
    public Date getEndDateTime()
    {
        return this.endDateTime;
    }

    /**
     * 
     * @param endDateTimeIn Date
     */
    public void setEndDateTime(Date endDateTimeIn)
    {
        this.endDateTime = endDateTimeIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private String samplingStrataReference;

    /**
     * Référence du plan d'échantillonnage.
     * A n'utiliser que en attendant que les plans d'échantillonnage OBS-DEB soient importés dans
     * Allegro.
     * @deprecated utiliser plutot SAMPLING_STRATA_FK
     * @return this.samplingStrataReference String
     */
    public String getSamplingStrataReference()
    {
        return this.samplingStrataReference;
    }

    /**
     * Référence du plan d'échantillonnage.
     * A n'utiliser que en attendant que les plans d'échantillonnage OBS-DEB soient importés dans
     * Allegro.
     * @deprecated utiliser plutot SAMPLING_STRATA_FK
     * @param samplingStrataReferenceIn String
     */
    public void setSamplingStrataReference(String samplingStrataReferenceIn)
    {
        this.samplingStrataReference = samplingStrataReferenceIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 9 associations
    private Collection<Person> observers = new HashSet<Person>();

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.observers Collection<Person>
     */
    public Collection<Person> getObservers()
    {
        return this.observers;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param observersIn Collection<Person>
     */
    public void setObservers(Collection<Person> observersIn)
    {
        this.observers = observersIn;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToAdd Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addObservers(Person elementToAdd)
    {
        return this.observers.add(elementToAdd);
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToRemove Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeObservers(Person elementToRemove)
    {
        return this.observers.remove(elementToRemove);
    }

    private Collection<ObservedLocationFeatures> observedLocationFeatures = new HashSet<ObservedLocationFeatures>();

    /**
     * Ensemble de caractéristiques observés sur un site.
     * Exemple : dans ObsDeb : nombre de navires au port, par type de navire.
     * @return this.observedLocationFeatures Collection<ObservedLocationFeatures>
     */
    public Collection<ObservedLocationFeatures> getObservedLocationFeatures()
    {
        return this.observedLocationFeatures;
    }

    /**
     * Ensemble de caractéristiques observés sur un site.
     * Exemple : dans ObsDeb : nombre de navires au port, par type de navire.
     * @param observedLocationFeaturesIn Collection<ObservedLocationFeatures>
     */
    public void setObservedLocationFeatures(Collection<ObservedLocationFeatures> observedLocationFeaturesIn)
    {
        this.observedLocationFeatures = observedLocationFeaturesIn;
    }

    /**
     * Ensemble de caractéristiques observés sur un site.
     * Exemple : dans ObsDeb : nombre de navires au port, par type de navire.
     * @param elementToAdd ObservedLocationFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addObservedLocationFeatures(ObservedLocationFeatures elementToAdd)
    {
        return this.observedLocationFeatures.add(elementToAdd);
    }

    /**
     * Ensemble de caractéristiques observés sur un site.
     * Exemple : dans ObsDeb : nombre de navires au port, par type de navire.
     * @param elementToRemove ObservedLocationFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeObservedLocationFeatures(ObservedLocationFeatures elementToRemove)
    {
        return this.observedLocationFeatures.remove(elementToRemove);
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Collection<DailyActivityCalendar> dailyActivityCalendars = new HashSet<DailyActivityCalendar>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @return this.dailyActivityCalendars Collection<DailyActivityCalendar>
     */
    public Collection<DailyActivityCalendar> getDailyActivityCalendars()
    {
        return this.dailyActivityCalendars;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @param dailyActivityCalendarsIn Collection<DailyActivityCalendar>
     */
    public void setDailyActivityCalendars(Collection<DailyActivityCalendar> dailyActivityCalendarsIn)
    {
        this.dailyActivityCalendars = dailyActivityCalendarsIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @param elementToAdd DailyActivityCalendar
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addDailyActivityCalendars(DailyActivityCalendar elementToAdd)
    {
        return this.dailyActivityCalendars.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @param elementToRemove DailyActivityCalendar
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeDailyActivityCalendars(DailyActivityCalendar elementToRemove)
    {
        return this.dailyActivityCalendars.remove(elementToRemove);
    }

    private Collection<Landing> landings = new HashSet<Landing>();

    /**
     * Débarquement à la suite d'une marée en mer.
     * @return this.landings Collection<Landing>
     */
    public Collection<Landing> getLandings()
    {
        return this.landings;
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param landingsIn Collection<Landing>
     */
    public void setLandings(Collection<Landing> landingsIn)
    {
        this.landings = landingsIn;
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param elementToAdd Landing
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLandings(Landing elementToAdd)
    {
        return this.landings.add(elementToAdd);
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param elementToRemove Landing
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLandings(Landing elementToRemove)
    {
        return this.landings.remove(elementToRemove);
    }

    private Location location;

    /**
     * Le lieu observé (site de débarquement, port, etc).
     * The obsevred location (landing, site, port...)
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Le lieu observé (site de débarquement, port, etc).
     * The obsevred location (landing, site, port...)
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Flag qualité. Par défaut : "non qualifiée".
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Flag qualité. Par défaut : "non qualifiée".
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    /**
     * Returns <code>true</code> if the argument is an ObservedLocation instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof ObservedLocation))
        {
            return false;
        }
        final ObservedLocation that = (ObservedLocation)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link ObservedLocation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link ObservedLocation}.
         * @return new ObservedLocationImpl()
         */
        public static ObservedLocation newInstance()
        {
            return new ObservedLocationImpl();
        }

        /**
         * Constructs a new instance of {@link ObservedLocation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param startDateTime Date
         * @param creationDate Date
         * @param observers Collection<Person>
         * @param recorderDepartment Department
         * @param location Location
         * @param program Program
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static ObservedLocation newInstance(String synchronizationStatus, Date startDateTime, Date creationDate, Collection<Person> observers, Department recorderDepartment, Location location, Program program, QualityFlag qualityFlag)
        {
            final ObservedLocation entity = new ObservedLocationImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setStartDateTime(startDateTime);
            entity.setCreationDate(creationDate);
            entity.setObservers(observers);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setLocation(location);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link ObservedLocation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param startDateTime Date
         * @param endDateTime Date
         * @param comments String
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param samplingStrataReference String
         * @param remoteId Integer
         * @param observers Collection<Person>
         * @param observedLocationFeatures Collection<ObservedLocationFeatures>
         * @param recorderPerson Person
         * @param recorderDepartment Department
         * @param dailyActivityCalendars Collection<DailyActivityCalendar>
         * @param landings Collection<Landing>
         * @param location Location
         * @param program Program
         * @param qualityFlag QualityFlag
         * @return newInstance ObservedLocation
         */
        public static ObservedLocation newInstance(String synchronizationStatus, Date startDateTime, Date endDateTime, String comments, Date qualificationDate, String qualificationComments, Date creationDate, Timestamp updateDate, String samplingStrataReference, Integer remoteId, Collection<Person> observers, Collection<ObservedLocationFeatures> observedLocationFeatures, Person recorderPerson, Department recorderDepartment, Collection<DailyActivityCalendar> dailyActivityCalendars, Collection<Landing> landings, Location location, Program program, QualityFlag qualityFlag)
        {
            final ObservedLocation entity = new ObservedLocationImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setComments(comments);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setSamplingStrataReference(samplingStrataReference);
            entity.setRemoteId(remoteId);
            entity.setObservers(observers);
            entity.setObservedLocationFeatures(observedLocationFeatures);
            entity.setRecorderPerson(recorderPerson);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setDailyActivityCalendars(dailyActivityCalendars);
            entity.setLandings(landings);
            entity.setLocation(location);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(ObservedLocation o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getStartDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDateTime().compareTo(o.getStartDateTime()));
            }
            if (this.getEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDateTime().compareTo(o.getEndDateTime()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getSamplingStrataReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingStrataReference().compareTo(o.getSamplingStrataReference()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// ObservedLocation.java merge-point
}