/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatFileResult;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportProtocolAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportProtocolAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportProtocolAction(GenericFormatContextSupport importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporarySpeciesFileResult().isValid() && this.importContext.getProtocolFileResult().isFound();
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import protocol (no file found or archive is not valid).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.protocol", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        GenericFormatArchive archive = this.importContext.getImportRequest().getArchive();
        if (log.isInfoEnabled()) {
            log.info((Object)"Import protocol.");
        }
        GenericFormatFileResult fileResult = this.importContext.getProtocolFileResult();
        fileResult.setImported(true);
        try {
            Map missingBenthos;
            TuttiProtocol tuttiProtocol = this.persistenceHelper.importProtocol(archive.getProtocolPath().toFile());
            Map<Integer, Integer> referenceTaxonIdMap = this.importContext.getReferentialTemporarySpeciesFileResult().getReferenceTaxonIdTranslationMap();
            TuttiProtocols.translateReferenceTaxonIds((TuttiProtocol)tuttiProtocol, referenceTaxonIdMap);
            String protocolOriginalName = tuttiProtocol.getName();
            String newName = this.persistenceHelper.getProtocolFirstAvailableName(protocolOriginalName);
            tuttiProtocol.setName(newName);
            List<Species> referentSpecies = this.persistenceHelper.getAllReferentSpecies();
            Map missingSpecies = TuttiProtocols.detectMissingSpecies((TuttiProtocol)tuttiProtocol, referentSpecies);
            if (!missingSpecies.isEmpty()) {
                String message = TuttiProtocols.getBadSpeciesMessage((Map)missingSpecies);
                fileResult.addGlobalError(message);
            }
            if (!(missingBenthos = TuttiProtocols.detectMissingBenthos((TuttiProtocol)tuttiProtocol, referentSpecies)).isEmpty()) {
                String message = TuttiProtocols.getBadBenthosMessage((Map)missingBenthos);
                fileResult.addGlobalError(message);
            }
            if (fileResult.isValid()) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.protocol", (Object[])new Object[]{protocolOriginalName}));
                tuttiProtocol = this.persistenceHelper.createProtocol(tuttiProtocol);
                this.importContext.setImportedProtocol(tuttiProtocol);
                this.importContext.setProtocolOriginalName(protocolOriginalName);
            } else {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.protocol.notValid", (Object[])new Object[]{protocolOriginalName}));
            }
        }
        catch (ApplicationTechnicalException e) {
            fileResult.addGlobalError(e.getCause().getMessage());
        }
    }
}

