/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.actions;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.EditFishingOperationAction;
import java.util.Date;
import java.util.List;
import org.nuiton.util.DateUtil;

public class NewFishingOperationAction
extends EditFishingOperationAction {
    public NewFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        FishingOperationsUIModel model = (FishingOperationsUIModel)this.getModel();
        model.setCatchEnabled(true);
        model.setEditionAdjusting(true);
        try {
            model.setSelectedFishingOperation(null);
        }
        finally {
            model.setEditionAdjusting(false);
        }
        FishingOperation newFishingOperation = FishingOperations.newFishingOperation();
        Cruise cruise = this.getDataContext().getCruise();
        newFishingOperation.setCruise(cruise);
        newFishingOperation.setVessel(cruise.getVessel());
        List<GearWithOriginalRankOrder> gears = cruise.getGear();
        if (gears.size() == 1) {
            newFishingOperation.setGear(gears.get(0));
        }
        if (cruise.getMultirigNumber() == 1) {
            newFishingOperation.setMultirigAggregation("1");
        }
        Date today = DateUtil.getDay((Date)new Date());
        newFishingOperation.setGearShootingStartDate(today);
        newFishingOperation.setGearShootingEndDate(today);
        newFishingOperation.setFishingOperationValid(true);
        this.setFishingOperation(newFishingOperation);
        super.doAction();
    }
}

