package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class EditProtocolUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED = "addBenthosProtocolButton.enabled";
    public static final String BINDING_ADD_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "addCaracteristicMappingButton.enabled";
    public static final String BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED = "addSpeciesProtocolButton.enabled";
    public static final String BINDING_BENTHOS_COMBO_BOX_ENABLED = "benthosComboBox.enabled";
    public static final String BINDING_CARACTERISTIC_MAPPING_COMBO_BOX_ENABLED = "caracteristicMappingComboBox.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED = "removeBenthosProtocolButton.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MAPPING_BUTTON_ENABLED = "removeCaracteristicMappingButton.enabled";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED = "removeSpeciesProtocolButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addBenthosProtocolButton;
    protected JButton addCaracteristicMappingButton;
    protected JButton addSpeciesProtocolButton;
    protected JPanel benthosActions;
    protected BeanFilterableComboBox<Species> benthosComboBox;
    protected JPanel benthosPanel;
    protected JXTable benthosTable;
    protected JPopupMenu benthosTablePopup;
    protected TuttiHelpBroker broker;
    protected JPanel caracteristicActions;
    protected BeanFilterableComboBox<Caracteristic> caracteristicMappingComboBox;
    protected JPopupMenu caracteristicMappingTablePopup;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JXTable caracteristicsMappingTable;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected EditProtocolUI editProtocolTopPanel = this;
    protected JButton exportAllCaracteristicButton;
    protected JButton exportBenthosButton;
    protected JButton exportCaracteristicButton;
    protected JButton exportPupitriButton;
    protected JButton exportSpeciesButton;
    protected final EditProtocolUIHandler handler = createHandler();
    protected JButton importBenthosButton;
    protected JButton importCaracteristicButton;
    protected JButton importColumnsButton;
    protected JButton importSpeciesButton;
    protected BeanDoubleList<Caracteristic> individualObservationList;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JXTable operationFieldsMappingTable;
    protected Table protocolInfoForm;
    protected JMenuItem removeBenthosProtocolButton;
    protected JMenuItem removeCaracteristicMappingButton;
    protected JMenuItem removeSpeciesProtocolButton;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JButton selectOtherBenthosButton;
    protected JButton selectOtherSpeciesButton;
    protected JPanel speciesActions;
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu speciesTablePopup;
    protected JTabbedPane tabPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyPressed__on__benthosTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, benthosTablePopup);
    }

    public void doKeyPressed__on__caracteristicsMappingTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, caracteristicMappingTablePopup);
    }

    public void doKeyPressed__on__speciesTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, speciesTablePopup);
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__benthosTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, benthosTablePopup);
    }

    public void doMouseClicked__on__caracteristicsMappingTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, caracteristicMappingTablePopup);
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, speciesTablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddBenthosProtocolButton() {
        return addBenthosProtocolButton;
    }

    public JButton getAddCaracteristicMappingButton() {
        return addCaracteristicMappingButton;
    }

    public JButton getAddSpeciesProtocolButton() {
        return addSpeciesProtocolButton;
    }

    public JPanel getBenthosActions() {
        return benthosActions;
    }

    public BeanFilterableComboBox<Species> getBenthosComboBox() {
        return benthosComboBox;
    }

    public JPanel getBenthosPanel() {
        return benthosPanel;
    }

    public JXTable getBenthosTable() {
        return benthosTable;
    }

    public JPopupMenu getBenthosTablePopup() {
        return benthosTablePopup;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCaracteristicActions() {
        return caracteristicActions;
    }

    public BeanFilterableComboBox<Caracteristic> getCaracteristicMappingComboBox() {
        return caracteristicMappingComboBox;
    }

    public JPopupMenu getCaracteristicMappingTablePopup() {
        return caracteristicMappingTablePopup;
    }

    public JTabbedPane getCaracteristicPane() {
        return caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return caracteristicPanel;
    }

    public JXTable getCaracteristicsMappingTable() {
        return caracteristicsMappingTable;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JButton getExportAllCaracteristicButton() {
        return exportAllCaracteristicButton;
    }

    public JButton getExportBenthosButton() {
        return exportBenthosButton;
    }

    public JButton getExportCaracteristicButton() {
        return exportCaracteristicButton;
    }

    public JButton getExportPupitriButton() {
        return exportPupitriButton;
    }

    public JButton getExportSpeciesButton() {
        return exportSpeciesButton;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public JButton getImportBenthosButton() {
        return importBenthosButton;
    }

    public JButton getImportCaracteristicButton() {
        return importCaracteristicButton;
    }

    public JButton getImportColumnsButton() {
        return importColumnsButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getIndividualObservationList() {
        return individualObservationList;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return lengthClassesList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JXTable getOperationFieldsMappingTable() {
        return operationFieldsMappingTable;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveBenthosProtocolButton() {
        return removeBenthosProtocolButton;
    }

    public JMenuItem getRemoveCaracteristicMappingButton() {
        return removeCaracteristicMappingButton;
    }

    public JMenuItem getRemoveSpeciesProtocolButton() {
        return removeSpeciesProtocolButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JLabel getSaveWarning() {
        return saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return saveWarningContainer;
    }

    public JButton getSelectOtherBenthosButton() {
        return selectOtherBenthosButton;
    }

    public JButton getSelectOtherSpeciesButton() {
        return selectOtherSpeciesButton;
    }

    public JPanel getSpeciesActions() {
        return speciesActions;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getSpeciesTablePopup() {
        return speciesTablePopup;
    }

    public JTabbedPane getTabPanel() {
        return tabPanel;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosActions() {
        if (!allComponentsCreated) {
            return;
        }
        benthosActions.add(importBenthosButton);
        benthosActions.add(exportBenthosButton);
    }

    protected void addChildrenToBenthosPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosPanel.add(benthosActions, BorderLayout.NORTH);
        benthosPanel.add($Table2, BorderLayout.CENTER);
    }

    protected void addChildrenToBenthosTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTablePopup.add(removeBenthosProtocolButton);
    }

    protected void addChildrenToCaracteristicActions() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicActions.add(importCaracteristicButton);
        caracteristicActions.add(exportCaracteristicButton);
        caracteristicActions.add(exportAllCaracteristicButton);
        caracteristicActions.add(importColumnsButton);
    }

    protected void addChildrenToCaracteristicMappingTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicMappingTablePopup.add(removeCaracteristicMappingButton);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPane.add(lengthClassesList);
        caracteristicPane.add(individualObservationList);
        caracteristicPane.add($Table0);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 0));
        caracteristicPane.setTitleAt(0, t("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 1));
        caracteristicPane.setTitleAt(1, t("tutti.editProtocol.tab.caracteristic.individualObservation"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 2));
        caracteristicPane.setTitleAt(2, t("tutti.editProtocol.tab.caracteristic.mapping"));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPanel.add(caracteristicActions, BorderLayout.NORTH);
        caracteristicPanel.add(caracteristicPane, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditProtocolTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPanel, BorderLayout.CENTER);
        add(saveWarningContainer, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        saveWarningContainer.add(saveWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesActions() {
        if (!allComponentsCreated) {
            return;
        }
        speciesActions.add(importSpeciesButton);
        speciesActions.add(exportSpeciesButton);
        speciesActions.add(exportPupitriButton);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesPanel.add(speciesActions, BorderLayout.NORTH);
        speciesPanel.add($Table1, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTablePopup.add(removeSpeciesProtocolButton);
    }

    protected void addChildrenToTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        tabPanel.add(protocolInfoForm);
        tabPanel.add(caracteristicPanel);
        tabPanel.add(speciesPanel);
        tabPanel.add(benthosPanel);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 0));
        tabPanel.setTitleAt(0, t("tutti.editProtocol.tab.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 1));
        tabPanel.setTitleAt(1, t("tutti.editProtocol.tab.caracteristic"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 2));
        tabPanel.setTitleAt(2, t("tutti.editProtocol.tab.species"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 3));
        tabPanel.setTitleAt(3, t("tutti.editProtocol.tab.benthos"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddBenthosProtocolButton() {
        $objectMap.put("addBenthosProtocolButton", addBenthosProtocolButton = new JButton());
        
        addBenthosProtocolButton.setName("addBenthosProtocolButton");
        addBenthosProtocolButton.setToolTipText(t("tutti.editProtocol.action.addBenthosProtocol.tip"));
        addBenthosProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddBenthosProtocolAction.class);
        addBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addBenthosProtocol.help");
    }

    protected void createAddCaracteristicMappingButton() {
        $objectMap.put("addCaracteristicMappingButton", addCaracteristicMappingButton = new JButton());
        
        addCaracteristicMappingButton.setName("addCaracteristicMappingButton");
        addCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.addCaracteristicMapping.tip"));
        addCaracteristicMappingButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddCaracteristicMappingAction.class);
        addCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.addCaracteristicMapping.help");
    }

    protected void createAddSpeciesProtocolButton() {
        $objectMap.put("addSpeciesProtocolButton", addSpeciesProtocolButton = new JButton());
        
        addSpeciesProtocolButton.setName("addSpeciesProtocolButton");
        addSpeciesProtocolButton.setToolTipText(t("tutti.editProtocol.action.addSpeciesProtocol.tip"));
        addSpeciesProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.AddSpeciesProtocolAction.class);
        addSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addSpeciesProtocol.help");
    }

    protected void createBenthosActions() {
        $objectMap.put("benthosActions", benthosActions = new JPanel());
        
        benthosActions.setName("benthosActions");
        benthosActions.setLayout(new GridLayout());
    }

    protected void createBenthosComboBox() {
        $objectMap.put("benthosComboBox", benthosComboBox = new BeanFilterableComboBox<Species>(this));
        
        benthosComboBox.setName("benthosComboBox");
        benthosComboBox.setShowReset(true);
        benthosComboBox.setToolTipText(t("tutti.editProtocol.field.benthos.tip"));
        benthosComboBox.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosPanel() {
        $objectMap.put("benthosPanel", benthosPanel = new JPanel());
        
        benthosPanel.setName("benthosPanel");
        benthosPanel.setLayout(new BorderLayout());
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new JXTable());
        
        benthosTable.setName("benthosTable");
        benthosTable.setSortable(true);
        benthosTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__benthosTable"));
        benthosTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__benthosTable"));
        benthosTable.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosTablePopup() {
        $objectMap.put("benthosTablePopup", benthosTablePopup = new JPopupMenu());
        
        benthosTablePopup.setName("benthosTablePopup");
        benthosTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editProtocol.help"));
    }

    protected void createCaracteristicActions() {
        $objectMap.put("caracteristicActions", caracteristicActions = new JPanel());
        
        caracteristicActions.setName("caracteristicActions");
        caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicMappingComboBox() {
        $objectMap.put("caracteristicMappingComboBox", caracteristicMappingComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        caracteristicMappingComboBox.setName("caracteristicMappingComboBox");
        caracteristicMappingComboBox.setShowReset(true);
        caracteristicMappingComboBox.setToolTipText(t("tutti.editProtocol.field.caracteristicMapping.tip"));
        caracteristicMappingComboBox.putClientProperty("help", "tutti.editProtocol.field.caracteristicMapping.help");
    }

    protected void createCaracteristicMappingTablePopup() {
        $objectMap.put("caracteristicMappingTablePopup", caracteristicMappingTablePopup = new JPopupMenu());
        
        caracteristicMappingTablePopup.setName("caracteristicMappingTablePopup");
        caracteristicMappingTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createCaracteristicPane() {
        $objectMap.put("caracteristicPane", caracteristicPane = new JTabbedPane());
        
        caracteristicPane.setName("caracteristicPane");
        caracteristicPane.putClientProperty("help", "tutti.editProtocol.pane.caracteristic.help");
    }

    protected void createCaracteristicPanel() {
        $objectMap.put("caracteristicPanel", caracteristicPanel = new JPanel());
        
        caracteristicPanel.setName("caracteristicPanel");
        caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCaracteristicsMappingTable() {
        $objectMap.put("caracteristicsMappingTable", caracteristicsMappingTable = new JXTable());
        
        caracteristicsMappingTable.setName("caracteristicsMappingTable");
        caracteristicsMappingTable.setEnabled(true);
        caracteristicsMappingTable.setSortable(false);
        caracteristicsMappingTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__caracteristicsMappingTable"));
        caracteristicsMappingTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__caracteristicsMappingTable"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editProtocol.action.closeEditProtocol"));
        closeButton.setToolTipText(t("tutti.editProtocol.action.closeEditProtocol.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
        closeButton.putClientProperty("help", "tutti.editProtocol.action.closeEditProtocol.help");
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", t("tutti.editProtocol.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(t("tutti.editProtocol.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editProtocol.field.comment.help");
    }

    protected void createExportAllCaracteristicButton() {
        $objectMap.put("exportAllCaracteristicButton", exportAllCaracteristicButton = new JButton());
        
        exportAllCaracteristicButton.setName("exportAllCaracteristicButton");
        exportAllCaracteristicButton.setText(t("tutti.editProtocol.action.exportProtocolAllCaracteristic"));
        exportAllCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolAllCaracteristic.tip"));
        exportAllCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportAllCaracteristicAction.class);
        exportAllCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
    }

    protected void createExportBenthosButton() {
        $objectMap.put("exportBenthosButton", exportBenthosButton = new JButton());
        
        exportBenthosButton.setName("exportBenthosButton");
        exportBenthosButton.setText(t("tutti.editProtocol.action.exportProtocolBenthos"));
        exportBenthosButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolBenthos.tip"));
        exportBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolBenthosAction.class);
        exportBenthosButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolBenthos.help");
    }

    protected void createExportCaracteristicButton() {
        $objectMap.put("exportCaracteristicButton", exportCaracteristicButton = new JButton());
        
        exportCaracteristicButton.setName("exportCaracteristicButton");
        exportCaracteristicButton.setText(t("tutti.editProtocol.action.exportProtocolCaracteristic"));
        exportCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolCaracteristic.tip"));
        exportCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolCaracteristicAction.class);
        exportCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
    }

    protected void createExportPupitriButton() {
        $objectMap.put("exportPupitriButton", exportPupitriButton = new JButton());
        
        exportPupitriButton.setName("exportPupitriButton");
        exportPupitriButton.setText(t("tutti.editProtocol.action.exportPupitri"));
        exportPupitriButton.setToolTipText(t("tutti.editProtocol.action.exportPupitri.tip"));
        exportPupitriButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportPupitriAction.class);
        exportPupitriButton.putClientProperty("help", "tutti.editProtocol.action.exportPupitri.help");
    }

    protected void createExportSpeciesButton() {
        $objectMap.put("exportSpeciesButton", exportSpeciesButton = new JButton());
        
        exportSpeciesButton.setName("exportSpeciesButton");
        exportSpeciesButton.setText(t("tutti.editProtocol.action.exportProtocolSpecies"));
        exportSpeciesButton.setToolTipText(t("tutti.editProtocol.action.exportProtocolSpecies.tip"));
        exportSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ExportProtocolSpeciesAction.class);
        exportSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolSpecies.help");
    }

    protected EditProtocolUIHandler createHandler() {
        return new EditProtocolUIHandler();
    }

    protected void createImportBenthosButton() {
        $objectMap.put("importBenthosButton", importBenthosButton = new JButton());
        
        importBenthosButton.setName("importBenthosButton");
        importBenthosButton.setText(t("tutti.editProtocol.action.importProtocolBenthos"));
        importBenthosButton.setToolTipText(t("tutti.editProtocol.action.importProtocolBenthos.tip"));
        importBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolBenthosAction.class);
        importBenthosButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolBenthos.help");
    }

    protected void createImportCaracteristicButton() {
        $objectMap.put("importCaracteristicButton", importCaracteristicButton = new JButton());
        
        importCaracteristicButton.setName("importCaracteristicButton");
        importCaracteristicButton.setText(t("tutti.editProtocol.action.importProtocolCaracteristic"));
        importCaracteristicButton.setToolTipText(t("tutti.editProtocol.action.importProtocolCaracteristic.tip"));
        importCaracteristicButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolCaracteristicAction.class);
        importCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolCaracteristic.help");
    }

    protected void createImportColumnsButton() {
        $objectMap.put("importColumnsButton", importColumnsButton = new JButton());
        
        importColumnsButton.setName("importColumnsButton");
        importColumnsButton.setText(t("tutti.editProtocol.action.importProtocolColumns"));
        importColumnsButton.setToolTipText(t("tutti.editProtocol.action.importProtocolColumns.tip"));
        importColumnsButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.LoadProtocolImportColumnsAction.class);
        importColumnsButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolColumns.help");
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(t("tutti.editProtocol.action.importProtocolSpecies"));
        importSpeciesButton.setToolTipText(t("tutti.editProtocol.action.importProtocolSpecies.tip"));
        importSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.ImportProtocolSpeciesAction.class);
        importSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolSpecies.help");
    }

    protected void createIndividualObservationList() {
        $objectMap.put("individualObservationList", individualObservationList = new BeanDoubleList<Caracteristic>());
        
        individualObservationList.setName("individualObservationList");
        individualObservationList.setShowSelectPopupEnabled(true);
        individualObservationList.setProperty("individualObservationPmfm");
        individualObservationList.setShowReset(true);
        individualObservationList.putClientProperty("help", "tutti.editProtocol.field.individualObservation.help");
    }

    protected void createLengthClassesList() {
        $objectMap.put("lengthClassesList", lengthClassesList = new BeanDoubleList<Caracteristic>());
        
        lengthClassesList.setName("lengthClassesList");
        lengthClassesList.setShowSelectPopupEnabled(true);
        lengthClassesList.setProperty("lengthClassesPmfm");
        lengthClassesList.setShowReset(true);
        lengthClassesList.putClientProperty("help", "tutti.editProtocol.field.lengthClasses.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("help", "tutti.editProtocol.field.name.help");
        nameField.putClientProperty("validatorLabel", t("tutti.editProtocol.field.protocol.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("tutti.editProtocol.field.protocol.name"));
        nameLabel.setToolTipText(t("tutti.editProtocol.field.protocol.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editProtocol.field.name.help");
    }

    protected void createOperationFieldsMappingTable() {
        $objectMap.put("operationFieldsMappingTable", operationFieldsMappingTable = new JXTable());
        
        operationFieldsMappingTable.setName("operationFieldsMappingTable");
        operationFieldsMappingTable.setEnabled(true);
        operationFieldsMappingTable.setSortable(false);
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveBenthosProtocolButton() {
        $objectMap.put("removeBenthosProtocolButton", removeBenthosProtocolButton = new JMenuItem());
        
        removeBenthosProtocolButton.setName("removeBenthosProtocolButton");
        removeBenthosProtocolButton.setText(t("tutti.editProtocol.action.removeBenthosProtocol"));
        removeBenthosProtocolButton.setToolTipText(t("tutti.editProtocol.action.removeBenthosProtocol.tip"));
        removeBenthosProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveBenthosProtocolAction.class);
        removeBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeBenthosProtocol.help");
    }

    protected void createRemoveCaracteristicMappingButton() {
        $objectMap.put("removeCaracteristicMappingButton", removeCaracteristicMappingButton = new JMenuItem());
        
        removeCaracteristicMappingButton.setName("removeCaracteristicMappingButton");
        removeCaracteristicMappingButton.setText(t("tutti.editProtocol.action.removeCaracteristicMapping"));
        removeCaracteristicMappingButton.setToolTipText(t("tutti.editProtocol.action.removeCaracteristicMapping.tip"));
        removeCaracteristicMappingButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveCaracteristicMappingAction.class);
        removeCaracteristicMappingButton.putClientProperty("help", "tutti.editProtocol.action.removeCaracteristicMapping.help");
    }

    protected void createRemoveSpeciesProtocolButton() {
        $objectMap.put("removeSpeciesProtocolButton", removeSpeciesProtocolButton = new JMenuItem());
        
        removeSpeciesProtocolButton.setName("removeSpeciesProtocolButton");
        removeSpeciesProtocolButton.setText(t("tutti.editProtocol.action.removeSpeciesProtocol"));
        removeSpeciesProtocolButton.setToolTipText(t("tutti.editProtocol.action.removeSpeciesProtocol.tip"));
        removeSpeciesProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.RemoveSpeciesProtocolAction.class);
        removeSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeSpeciesProtocol.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editProtocol.action.saveProtocol"));
        saveButton.setToolTipText(t("tutti.editProtocol.action.saveProtocol.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SaveProtocolAction.class);
        saveButton.putClientProperty("help", "tutti.editProtocol.action.saveProtocol.help");
    }

    protected void createSaveWarning() {
        $objectMap.put("saveWarning", saveWarning = new JLabel());
        
        saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        $objectMap.put("saveWarningContainer", saveWarningContainer = new JPanel());
        
        saveWarningContainer.setName("saveWarningContainer");
        saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSelectOtherBenthosButton() {
        $objectMap.put("selectOtherBenthosButton", selectOtherBenthosButton = new JButton());
        
        selectOtherBenthosButton.setName("selectOtherBenthosButton");
        selectOtherBenthosButton.setText(t("tutti.editProtocol.action.selectOtherBenthos"));
        selectOtherBenthosButton.setToolTipText(t("tutti.editProtocol.action.selectOtherBenthos.tip"));
        selectOtherBenthosButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SelectOtherBenthosAction.class);
        selectOtherBenthosButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherBenthos.help");
    }

    protected void createSelectOtherSpeciesButton() {
        $objectMap.put("selectOtherSpeciesButton", selectOtherSpeciesButton = new JButton());
        
        selectOtherSpeciesButton.setName("selectOtherSpeciesButton");
        selectOtherSpeciesButton.setText(t("tutti.editProtocol.action.selectOtherSpecies"));
        selectOtherSpeciesButton.setToolTipText(t("tutti.editProtocol.action.selectOtherSpecies.tip"));
        selectOtherSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.protocol.actions.SelectOtherSpeciesAction.class);
        selectOtherSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherSpecies.help");
    }

    protected void createSpeciesActions() {
        $objectMap.put("speciesActions", speciesActions = new JPanel());
        
        speciesActions.setName("speciesActions");
        speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setShowReset(true);
        speciesComboBox.setToolTipText(t("tutti.editProtocol.field.species.tip"));
        speciesComboBox.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesPanel() {
        $objectMap.put("speciesPanel", speciesPanel = new JPanel());
        
        speciesPanel.setName("speciesPanel");
        speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(true);
        speciesTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__speciesTable"));
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
        speciesTable.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesTablePopup() {
        $objectMap.put("speciesTablePopup", speciesTablePopup = new JPopupMenu());
        
        speciesTablePopup.setName("speciesTablePopup");
        speciesTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createTabPanel() {
        $objectMap.put("tabPanel", tabPanel = new JTabbedPane());
        
        tabPanel.setName("tabPanel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProtocolTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesTablePopup();
        addChildrenToBenthosTablePopup();
        addChildrenToCaracteristicMappingTablePopup();
        addChildrenToTabPanel();
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        addChildrenToCaracteristicPanel();
        addChildrenToCaracteristicActions();
        addChildrenToCaracteristicPane();
        // inline complete setup of $Table0
        $Table0.add(caracteristicMappingComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addCaracteristicMappingButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(caracteristicsMappingTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(operationFieldsMappingTable);
        addChildrenToSpeciesPanel();
        addChildrenToSpeciesActions();
        // inline complete setup of $Table1
        $Table1.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(selectOtherSpeciesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(addSpeciesProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(speciesTable);
        addChildrenToBenthosPanel();
        addChildrenToBenthosActions();
        // inline complete setup of $Table2
        $Table2.add(benthosComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(selectOtherBenthosButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(addBenthosProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane3, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(benthosTable);
        addChildrenToSaveWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(saveButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 65 property setters
        lengthClassesList.setBeanType(Caracteristic.class);
        individualObservationList.setBeanType(Caracteristic.class);
        caracteristicMappingComboBox.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        benthosComboBox.setBeanType(Species.class);
        removeSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeSpeciesProtocol.mnemonic"),'Z'));
        removeBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeBenthosProtocol.mnemonic"),'Z'));
        removeCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("delete"));
        removeCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.removeCaracteristicMapping.mnemonic"),'Z'));
        nameLabel.setLabelFor(nameField);
        commentPane.setBorder(BorderFactory.createTitledBorder(t("tutti.editProtocol.field.comment")));
        importCaracteristicButton.setIcon(SwingUtil.createActionIcon("import"));
        importCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolCaracteristic.mnemonic"),'Z'));
        exportCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolCaracteristic.mnemonic"),'Z'));
        exportAllCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportAllCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolAllCaracteristic.mnemonic"),'Z'));
        importColumnsButton.setIcon(SwingUtil.createActionIcon("import"));
        importColumnsButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolColumns.mnemonic"),'Z'));
        caracteristicPane.setTabPlacement(JTabbedPane.LEFT);
        lengthClassesList.setBean(model);
        individualObservationList.setBean(model);
        addCaracteristicMappingButton.setIcon(SwingUtil.createActionIcon("add"));
        addCaracteristicMappingButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addCaracteristicMapping.mnemonic"),'Z'));
        caracteristicsMappingTable.setSelectionForeground(Color.BLACK);
        caracteristicsMappingTable.setSelectionBackground(null);
        operationFieldsMappingTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        operationFieldsMappingTable.setSelectionForeground(Color.BLACK);
        operationFieldsMappingTable.setSelectionBackground(null);
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        importSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolSpecies.mnemonic"),'Z'));
        exportSpeciesButton.setIcon(SwingUtil.createActionIcon("export"));
        exportSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolSpecies.mnemonic"),'Z'));
        exportPupitriButton.setIcon(SwingUtil.createActionIcon("export"));
        exportPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportPupitri.mnemonic"),'Z'));
        selectOtherSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.selectOtherSpecies.mnemonic"),'Z'));
        addSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        addSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addSpeciesProtocol.mnemonic"),'Z'));
        speciesTable.setSelectionForeground(Color.BLACK);
        importBenthosButton.setIcon(SwingUtil.createActionIcon("import"));
        importBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.importProtocolBenthos.mnemonic"),'Z'));
        exportBenthosButton.setIcon(SwingUtil.createActionIcon("export"));
        exportBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.exportProtocolBenthos.mnemonic"),'Z'));
        selectOtherBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.selectOtherBenthos.mnemonic"),'Z'));
        addBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        addBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.addBenthosProtocol.mnemonic"),'Z'));
        benthosTable.setSelectionForeground(Color.BLACK);
        saveWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        saveWarning.setIcon(SwingUtil.createActionIcon("warning"));
        saveWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.closeEditProtocol.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProtocol.action.saveProtocol.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProtocolTopPanel, "tutti.editProtocol.help");
        registerHelpId(_broker, removeSpeciesProtocolButton, "tutti.editProtocol.action.removeSpeciesProtocol.help");
        registerHelpId(_broker, removeBenthosProtocolButton, "tutti.editProtocol.action.removeBenthosProtocol.help");
        registerHelpId(_broker, removeCaracteristicMappingButton, "tutti.editProtocol.action.removeCaracteristicMapping.help");
        registerHelpId(_broker, nameLabel, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, nameField, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, commentPane, "tutti.editProtocol.field.comment.help");
        registerHelpId(_broker, importCaracteristicButton, "tutti.editProtocol.action.importProtocolCaracteristic.help");
        registerHelpId(_broker, exportCaracteristicButton, "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        registerHelpId(_broker, exportAllCaracteristicButton, "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        registerHelpId(_broker, importColumnsButton, "tutti.editProtocol.action.importProtocolColumns.help");
        registerHelpId(_broker, caracteristicPane, "tutti.editProtocol.pane.caracteristic.help");
        registerHelpId(_broker, lengthClassesList, "tutti.editProtocol.field.lengthClasses.help");
        registerHelpId(_broker, individualObservationList, "tutti.editProtocol.field.individualObservation.help");
        registerHelpId(_broker, caracteristicMappingComboBox, "tutti.editProtocol.field.caracteristicMapping.help");
        registerHelpId(_broker, addCaracteristicMappingButton, "tutti.editProtocol.action.addCaracteristicMapping.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.editProtocol.action.importProtocolSpecies.help");
        registerHelpId(_broker, exportSpeciesButton, "tutti.editProtocol.action.exportProtocolSpecies.help");
        registerHelpId(_broker, exportPupitriButton, "tutti.editProtocol.action.exportPupitri.help");
        registerHelpId(_broker, speciesComboBox, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, selectOtherSpeciesButton, "tutti.editProtocol.action.selectOtherSpecies.help");
        registerHelpId(_broker, addSpeciesProtocolButton, "tutti.editProtocol.action.addSpeciesProtocol.help");
        registerHelpId(_broker, speciesTable, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, importBenthosButton, "tutti.editProtocol.action.importProtocolBenthos.help");
        registerHelpId(_broker, exportBenthosButton, "tutti.editProtocol.action.exportProtocolBenthos.help");
        registerHelpId(_broker, benthosComboBox, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, selectOtherBenthosButton, "tutti.editProtocol.action.selectOtherBenthos.help");
        registerHelpId(_broker, addBenthosProtocolButton, "tutti.editProtocol.action.addBenthosProtocol.help");
        registerHelpId(_broker, benthosTable, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, closeButton, "tutti.editProtocol.action.closeEditProtocol.help");
        registerHelpId(_broker, saveButton, "tutti.editProtocol.action.saveProtocol.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editProtocolTopPanel", editProtocolTopPanel);
        createModel();
        createBroker();
        createValidator();
        createSpeciesTablePopup();
        createRemoveSpeciesProtocolButton();
        createBenthosTablePopup();
        createRemoveBenthosProtocolButton();
        createCaracteristicMappingTablePopup();
        createRemoveCaracteristicMappingButton();
        createTabPanel();
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        createCaracteristicPanel();
        createCaracteristicActions();
        createImportCaracteristicButton();
        createExportCaracteristicButton();
        createExportAllCaracteristicButton();
        createImportColumnsButton();
        createCaracteristicPane();
        createLengthClassesList();
        createIndividualObservationList();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createCaracteristicMappingComboBox();
        createAddCaracteristicMappingButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCaracteristicsMappingTable();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createOperationFieldsMappingTable();
        createSpeciesPanel();
        createSpeciesActions();
        createImportSpeciesButton();
        createExportSpeciesButton();
        createExportPupitriButton();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSpeciesComboBox();
        createSelectOtherSpeciesButton();
        createAddSpeciesProtocolButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSpeciesTable();
        createBenthosPanel();
        createBenthosActions();
        createImportBenthosButton();
        createExportBenthosButton();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createBenthosComboBox();
        createSelectOtherBenthosButton();
        createAddBenthosProtocolButton();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createBenthosTable();
        createSaveWarningContainer();
        createSaveWarning();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("tutti.editProtocol.tab.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("tutti.editProtocol.tab.caracteristic"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(t("tutti.editProtocol.tab.caracteristic.individualObservation"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(t("tutti.editProtocol.tab.caracteristic.mapping"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(t("tutti.editProtocol.tab.species"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(t("tutti.editProtocol.tab.benthos"));
        // inline creation of editProtocolTopPanel
        setName("editProtocolTopPanel");
        setLayout(new BorderLayout());
        editProtocolTopPanel.putClientProperty("help", "tutti.editProtocol.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesProtocolButton.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosProtocolButton.setEnabled(model.isRemoveBenthosEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicMappingEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMappingButton.setEnabled(model.isRemoveCaracteristicMappingEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicMappingEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CARACTERISTIC_MAPPING_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.setEnabled(!caracteristicMappingComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CARACTERISTIC_MAPPING_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    addCaracteristicMappingButton.setEnabled( caracteristicMappingComboBox.getSelectedItem() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (caracteristicMappingComboBox != null) {
                    caracteristicMappingComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addSpeciesProtocolButton.setEnabled(handler.isSpeciesSelected(speciesComboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.setEnabled(!benthosComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    addBenthosProtocolButton.setEnabled(handler.isSpeciesSelected(benthosComboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cloned", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cleaned", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveWarningContainer.setVisible(model.isImported() || model.isCloned() || model.isCleaned());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cloned", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cleaned", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}