// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;

/**
 * <html>
 * <head>
 * </head>
 * <body>
 * <p>
 * Permet d'associer &#224; un lot  &quot;exhaustif&quot; les listes d'esp&#232;ces concern&#233;es
 * par cet exhaustivit&#233;. Les listes d'esp&#232;ces &#233;tant d&#233;finies par leur
 * niveau de priorit&#233; d'&#233;chantillonnage au niveau d'une strat&#233;gie (cf
 * ReferenceTaxonStrategy).
 * </p>
 * <p>
 * </p>
 * <p>
 * Par exemple, un lot &quot;exhautif&quot; rattach&#233; au niveau de priorit&#233; &quot;2&quot;
 * indique que l'exhautivit&#233; ne porte que sur les esp&#232;ces de priorit&#233; 2,
 * dans la strat&#233;gie applicable (cf ReferenTaxonStrategy).<br><br>Si
 * aucun niveau n'est renseign&#233;, cela indique que l'exhautivit&#233; du lot est
 * totale : toutes esp&#232;ces confondues.
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class BatchExhaustiveInventory
    implements Serializable, Comparable<BatchExhaustiveInventory>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 3211567756020532837L;

    // Generate 3 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Short priorityLevel;

    /**
     * Identifie la liste d'espèce observées de manière exhautive dans le lot. Une liste étant
     * représenté par son niveau de priorité d'échantillonnage, défini dans la stratégie (cf
     * ReferenceTaxonStrategy).
     * cf "Programmes/Stratégies" : ReferenceTaxonStrategy.priorityLevel
     * @return this.priorityLevel Short
     */
    public Short getPriorityLevel()
    {
        return this.priorityLevel;
    }

    /**
     * Identifie la liste d'espèce observées de manière exhautive dans le lot. Une liste étant
     * représenté par son niveau de priorité d'échantillonnage, défini dans la stratégie (cf
     * ReferenceTaxonStrategy).
     * cf "Programmes/Stratégies" : ReferenceTaxonStrategy.priorityLevel
     * @param priorityLevelIn Short
     */
    public void setPriorityLevel(Short priorityLevelIn)
    {
        this.priorityLevel = priorityLevelIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 1 associations
    private Batch batch;

    /**
     * Lot exhautif auquel est rattaché la précision sur la liste d'espèces concernées par
     * l'exhautivité.
     * @return this.batch Batch
     */
    public Batch getBatch()
    {
        return this.batch;
    }

    /**
     * Lot exhautif auquel est rattaché la précision sur la liste d'espèces concernées par
     * l'exhautivité.
     * @param batchIn Batch
     */
    public void setBatch(Batch batchIn)
    {
        this.batch = batchIn;
    }

    /**
     * Returns <code>true</code> if the argument is an BatchExhaustiveInventory instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof BatchExhaustiveInventory))
        {
            return false;
        }
        final BatchExhaustiveInventory that = (BatchExhaustiveInventory)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link BatchExhaustiveInventory}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link BatchExhaustiveInventory}.
         * @return new BatchExhaustiveInventoryImpl()
         */
        public static BatchExhaustiveInventory newInstance()
        {
            return new BatchExhaustiveInventoryImpl();
        }

        /**
         * Constructs a new instance of {@link BatchExhaustiveInventory}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param priorityLevel Short
         * @param batch Batch
         * @return newInstance
         */
        public static BatchExhaustiveInventory newInstance(Short priorityLevel, Batch batch)
        {
            final BatchExhaustiveInventory entity = new BatchExhaustiveInventoryImpl();
            entity.setPriorityLevel(priorityLevel);
            entity.setBatch(batch);
            return entity;
        }

        /**
         * Constructs a new instance of {@link BatchExhaustiveInventory}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param priorityLevel Short
         * @param remoteId Integer
         * @param batch Batch
         * @return newInstance BatchExhaustiveInventory
         */
        public static BatchExhaustiveInventory newInstance(Short priorityLevel, Integer remoteId, Batch batch)
        {
            final BatchExhaustiveInventory entity = new BatchExhaustiveInventoryImpl();
            entity.setPriorityLevel(priorityLevel);
            entity.setRemoteId(remoteId);
            entity.setBatch(batch);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(BatchExhaustiveInventory o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getPriorityLevel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPriorityLevel().compareTo(o.getPriorityLevel()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// BatchExhaustiveInventory.java merge-point
}