/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSurvey;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateSurveyAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateSurveyAction.class);
    private static int cruiseId = -1;
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ValidateSurveyAction(GenericFormatContextSupport importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate survey.csv file.");
        }
        int maximumRowsInErrorPerFile = this.importContext.getImportRequest().getMaximumRowsInErrorPerFile();
        GenericFormatCsvFileResult importFileResult = this.importContext.getSurveyFileResult();
        try (CsvConsumerForSurvey consumer = this.importContext.loadSurveys(false);){
            for (ImportRow row : consumer) {
                Set<FishingOperation> existingFishingOperations;
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.validate.cruises", (Object[])new Object[]{row.getLineNumber()}));
                consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(row);
                Cruise cruise = ((SurveyRow)row.getBean()).getCruise();
                CruiseDataModel existingCruiseData = this.importContext.getImportRequest().getExistingCruiseData(cruise);
                if (existingCruiseData == null) {
                    existingFishingOperations = null;
                    cruise.setId(Integer.valueOf(ValidateSurveyAction.getNextCruiseId()));
                } else {
                    existingFishingOperations = this.persistenceHelper.getFishingOperations(existingCruiseData.getId());
                }
                this.importContext.addImportedCruise(cruise, null, existingCruiseData, existingFishingOperations);
                if (consumer.getNbRowsInErrors() <= maximumRowsInErrorPerFile) continue;
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"Too much errors, stop validating this file.");
                break;
            }
            this.flushConsumer(consumer, importFileResult);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close survey.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }

    private static int getNextCruiseId() {
        return cruiseId--;
    }
}

