package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class AttachmentItem extends JPanel implements TuttiUI<AttachmentItemModel, AttachmentItemHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT = "attachmentNameLabel.toolTipText";
    public static final String BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT = "attachmentPanel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS08UQRAuVnZxeYg8RIyaoEYDIc7Gmwk+eCgRswgBDsQ9YO9OL7SZR9tdK0OIxp/gT9C7FxNvnowHzx68GP+CMR68Gqtnlh0GZmGFPcxOuuv7qurr+nre/YSsVnDpKQsCS9U8FC63Hk6tri6Un/IK3uO6ooREX0H0a8tApgRddmNdI1wpFQ28UIcXZnxX+h73dqEnitCpccvheoNzRLiYRFS0Liw3ticCWVM7rI2i0ljf/P6VeW2/epsBCCRV10GtjByGijtpL0JG2Aj9lOk5KzjMW6cylPDWqd4eszbjMK0fMZc/g5fQUYScZIrIEC633nLIEeIDidDLEFllw6XYReZxB+FmVVmiqrjLlYU1RGHVhKU3qQqrhsKxYoA11XidQ+5KGdLmELKubxuq20elmjf4mG8gDjTNF1nZsPcbRYI638Nw0cTnG7AO9H2nzBTCYCJ0hZanmUoGD/qSe3EV01Su71HqBDJaNYj+GKjZc74XaPbOJuOGSAf/4EgF5xPTQnNoxXMYD0pbCbKqRssIw6X9o7tEW9HQDu8ZWkMY7v4dGvj28ceH2d2TeiY1dJfRaIKkIpkUCpO6NxpTc5KFeSYnSpDX3CGXhi68kFLYcn2biqN8fQYeDcIDpjeIItvx/dPnoSdfT0BmFjodn9mzzMTPQR43FKngO3Yg706GFXVvnqTnaVMbQpc56hUhV3hAbhjcDgfQWudITjBaj469CEiPCyl6NIoq57/8GVh+P7mjSRvVeK5peKxL9jHkhOcIj4f+rVsz1a9dUvOa7ccWTDMl7HelrHvhUvi8uk+BDEI7hq33xa2bvNR3i+IY4rGwa/M2Dumua6GQfJUODlnZoYnNVpmj6b+n7Cubq0UmPOT2znpa0h3PHpaoHaGTZkP43lzF+DRv7Hu9KkzWnjUtXOnwqXAf4dF26/dQxKmthcRtEDFZFXNKJGi3uHHTm/fIz56oIIxHnDHLfVvQhNS5LFOZ5Taik6dxrQUsCpkmVeqN9b+65UgpX1Eh/WtMSkdUmNk7jnLLievwWMqZm/WoyoXYZsqlXdn/rRyZiGPKuC0eQbSlPd+Gg2W7fnDr0YemqXCjLaGbSNfkK3aYeHRF5xy25VMwnLpl0/0wUhaeTZLc2ZelzTw7ifEfU9erGQ0KAAA=";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected final AttachmentItemHandler handler = createHandler();
    protected AttachmentItemModel model;
    protected JButton openAttachmentButton;
    protected JButton removeAttachmentButton;
    protected JButton saveAttachmentButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem(AttachmentEditorUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            TuttiUIUtil.setApplicationContext(this, parentUI.getModel());
            $initialize();
    }

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public AttachmentItemHandler getHandler() {
        return handler;
    }

    public AttachmentItemModel getModel() {
        return model;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public JButton getSaveAttachmentButton() {
        return saveAttachmentButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(saveAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected AttachmentItemHandler createHandler() {
        return new AttachmentItemHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AttachmentItemModel.class));
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.open.tip"));
        openAttachmentButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.attachment.actions.OpenAttachmentAction.class);
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.attachment.actions.RemoveAttachmentAction.class);
    }

    protected void createSaveAttachmentButton() {
        $objectMap.put("saveAttachmentButton", saveAttachmentButton = new JButton());
        
        saveAttachmentButton.setName("saveAttachmentButton");
        saveAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.save.tip"));
        saveAttachmentButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.util.attachment.actions.SaveAttachmentAction.class);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        openAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.open.mnemonic"),'Z'));
        saveAttachmentButton.setIcon(SwingUtil.createActionIcon("import"));
        saveAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.save.mnemonic"),'Z'));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
        removeAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.remove.mnemonic"),'Z'));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentPanel", attachmentPanel);
        createModel();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createSaveAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    setToolTipText(t(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentNameLabel.setText(t(model.getName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentNameLabel.setToolTipText(t(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}