/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.bigfin.BigfinImportResult;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.csv.SpeciesOrSpeciesBatch;
import fr.ifremer.tutti.service.bigfin.signs.Sign;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class BigfinImportContext {
    private static final Log log = LogFactory.getLog(BigfinImportContext.class);
    protected final FishingOperation operation;
    protected final CatchBatch catchBatch;
    protected final Map<Sign, CaracteristicQualitativeValue> signsToCaracteristicValue;
    protected final Map<String, Species> speciesBySurveyCode;
    protected final Map<String, SpeciesProtocol> speciesProtocolBySurveyCode;
    protected final Set<Species> speciesNotRecognized = new HashSet<Species>();
    protected final Set<Species> speciesNotInProtocol = new HashSet<Species>();
    protected final Set<Species> speciesInProtocolButWithoutLengthStepPmfmId = new HashSet<Species>();
    private final List<BigfinDataRow> speciesRows = new ArrayList<BigfinDataRow>();
    private final List<BigfinDataRow> speciesBatchRows = new ArrayList<BigfinDataRow>();
    private final BigfinImportResult bigfinImportResult;
    private final BatchContainer<SpeciesBatch> rootSpeciesBatch;
    private final Map<Species, Caracteristic> lengthStepPmfmBySpecies;

    public BigfinImportContext(File importFile, FishingOperation operation, CatchBatch catchBatch, Map<Sign, CaracteristicQualitativeValue> signsToCaracteristicValue, Map<String, Species> speciesBySurveyCode, Map<String, SpeciesProtocol> speciesProtocolBySurveyCode, BatchContainer<SpeciesBatch> rootSpeciesBatch) {
        this.rootSpeciesBatch = rootSpeciesBatch;
        this.bigfinImportResult = new BigfinImportResult(importFile);
        this.operation = operation;
        this.catchBatch = catchBatch;
        this.signsToCaracteristicValue = signsToCaracteristicValue;
        this.speciesBySurveyCode = speciesBySurveyCode;
        this.speciesProtocolBySurveyCode = speciesProtocolBySurveyCode;
        this.lengthStepPmfmBySpecies = new HashMap<Species, Caracteristic>();
    }

    public Caracteristic getLengthStepPmfm(Species species, PersistenceService persistenceService) {
        Caracteristic caracteristic = this.lengthStepPmfmBySpecies.get(species);
        if (caracteristic == null) {
            SpeciesProtocol speciesProtocol = this.getSpeciesProtocol(species);
            caracteristic = persistenceService.getCaracteristic(Integer.parseInt(speciesProtocol.getLengthStepPmfmId()));
            this.lengthStepPmfmBySpecies.put(species, caracteristic);
        }
        return caracteristic;
    }

    public boolean isNoError() {
        return this.bigfinImportResult.getErrors().isEmpty();
    }

    public void addRowToProcess(BigfinDataRow bigfinDataRow) {
        if (bigfinDataRow.getSpeciesOrSpeciesBatch().isSpecies()) {
            this.speciesRows.add(bigfinDataRow);
        } else {
            this.speciesBatchRows.add(bigfinDataRow);
        }
    }

    public Map<Integer, SpeciesBatch> getSpeciesBatchesById() {
        return SpeciesBatchs.getAllSpeciesBatchesById(this.rootSpeciesBatch);
    }

    public Multimap<Species, SpeciesBatch> getRootSpeciesBatchBySpecies() {
        ImmutableListMultimap batchesBySpecies = Multimaps.index((Iterable)this.rootSpeciesBatch.getChildren(), (Function)new Function<SpeciesBatch, Species>(){

            public Species apply(SpeciesBatch input) {
                return input.getSpecies();
            }
        });
        return batchesBySpecies;
    }

    public Multimap<Species, BigfinDataRow> getSpeciesRowsBySpecies() {
        ImmutableListMultimap rowsBySpecies = Multimaps.index(this.speciesRows, (Function)new Function<BigfinDataRow, Species>(){

            public Species apply(BigfinDataRow bigfinDataRow) {
                return bigfinDataRow.getSpeciesOrSpeciesBatch().getSpecies();
            }
        });
        return rowsBySpecies;
    }

    public Multimap<SpeciesBatch, BigfinDataRow> getSpeciesBatchRowsBySpeciesBatch() {
        ImmutableListMultimap rowsBySpeciesBatch = Multimaps.index(this.speciesBatchRows, (Function)new Function<BigfinDataRow, SpeciesBatch>(){

            public SpeciesBatch apply(BigfinDataRow input) {
                return input.getSpeciesOrSpeciesBatch().getBatch();
            }
        });
        return rowsBySpeciesBatch;
    }

    public boolean isStationFound(BigfinDataRow bean) {
        String station = bean.getStation();
        Date date = bean.getDate();
        boolean result = station != null && station.equals(this.operation.getStationNumber()) && date != null && DateUtils.isSameDay((Date)date, (Date)this.operation.getGearShootingStartDate());
        return result;
    }

    public SpeciesProtocol getSpeciesProtocol(Species species) {
        String code = species.getSurveyCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            code = species.getReferenceTaxonId().toString();
        }
        SpeciesProtocol speciesProtocol = this.speciesProtocolBySurveyCode.get(code);
        return speciesProtocol;
    }

    public boolean checkRow(BigfinDataRow bigfinDataRow) {
        boolean stationFound = this.isStationFound(bigfinDataRow);
        boolean canBeAdd = false;
        if (stationFound) {
            String recordId = bigfinDataRow.getRecordId();
            SpeciesOrSpeciesBatch speciesOrspeciesBatch = bigfinDataRow.getSpeciesOrSpeciesBatch();
            if (speciesOrspeciesBatch.isSpecies()) {
                boolean speciesProtocoleIsSafe;
                this.checkSizeIsDefined(bigfinDataRow);
                Species species = speciesOrspeciesBatch.getSpecies();
                boolean speciesIsKnown = this.checkSpeciesIsKnown(recordId, species);
                if (speciesIsKnown && (speciesProtocoleIsSafe = this.checkSpeciesProtocol(recordId, species))) {
                    canBeAdd = true;
                }
            } else {
                boolean speciesProtocoleIsSafe;
                SpeciesBatch speciesBatch = speciesOrspeciesBatch.getBatch();
                boolean speciesBatchIsLeaf = this.checkSpeciesBatchIsLeaf(recordId, speciesBatch);
                if (speciesBatchIsLeaf && (speciesProtocoleIsSafe = this.checkSpeciesProtocol(recordId, speciesBatch.getSpecies()))) {
                    canBeAdd = true;
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Station is not matching for record: " + bigfinDataRow.getRecordId()));
        }
        return canBeAdd;
    }

    public boolean checkSpeciesBatchIsLeaf(String recordId, SpeciesBatch batch) {
        boolean speciesBatchIsLeaf = batch.isChildBatchsEmpty();
        if (!speciesBatchIsLeaf) {
            String warning = I18n.t((String)"tutti.service.bigfinImport.warning.speciesBatch.tooCategorized", (Object[])new Object[]{recordId, batch.getId()});
            if (log.isWarnEnabled()) {
                log.warn((Object)warning);
            }
            this.bigfinImportResult.addWarning(warning);
        }
        return speciesBatchIsLeaf;
    }

    public void checkSizeIsDefined(BigfinDataRow bigfinDataRow) {
        Preconditions.checkArgument((boolean)bigfinDataRow.getSpeciesOrSpeciesBatch().isSpecies());
        if (bigfinDataRow.getSize() == null) {
            String error = I18n.t((String)"tutti.service.bigfinImport.error.szClass.unknwon", (Object[])new Object[]{bigfinDataRow.getRecordId()});
            if (log.isErrorEnabled()) {
                log.error((Object)error);
            }
            this.bigfinImportResult.addError(error);
        }
    }

    public boolean checkSpeciesIsKnown(String recordId, Species species) {
        boolean speciesIsKnown = true;
        if (species.getId() == null) {
            if (this.speciesNotRecognized.add(species)) {
                String error = I18n.t((String)"tutti.service.bigfinImport.error.species.not.found", (Object[])new Object[]{recordId, species.getExternalCode()});
                if (log.isErrorEnabled()) {
                    log.error((Object)error);
                }
                this.bigfinImportResult.addError(error);
            }
            speciesIsKnown = false;
        }
        return speciesIsKnown;
    }

    public boolean checkSpeciesProtocol(String recordId, Species species) {
        boolean speciesProtocoleIsSafe = true;
        String speciesLabel = this.getSpeciesLabel(species);
        SpeciesProtocol speciesProtocol = this.getSpeciesProtocol(species);
        if (speciesProtocol == null) {
            speciesProtocoleIsSafe = false;
            if (this.speciesNotInProtocol.add(species)) {
                String error = I18n.t((String)"tutti.service.bigfinImport.warning.species.notInProtocol", (Object[])new Object[]{recordId, speciesLabel});
                if (log.isWarnEnabled()) {
                    log.warn((Object)error);
                }
                this.bigfinImportResult.addWarning(error);
            }
        } else if (speciesProtocol.getLengthStepPmfmId() == null) {
            speciesProtocoleIsSafe = false;
            if (this.speciesInProtocolButWithoutLengthStepPmfmId.add(species)) {
                String error = I18n.t((String)"tutti.service.bigfinImport.error.species.without.lengthstep", (Object[])new Object[]{recordId, speciesLabel});
                if (log.isErrorEnabled()) {
                    log.error((Object)error);
                }
                this.bigfinImportResult.addError(error);
            }
        }
        return speciesProtocoleIsSafe;
    }

    public BigfinImportResult getResult() {
        return this.bigfinImportResult;
    }

    protected String getSpeciesLabel(Species species) {
        String speciesLabel = species.getSurveyCode();
        if (StringUtils.isBlank((CharSequence)speciesLabel)) {
            speciesLabel = species.getRefTaxCode();
        }
        return speciesLabel;
    }

    public Species getSpeciesWithSurveyCode(Species species) {
        String refTaxCode = species.getRefTaxCode();
        Species speciesWithSurveyCode = this.speciesBySurveyCode.get(refTaxCode);
        return speciesWithSurveyCode;
    }
}

