/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.editor.number;

import com.google.common.base.Predicate;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.editor.number.NumberEditor2Config;

public class NumberEditor2Model
extends AbstractSerializableBean
implements ModelToBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_TEXT_VALUE = "textValue";
    public static final String PROPERTY_NUMBER_VALUE = "numberValue";
    public static final String PROPERTY_NUMBER_PATTERN = "numberPattern";
    private final NumberEditor2Config config;
    protected Serializable bean;
    protected String textValue;
    protected Number numberValue;
    protected String numberPattern;
    protected boolean textValueIsAdjusting;
    protected boolean numberValueIsAdjusting;

    public NumberEditor2Model(NumberEditor2Config config) {
        this.config = config;
    }

    NumberEditor2Config getConfig() {
        return this.config;
    }

    @Override
    public Serializable getBean() {
        return this.bean;
    }

    public void setBean(Serializable bean) {
        this.bean = bean;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        String oldValue = this.getNumberPattern();
        this.numberPattern = numberPattern;
        this.firePropertyChange(PROPERTY_NUMBER_PATTERN, oldValue, numberPattern);
    }

    public Number getNumberValue() {
        return this.numberValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumberValue(Number numberValue) {
        if (!this.numberValueIsAdjusting) {
            this.numberValueIsAdjusting = true;
            try {
                Number oldValue = this.getNumberValue();
                this.numberValue = numberValue;
                this.firePropertyChange(PROPERTY_NUMBER_VALUE, oldValue, numberValue);
            }
            finally {
                this.numberValueIsAdjusting = false;
            }
        }
    }

    public String getTextValue() {
        return this.textValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextValue(String textValue) {
        if (!this.textValueIsAdjusting) {
            this.textValueIsAdjusting = true;
            try {
                String oldValue = this.getTextValue();
                this.textValue = textValue;
                this.firePropertyChange(PROPERTY_TEXT_VALUE, oldValue, textValue);
                this.firePropertyChange("canUseDot", null, this.isCanUseDot());
                this.firePropertyChange("canUseSign", null, this.isCanUseSign());
                this.firePropertyChange("canUseZero", null, this.isCanUseZero());
                this.firePropertyChange("canClearAll", null, this.isCanClearAll());
            }
            finally {
                this.textValueIsAdjusting = false;
            }
        }
    }

    public boolean isCanUseDot() {
        Boolean useDecimal = this.config.getUseDecimal();
        return useDecimal != null && useDecimal != false && !this.textValue.contains(".");
    }

    public boolean isCanUseSign() {
        return this.config.isUseSign() && StringUtils.isNotBlank((CharSequence)this.textValue);
    }

    public boolean isCanUseZero() {
        return StringUtils.isNotBlank((CharSequence)this.textValue) && "0".equals(this.textValue);
    }

    public boolean isCanClearAll() {
        return StringUtils.isNotBlank((CharSequence)this.textValue);
    }

    public boolean isTextValueIsAdjusting() {
        return this.textValueIsAdjusting;
    }

    public boolean isNumberValueIsAdjusting() {
        return this.numberValueIsAdjusting;
    }

    protected Predicate<NumberEditor2Model> canUpdateBeanNumberValuePredicate() {
        return new Predicate<NumberEditor2Model>(){

            public boolean apply(NumberEditor2Model input) {
                return true;
            }
        };
    }
}

