/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class Ternary
extends SpelNodeImpl {
    public Ternary(int pos, SpelNodeImpl ... args) {
        super(pos, args);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Boolean value = this.children[0].getValue(state, Boolean.class);
        if (value == null) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
        TypedValue result = null;
        result = value != false ? this.children[1].getValueInternal(state) : this.children[2].getValueInternal(state);
        this.computeExitTypeDescriptor();
        return result;
    }

    @Override
    public String toStringAST() {
        return this.getChild(0).toStringAST() + " ? " + this.getChild(1).toStringAST() + " : " + this.getChild(2).toStringAST();
    }

    private void computeExitTypeDescriptor() {
        if (this.exitTypeDescriptor == null && this.children[1].getExitDescriptor() != null && this.children[2].getExitDescriptor() != null) {
            String leftDescriptor = this.children[1].exitTypeDescriptor;
            String rightDescriptor = this.children[2].exitTypeDescriptor;
            this.exitTypeDescriptor = leftDescriptor.equals(rightDescriptor) ? leftDescriptor : (leftDescriptor.equals("Ljava/lang/Object") && !CodeFlow.isPrimitive(rightDescriptor) ? rightDescriptor : (rightDescriptor.equals("Ljava/lang/Object") && !CodeFlow.isPrimitive(leftDescriptor) ? leftDescriptor : "Ljava/lang/Object"));
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl condition = this.children[0];
        SpelNodeImpl left = this.children[1];
        SpelNodeImpl right = this.children[2];
        if (!(condition.isCompilable() && left.isCompilable() && right.isCompilable())) {
            return false;
        }
        return CodeFlow.isBooleanCompatible(condition.exitTypeDescriptor) && left.getExitDescriptor() != null && right.getExitDescriptor() != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        this.computeExitTypeDescriptor();
        codeflow.enterCompilationScope();
        this.children[0].generateCode(mv, codeflow);
        codeflow.exitCompilationScope();
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        mv.visitJumpInsn(153, elseTarget);
        codeflow.enterCompilationScope();
        this.children[1].generateCode(mv, codeflow);
        if (!CodeFlow.isPrimitive(this.getExitDescriptor())) {
            CodeFlow.insertBoxIfNecessary(mv, codeflow.lastDescriptor().charAt(0));
        }
        codeflow.exitCompilationScope();
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        codeflow.enterCompilationScope();
        this.children[2].generateCode(mv, codeflow);
        if (!CodeFlow.isPrimitive(this.getExitDescriptor())) {
            CodeFlow.insertBoxIfNecessary(mv, codeflow.lastDescriptor().charAt(0));
        }
        codeflow.exitCompilationScope();
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor(this.getExitDescriptor());
    }
}

