/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.type;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.nuiton.i18n.I18n;

public enum WeightUnit {
    G(I18n.n((String)"application.common.unit.g", (Object[])new Object[0]), I18n.n((String)"application.common.unit.short.g", (Object[])new Object[0]), 1, "\\d{0,8}(\\.\\d{0,1})?"){

        @Override
        public Float fromEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() * 1000.0f);
        }

        @Override
        public Float toEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() / 1000.0f);
        }
    }
    ,
    KG(I18n.n((String)"application.common.unit.kg", (Object[])new Object[0]), I18n.n((String)"application.common.unit.short.kg", (Object[])new Object[0]), 4, "\\d{0,6}(\\.\\d{0,4})?"){

        @Override
        public Float fromEntity(Float weight) {
            return weight;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight;
        }
    };

    private final String i18nShortKey;
    private final String i18nKey;
    private final int numberDigits;
    private final String numberEditorPattern;
    private final DecimalFormat decimalFormat;

    private WeightUnit(String i18nKey, String i18nShortKey, int numberDigits, String numberEditorPattern) {
        this.i18nKey = i18nKey;
        this.i18nShortKey = i18nShortKey;
        this.numberDigits = numberDigits;
        this.numberEditorPattern = numberEditorPattern;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setDecimalFormatSymbols(symbols);
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumFractionDigits(1);
        this.decimalFormat.setMaximumFractionDigits(numberDigits);
    }

    public String getLabel() {
        return I18n.t((String)this.i18nKey, (Object[])new Object[0]);
    }

    public String getShortLabel() {
        return I18n.t((String)this.i18nShortKey, (Object[])new Object[0]);
    }

    public int getNumberDigits() {
        return this.numberDigits;
    }

    public String getNumberEditorPattern() {
        return this.numberEditorPattern;
    }

    public String renderWeight(Float weight) {
        String textValue = weight == null ? "" : this.decimalFormat.format(weight);
        return textValue;
    }

    public abstract Float fromEntity(Float var1);

    public abstract Float toEntity(Float var1);

    public String decorateLabel(String label) {
        return String.format("%s (%s)", label, this.getShortLabel());
    }

    public String decorateTip(String tip) {
        String unit = I18n.t((String)"application.common.unit", (Object[])new Object[0]);
        return String.format("%s (%s %s)", tip, unit, this.getLabel());
    }
}

