/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportTemporaryPersonExampleAction
extends AbstractTuttiAction<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportTemporaryPersonExampleAction.class);
    private File file;

    public ExportTemporaryPersonExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile("exportPersonExample", "csv", I18n.t((String)"tutti.manageTemporaryReferential.title.choose.exportTemporaryPersonExampleFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.export", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export example persons temporary referential to file: " + this.file));
        }
        ReferentialExportService service = this.getContext().getTuttiReferentialExportService();
        service.exportTemporaryPersonExample(this.file);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.export.success", (Object[])new Object[]{this.file}));
    }
}

