/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.category;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId2;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditSampleCategoryModelUIModel
extends AbstractTuttiTableUIModel<SampleCategoryModel, EditSampleCategoryModelRowModel, EditSampleCategoryModelUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CARACTERISTIC_LIST = "caracteristicList";
    public static final String PROPERTY_REMOVE_ENTRY_ENABLED = "removeEntryEnabled";
    public static final String PROPERTY_MOVE_UP_ENTRY_ENABLED = "moveUpEntryEnabled";
    public static final String PROPERTY_MOVE_DOWN_ENTRY_ENABLED = "moveDownEntryEnabled";
    protected final SampleCategoryModelEntry firstCategory;
    protected final List<Caracteristic> caracteristicList;
    protected static Binder<SampleCategoryModel, EditSampleCategoryModelUIModel> fromBeanBinder = BinderFactory.newBinder(SampleCategoryModel.class, EditSampleCategoryModelUIModel.class);
    protected static Binder<EditSampleCategoryModelUIModel, SampleCategoryModel> toBeanBinder = BinderFactory.newBinder(EditSampleCategoryModelUIModel.class, SampleCategoryModel.class);
    private boolean removeEntryEnabled;
    private boolean moveUpEntryEnabled;
    private boolean moveDownEntryEnabled;

    public EditSampleCategoryModelUIModel(List<SampleCategoryModelEntry> category, List<Caracteristic> caracteristicList) {
        super(SampleCategoryModel.class, fromBeanBinder, toBeanBinder);
        Preconditions.checkNotNull(caracteristicList, (Object)"need a not null caracteristicList");
        Preconditions.checkNotNull(category, (Object)"need a not null category list");
        Preconditions.checkArgument((!category.isEmpty() ? 1 : 0) != 0, (Object)"need at least one first category (sorted-unsorted)");
        this.caracteristicList = caracteristicList;
        this.firstCategory = category.get(0);
        Preconditions.checkArgument((boolean)PmfmId2.SORTED_UNSORTED.getValue().equals(this.firstCategory.getCategoryId()), (Object)("first category must be sorted-unsorted caracteristic but was: " + this.firstCategory.getCategoryId()));
        ArrayList rows = Lists.newArrayList();
        for (SampleCategoryModelEntry sampleCategoryModelEntry : category) {
            caracteristicList.remove(sampleCategoryModelEntry.getCaracteristic());
            if (this.firstCategory.equals(sampleCategoryModelEntry)) continue;
            EditSampleCategoryModelRowModel row = new EditSampleCategoryModelRowModel();
            row.setCaracteristic(sampleCategoryModelEntry.getCaracteristic());
            row.setLabel(sampleCategoryModelEntry.getLabel());
            row.setValid(true);
            rows.add(row);
        }
        this.setRows(rows);
    }

    @Override
    protected SampleCategoryModel newEntity() {
        ArrayList entries = Lists.newArrayList((Object[])new SampleCategoryModelEntry[]{this.firstCategory});
        int order = 1;
        for (EditSampleCategoryModelRowModel row : this.getRows()) {
            SampleCategoryModelEntry entry = new SampleCategoryModelEntry();
            entry.setCategoryId(row.getCategoryId());
            entry.setLabel(row.getLabel());
            entry.setOrder(order++);
            entries.add(entry);
        }
        return new SampleCategoryModel((List)entries);
    }

    public List<Caracteristic> getCaracteristicList() {
        return this.caracteristicList;
    }

    public boolean isRemoveEntryEnabled() {
        return this.removeEntryEnabled;
    }

    public void setRemoveEntryEnabled(boolean removeEntryEnabled) {
        boolean oldValue = this.isRemoveEntryEnabled();
        this.removeEntryEnabled = removeEntryEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_ENTRY_ENABLED, oldValue, removeEntryEnabled);
    }

    public boolean isMoveUpEntryEnabled() {
        return this.moveUpEntryEnabled;
    }

    public void setMoveUpEntryEnabled(boolean moveUpEntryEnabled) {
        boolean oldValue = this.isMoveUpEntryEnabled();
        this.moveUpEntryEnabled = moveUpEntryEnabled;
        this.firePropertyChange(PROPERTY_MOVE_UP_ENTRY_ENABLED, oldValue, moveUpEntryEnabled);
    }

    public boolean isMoveDownEntryEnabled() {
        return this.moveDownEntryEnabled;
    }

    public void setMoveDownEntryEnabled(boolean moveDownEntryEnabled) {
        boolean oldValue = this.isMoveDownEntryEnabled();
        this.moveDownEntryEnabled = moveDownEntryEnabled;
        this.firePropertyChange(PROPERTY_MOVE_DOWN_ENTRY_ENABLED, oldValue, moveDownEntryEnabled);
    }

    public void addCaracteristic(Caracteristic caracteristic) {
        this.caracteristicList.add(caracteristic);
        this.firePropertyChange(PROPERTY_CARACTERISTIC_LIST, null, this.caracteristicList);
    }

    public void removeCaracteristic(Caracteristic caracteristic) {
        this.caracteristicList.remove(caracteristic);
        this.firePropertyChange(PROPERTY_CARACTERISTIC_LIST, null, this.caracteristicList);
    }
}

