/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.core._CoreAPI;
import freemarker.core._ErrorDescriptionBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

public class TemplateException
extends Exception {
    private static final String THE_FAILING_INSTRUCTION = "The failing instruction";
    private static final boolean BEFORE_1_4 = TemplateException.before14();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private transient _ErrorDescriptionBuilder descriptionBuilder;
    private final Throwable causeException;
    private final transient Environment env;
    private transient TemplateElement[] ftlInstructionStackSnapshot;
    private String renderedFtlInstructionStackSnapshot;
    private String renderedFtlInstructionStackSnapshotTop;
    private String description;
    private transient String messageWithoutStackTop;
    private transient String message;
    private transient Object lock = new Object();
    private transient ThreadLocal messageWasAlreadyPrintedForThisTrace;
    static /* synthetic */ Class class$java$lang$Exception;

    private static boolean before14() {
        Class ec = class$java$lang$Exception == null ? (class$java$lang$Exception = TemplateException.class$("java.lang.Exception")) : class$java$lang$Exception;
        try {
            ec.getMethod("getCause", new Class[0]);
        }
        catch (Throwable e) {
            return true;
        }
        return false;
    }

    public TemplateException(Environment env) {
        this((String)null, null, env);
    }

    public TemplateException(String description, Environment env) {
        this(description, null, env);
    }

    public TemplateException(Exception cause, Environment env) {
        this((String)null, cause, env);
    }

    public TemplateException(Throwable cause, Environment env) {
        this((String)null, cause, env);
    }

    public TemplateException(String description, Exception cause, Environment env) {
        this(description, (Throwable)cause, env, null);
    }

    public TemplateException(String description, Throwable cause, Environment env) {
        this(description, cause, env, null);
    }

    protected TemplateException(Throwable cause, Environment env, _ErrorDescriptionBuilder descriptionBuilder, boolean preventAmbiguity) {
        this(null, cause, env, descriptionBuilder);
    }

    private TemplateException(String renderedDescription, Throwable cause, Environment env, _ErrorDescriptionBuilder descriptionBuilder) {
        if (env == null) {
            env = Environment.getCurrentEnvironment();
        }
        this.env = env;
        this.causeException = cause;
        this.descriptionBuilder = descriptionBuilder;
        this.description = renderedDescription;
        if (env != null) {
            this.ftlInstructionStackSnapshot = _CoreAPI.getInstructionStackSnapshot(env);
        }
    }

    private void renderMessages() {
        String description = this.getDescription();
        this.messageWithoutStackTop = description != null && description.length() != 0 ? description : (this.getCause() != null ? "No error description was specified for this error; low-level message: " + this.getCause().getClass().getName() + ": " + this.getCause().getMessage() : "[No error description was available.]");
        String stackTop = this.getFTLInstructionStackTop();
        if (stackTop != null) {
            this.message = this.messageWithoutStackTop + "\n\n" + THE_FAILING_INSTRUCTION + stackTop;
            this.messageWithoutStackTop = this.message.substring(0, this.messageWithoutStackTop.length());
        } else {
            this.message = this.messageWithoutStackTop;
        }
    }

    public Exception getCauseException() {
        return this.causeException instanceof Exception ? (Exception)this.causeException : new Exception("Wrapped to Exception: " + this.causeException);
    }

    public Throwable getCause() {
        return this.causeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFTLInstructionStack() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ftlInstructionStackSnapshot != null || this.renderedFtlInstructionStackSnapshot != null) {
                if (this.renderedFtlInstructionStackSnapshot == null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    _CoreAPI.outputInstructionStack(this.ftlInstructionStackSnapshot, pw);
                    pw.close();
                    if (this.renderedFtlInstructionStackSnapshot == null) {
                        this.renderedFtlInstructionStackSnapshot = sw.toString();
                        this.deleteFTLInstructionStackSnapshotIfNotNeeded();
                    }
                }
                return this.renderedFtlInstructionStackSnapshot;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFTLInstructionStackTop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ftlInstructionStackSnapshot != null || this.renderedFtlInstructionStackSnapshotTop != null) {
                if (this.renderedFtlInstructionStackSnapshotTop == null) {
                    int stackSize = this.ftlInstructionStackSnapshot.length;
                    String s = stackSize == 0 ? "" : (stackSize > 1 ? " (print stack trace for " + (stackSize - 1) + " more)" : "") + ":\n==> " + _CoreAPI.instructionStackItemToString(this.ftlInstructionStackSnapshot[0]);
                    if (this.renderedFtlInstructionStackSnapshotTop == null) {
                        this.renderedFtlInstructionStackSnapshotTop = s;
                        this.deleteFTLInstructionStackSnapshotIfNotNeeded();
                    }
                }
                return this.renderedFtlInstructionStackSnapshotTop.length() != 0 ? this.renderedFtlInstructionStackSnapshotTop : null;
            }
            return null;
        }
    }

    private void deleteFTLInstructionStackSnapshotIfNotNeeded() {
        if (this.renderedFtlInstructionStackSnapshot != null && this.renderedFtlInstructionStackSnapshotTop != null) {
            this.ftlInstructionStackSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDescription() {
        Object object = this.lock;
        synchronized (object) {
            if (this.description == null && this.descriptionBuilder != null) {
                this.description = this.descriptionBuilder.toString(this.getFailingInstruction());
                this.descriptionBuilder = null;
            }
            return this.description;
        }
    }

    private TemplateElement getFailingInstruction() {
        if (this.ftlInstructionStackSnapshot != null && this.ftlInstructionStackSnapshot.length > 0) {
            return this.ftlInstructionStackSnapshot[0];
        }
        return null;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(out, true, true, true);
    }

    public void printStackTrace(PrintWriter out) {
        this.printStackTrace(out, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out, boolean heading, boolean ftlStackTrace, boolean javaStackTrace) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            this.printStackTrace(new PrintWriterStackTraceWriter(out), heading, ftlStackTrace, javaStackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out, boolean heading, boolean ftlStackTrace, boolean javaStackTrace) {
        PrintStream printStream = out;
        synchronized (printStream) {
            this.printStackTrace(new PrintStreamStackTraceWriter(out), heading, ftlStackTrace, javaStackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(StackTraceWriter out, boolean heading, boolean ftlStackTrace, boolean javaStackTrace) {
        StackTraceWriter stackTraceWriter = out;
        synchronized (stackTraceWriter) {
            Object stackTrace;
            if (heading) {
                out.println("FreeMarker template error:");
            }
            if (ftlStackTrace) {
                stackTrace = this.getFTLInstructionStack();
                if (stackTrace != null) {
                    out.println(this.getMessageWithoutStackTop());
                    out.println();
                    out.print(THE_FAILING_INSTRUCTION);
                    out.println(" (FTL stack trace):");
                    out.print(stackTrace);
                } else {
                    ftlStackTrace = false;
                    javaStackTrace = true;
                }
            }
            if (javaStackTrace) {
                if (ftlStackTrace) {
                    out.println();
                    out.println("Java stack trace (for programmers):");
                    out.println("----------");
                    stackTrace = this.lock;
                    synchronized (stackTrace) {
                        if (this.messageWasAlreadyPrintedForThisTrace == null) {
                            this.messageWasAlreadyPrintedForThisTrace = new ThreadLocal();
                        }
                        this.messageWasAlreadyPrintedForThisTrace.set(Boolean.TRUE);
                    }
                    try {
                        out.printStandardStackTrace(this);
                    }
                    finally {
                        this.messageWasAlreadyPrintedForThisTrace.set(Boolean.FALSE);
                    }
                }
                out.printStandardStackTrace(this);
                if (BEFORE_1_4 && this.causeException != null) {
                    out.println("Underlying cause: ");
                    out.printStandardStackTrace(this.causeException);
                }
                try {
                    Method m = this.causeException.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
                    Throwable rootCause = (Throwable)m.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
                    if (rootCause != null) {
                        Throwable j14Cause = null;
                        if (!BEFORE_1_4) {
                            m = this.causeException.getClass().getMethod("getCause", EMPTY_CLASS_ARRAY);
                            j14Cause = (Throwable)m.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
                        }
                        if (j14Cause == null) {
                            out.println("ServletException root cause: ");
                            out.printStandardStackTrace(rootCause);
                        }
                    }
                }
                catch (Throwable exc) {
                    // empty catch block
                }
            }
        }
    }

    public void printStandardStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    public void printStandardStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        if (this.messageWasAlreadyPrintedForThisTrace != null && this.messageWasAlreadyPrintedForThisTrace.get() == Boolean.TRUE) {
            return "[... Exception message was already printed; see it above ...]";
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.message == null) {
                this.renderMessages();
            }
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageWithoutStackTop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.messageWithoutStackTop == null) {
                this.renderMessages();
            }
            return this.messageWithoutStackTop;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        this.getFTLInstructionStack();
        this.getFTLInstructionStackTop();
        this.getDescription();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.lock = new Object();
        in.defaultReadObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PrintWriterStackTraceWriter
    implements StackTraceWriter {
        private final PrintWriter out;

        PrintWriterStackTraceWriter(PrintWriter out) {
            this.out = out;
        }

        public void print(Object obj) {
            this.out.print(obj);
        }

        public void println(Object obj) {
            this.out.println(obj);
        }

        public void println() {
            this.out.println();
        }

        public void printStandardStackTrace(Throwable exception) {
            if (exception instanceof TemplateException) {
                ((TemplateException)exception).printStandardStackTrace(this.out);
            } else {
                exception.printStackTrace(this.out);
            }
        }
    }

    private static class PrintStreamStackTraceWriter
    implements StackTraceWriter {
        private final PrintStream out;

        PrintStreamStackTraceWriter(PrintStream out) {
            this.out = out;
        }

        public void print(Object obj) {
            this.out.print(obj);
        }

        public void println(Object obj) {
            this.out.println(obj);
        }

        public void println() {
            this.out.println();
        }

        public void printStandardStackTrace(Throwable exception) {
            if (exception instanceof TemplateException) {
                ((TemplateException)exception).printStandardStackTrace(this.out);
            } else {
                exception.printStackTrace(this.out);
            }
        }
    }

    private static interface StackTraceWriter {
        public void print(Object var1);

        public void println(Object var1);

        public void println();

        public void printStandardStackTrace(Throwable var1);
    }
}

