/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class RemoteIdWriteInterceptor
extends SynchroInterceptorBase {
    private Set<String> dataTableIncludes = SynchroConfiguration.getInstance().getImportDataTablesIncludes();

    public RemoteIdWriteInterceptor() {
    }

    public RemoteIdWriteInterceptor(SynchroInterceptor next) {
        super(next);
    }

    @Override
    public boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
        if (CollectionUtils.isEmpty(this.dataTableIncludes)) {
            return false;
        }
        boolean isDataTable = this.dataTableIncludes.contains(table.getName());
        return isDataTable;
    }

    @Override
    protected void doJoinLoad(SynchroTableMetadata table, SynchroJoinMetadata join) {
        if (join.needRemoteIdInterceptor()) {
            String pkTableName = join.getTargetTable().getName().toLowerCase();
            String fkColumnName = join.getSourceColumn().getName().toLowerCase();
            int fkColumnIndex = join.getSourceTable().getColumnIndex(fkColumnName);
            WriteInterceptor remoteIdInterceptor = new WriteInterceptor(pkTableName, fkColumnName, fkColumnIndex, join.getSourceColumn().isNullable());
            table.getInterceptors().add(remoteIdInterceptor);
        }
    }

    private class WriteInterceptor
    extends SynchroInterceptorBase {
        private final String tableName;
        private final String columnName;
        private final int columnIndex;
        private final boolean isNullable;
        private final String selectIdFromRemoteIdQuery;
        private PreparedStatement selectIdFromRemoteIdStatement = null;

        public WriteInterceptor(String tableName, String columnName, int columnIndex, boolean isNullable) {
            Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
            this.tableName = tableName;
            this.columnName = columnName;
            this.columnIndex = columnIndex;
            this.isNullable = isNullable;
            this.selectIdFromRemoteIdQuery = this.initSelectIdFromRemoteIdQuery(tableName);
        }

        @Override
        public SynchroInterceptorBase clone() {
            return new WriteInterceptor(this.tableName, this.columnName, this.columnIndex, this.isNullable);
        }

        @Override
        public boolean enableOnWrite() {
            return true;
        }

        @Override
        protected void doOnWrite(Object[] data, String pkStr, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException {
            Integer remoteId = (Integer)data[this.columnIndex];
            if (remoteId == null) {
                return;
            }
            Integer localId = this.getIdFromRemoteId(dao.getConnection(), remoteId);
            if (localId == null) {
                if (!this.isNullable) {
                    throw new SynchroTechnicalException(String.format("Could not retrieve ID corresponding to REMOTE_ID=%s, for table %s", remoteId, this.tableName));
                }
                buffer.addMissingColumnUpdate(this.columnName, pkStr, remoteId);
                data[this.columnIndex] = null;
            } else {
                data[this.columnIndex] = localId;
            }
        }

        protected Integer getIdFromRemoteId(Connection connection, Integer remoteId) throws SQLException {
            if (this.selectIdFromRemoteIdStatement == null) {
                this.selectIdFromRemoteIdStatement = connection.prepareStatement(this.selectIdFromRemoteIdQuery);
            }
            this.selectIdFromRemoteIdStatement.setInt(1, remoteId);
            ResultSet resultSet = this.selectIdFromRemoteIdStatement.executeQuery();
            if (!resultSet.next()) {
                return null;
            }
            Integer result = resultSet.getInt(1);
            return result;
        }

        @Override
        protected void doClose() throws IOException {
            super.doClose();
            DaoUtils.closeSilently(this.selectIdFromRemoteIdStatement);
            this.selectIdFromRemoteIdStatement = null;
        }

        protected String initSelectIdFromRemoteIdQuery(String tableName) {
            return String.format("SELECT %s FROM %s where %s=?", "id", tableName, "remote_id");
        }
    }
}

