package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public abstract class AbstractReplaceTemporaryUI<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>> extends JDialog implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REPLACE_BUTTON_ENABLED = "replaceButton.enabled";
    public static final String BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM = "sourceListComboBox.selectedItem";
    public static final String BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM = "targetListComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWz28bRRR+NnESO25DExoKLVJxK1GEtA60oFRG0KbIIpEDUeyiCh/K2DtJphrvLrPPjSMriD+BOxzgzgWJGyfEgTMHLoh/ASEOXFHf7K53ves1/kGJlJX15n3fe/PNe2/m2z8g5yp4+RHr9QzVtVB0uLF798GDD1uPeBvf425bCQdtBf5fJgvZJqyYod1FuNasaXg5gJfv2R3Htrg1hK7UoODiqeTuMeeI8FIc0Xbdcj1crvScrhqwhkmlsX7915/ZL8zPv8kC9BzKrkhbuToJFe1koQZZYSKsUaTHrCyZdURpKGEdUb7ntO2eZK77AevwT+EzWKrBosMUkSGUpt+yx+Hhew7CRcUdydq8wQmhmDq9v9Owyb5/qAxxqHiHKwO7iMLoCsM9oVyMtm0hURuKH3IdXTBpBCzG3ZaLirXxYITVcbygiwi5jm1yiXD/aYfY07xRnPxjJoXJaO8Ir8VOIVwIwtX196OBcShTZC3JES7F0D6moZe0Xz50X3XtrmrzmnCxxlp6i2v60HoBYtczat+1ELIWQejMWva23UN4MyUcN4XOt8WZZWzTpyokcqVzGODixKvI1BHHMBdtfj4RO3IZ5ngx7lW8vlvnVGZamU2EjdiOwpU4Zvn67j6zuNxMKuBZE/xtZrW53KYCoEOH9Zi/b9WepRBwLiiEaO2VwEHB5Zhy1MZG1MZRn2WakFNdMtPJNkc7/4CW/J6/lOh5Teit/rOx/usPv39fHTR6gWJfTHUdmlPUgI6yHa5Q6NCrfpd3UcjyHnMqTci7XNKQ84bYlZTE6sEyJUfxLmi4oeHG+8w9Jorc0m8//rTxyS/PQLYKBWkzs8q0/w7k8ViRCrY0e867d7yMiifL9H2W/rMIC7qu6Cz6VA9eF9149YwaiBAnB9zVE3IBVZf3SJMrKZqEibXyP/+9Xv/uzkCXDOX5wlj3SJvcx7AoLCks7o3AYLqljrwVx+Vd046mWNpcA5pgG+ltEnR32fveHBEj488nJsMta7/b3l70rwqMm5nOBOYF6gupW7GqB9Jz/dHOP9MxeY/UfsOfh8k4B0Pj8FBwaRoRCcIK2rZsCKfhUbw1O4WBdFNA7uExTVGESr80B4XGls7SVEtOxyn0KvoNwc0d5B2Ey33v5jCoSOvBQt3j9Kp1OWiuU4TzbmyZYj8MR34wmW/38cYc+yvpSP+XQimXwaxFNTrS5yiqiGTuoooo5i6qIYp/KarENfdUiqrhcY4tKn/5PxdVlPm8RTWVQim3/CSR6JJd4pYemvQYvRDoI1zvgeSpEhTU5uRE6f4RtjVwQSj4hh39wIOl0FwUr29Zexbv2JZok46zEhudEBsv2FszM8XK9da4w9jnyiVQAjv+FOKPlkkHkAslLk+dv/+MSii8OLAmBN6akXasvjdnJYrJuzVNrcfx4yWOPSQnKUzX/KJkpzY5w/m3qYfZ1ZawTHp0vjPCndHfwkRGbf5Sf75KZ7hGDE8Awp358t8OAAA=";
    private static final Log log = LogFactory.getLog(AbstractReplaceTemporaryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected AbstractReplaceTemporaryUIModel<E> model;
    protected JButton replaceButton;
    protected AbstractReplaceTemporaryUI<E, M> replaceTemporaryUITop = this;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedSource",  editorName = "sourceListComboBox")
    protected BeanFilterableComboBox<E> sourceListComboBox;
    protected JLabel sourceListLabel;
    protected Table table;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedTarget",  editorName = "targetListComboBox")
    protected BeanFilterableComboBox<E> targetListComboBox;
    protected JLabel targetListLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<AbstractReplaceTemporaryUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractReplaceTemporaryUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI() {
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setValid(false); dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public AbstractReplaceTemporaryUIModel<E> getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<E> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public JLabel getSourceListLabel() {
        return sourceListLabel;
    }

    public Table getTable() {
        return table;
    }

    public BeanFilterableComboBox<E> getTargetListComboBox() {
        return targetListComboBox;
    }

    public JLabel getTargetListLabel() {
        return targetListLabel;
    }

    public SwingValidator<AbstractReplaceTemporaryUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(sourceListLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(sourceListComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add(targetListLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(targetListComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JSeparator0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.replaceTemporaryReferential.action.cancel"));
        cancelButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.replaceTemporaryReferential.action.cancel.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.setText(t("tutti.replaceTemporaryReferential.action.replace"));
        replaceButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.replace.tip"));
        replaceButton.putClientProperty("help", "tutti.replaceTemporaryPerson.action.replace.help");
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<E>(this));
        
        sourceListComboBox.setName("sourceListComboBox");
        sourceListComboBox.setProperty("selectedSource");
        sourceListComboBox.setShowReset(true);
        sourceListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
        sourceListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.sourceList"));
    }

    protected void createSourceListLabel() {
        $objectMap.put("sourceListLabel", sourceListLabel = new JLabel());
        
        sourceListLabel.setName("sourceListLabel");
        sourceListLabel.setText(t("tutti.replaceTemporaryReferential.field.sourceList"));
        sourceListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.sourceList.tip"));
        sourceListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<E>(this));
        
        targetListComboBox.setName("targetListComboBox");
        targetListComboBox.setProperty("selectedTarget");
        targetListComboBox.setShowReset(true);
        targetListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
        targetListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.targetList"));
    }

    protected void createTargetListLabel() {
        $objectMap.put("targetListLabel", targetListLabel = new JLabel());
        
        targetListLabel.setName("targetListLabel");
        targetListLabel.setText(t("tutti.replaceTemporaryReferential.field.targetList"));
        targetListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.targetList.tip"));
        targetListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AbstractReplaceTemporaryUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        addChildrenToValidator();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(replaceButton);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        sourceListLabel.setLabelFor(sourceListComboBox);
        sourceListComboBox.setBean(getModel());
        targetListLabel.setLabelFor(targetListComboBox);
        targetListComboBox.setBean(getModel());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.cancel.mnemonic"),'Z'));
        replaceButton.setIcon(SwingUtil.createActionIcon("replace"));
        replaceButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.replace.mnemonic"),'Z'));
        // late initializer
        replaceTemporaryUITop.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createValidator();
        createTable();
        createSourceListLabel();
        createSourceListComboBox();
        createTargetListLabel();
        createTargetListComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        replaceTemporaryUITop.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSource", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sourceListComboBox.setSelectedItem(model.getSelectedSource());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSource", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTarget", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    targetListComboBox.setSelectedItem(model.getSelectedTarget());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTarget", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}