/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocation;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocationDao;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocationPK;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingAreaDao;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingAreaImpl;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.GearUseMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.VesselUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.operation.OperationImpl;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociation;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociationDao;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociationPK;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruiseDao;
import fr.ifremer.adagio.core.dao.data.vessel.VesselImpl;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.isActive;
import fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRole;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRoleId;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.service.referential.location.LocationService;
import fr.ifremer.tutti.persistence.dao.GearPhysicalFeaturesDaoTutti;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import fr.ifremer.tutti.persistence.service.util.VesselPersonFeaturesPersistenceHelper;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="fishingOperationPersistenceService")
public class FishingOperationPersistenceServiceImpl
extends AbstractPersistenceService
implements FishingOperationPersistenceService {
    private static final Log log = LogFactory.getLog(FishingOperationPersistenceServiceImpl.class);
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="batchPersistenceService")
    protected CatchBatchPersistenceService catchBatchService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="vesselPersonFeaturesPersistenceHelper")
    protected VesselPersonFeaturesPersistenceHelper vesselPersonFeaturesPersistenceHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="scientificCruiseDao")
    protected ScientificCruiseDao scientificCruiseDao;
    @Resource(name="gearPhysicalFeaturesDaoTutti")
    protected GearPhysicalFeaturesDaoTutti gearPhysicalFeaturesDao;
    @Resource(name="fishingArea2RegulationLocationDao")
    protected FishingArea2RegulationLocationDao fishingArea2RegulationLocationDao;
    @Resource(name="fishingOperationDao")
    protected FishingOperationDao fishingOperationDao;
    @Resource(name="fishingAreaDao")
    protected FishingAreaDao fishingAreaDao;
    @Resource(name="operationVesselAssociationDao")
    protected OperationVesselAssociationDao operationVesselAssociationDao;
    @Resource(name="locationService")
    protected LocationService locationService;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;
    protected static Float DEFAULT_EMPTY_LATITUDE = Float.valueOf(1.0E-4f);
    protected static Float DEFAULT_EMPTY_LONGITUDE = Float.valueOf(1.0E-4f);

    @Override
    public int getFishingOperationCount(String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId);
        Iterator<Object[]> list = this.queryList("allFishingOperationIds", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(cruiseId));
        int result = 0;
        while (list.hasNext()) {
            list.next();
            ++result;
        }
        return result;
    }

    @Override
    public List<String> getAllFishingOperationIds(String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId);
        Iterator<Object[]> list = this.queryList("allFishingOperationIds", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(cruiseId));
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Integer id = (Integer)list.next();
            result.add(id.toString());
        }
        return result;
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.data.FishingOperation> getAllFishingOperation(String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId);
        Iterator<Object[]> list = this.queryList("allFishingOperations", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(cruiseId), "pmfmIdStationNumber", IntegerType.INSTANCE, PmfmId.STATION_NUMBER.getValue(), "pmfmIdMultirigAggregation", IntegerType.INSTANCE, PmfmId.MULTIRIG_AGGREGATION.getValue());
        ArrayList result = Lists.newArrayList();
        int fishingOperationRankOrder = 0;
        while (list.hasNext()) {
            String multirigAggregation;
            Object[] source = list.next();
            ++fishingOperationRankOrder;
            fr.ifremer.tutti.persistence.entities.data.FishingOperation fishingOperation = FishingOperations.newFishingOperation();
            int colIndex = 0;
            fishingOperation.setId(source[colIndex++].toString());
            String name = (String)source[colIndex++];
            if (StringUtils.isNotBlank((CharSequence)name)) {
                fishingOperation.setFishingOperationNumber(Integer.valueOf(name));
            }
            fishingOperation.setSynchronizationStatus((String)source[colIndex++]);
            if (fishingOperation.getFishingOperationNumber() == null) {
                fishingOperation.setFishingOperationNumber(fishingOperationRankOrder);
            }
            Timestamp startDateTime = (Timestamp)source[colIndex++];
            fishingOperation.setGearShootingStartDate(this.convertDatabase2UI(startDateTime));
            String stationNumber = (String)source[colIndex++];
            if (stationNumber != null) {
                fishingOperation.setStationNumber(stationNumber);
            }
            if ((multirigAggregation = (String)source[colIndex]) != null) {
                fishingOperation.setMultirigAggregation(multirigAggregation);
            } else {
                log.warn((Object)MessageFormat.format("FishingOperation with id={0} has been load with a default multirigAggregation={1}, because no multirigAggregation were found in database.", fishingOperation.getId(), fishingOperation.getMultirigAggregation()));
                fishingOperation.setMultirigAggregation("1");
            }
            result.add(fishingOperation);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.FishingOperation getFishingOperation(String id) {
        String vesselCode;
        Integer localiteId;
        Integer subStrataId;
        VesselPosition startVesselPosition;
        Preconditions.checkNotNull((Object)id);
        Object[] source = this.queryUnique("fishingOperation", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(id), "locationLevelIdStrata", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue(), "locationLevelIdSubStrata", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue(), "locationLevelIdLocalite", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_LOCALITE.getValue());
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve fishingOperation with id=" + id);
        }
        fr.ifremer.tutti.persistence.entities.data.FishingOperation result = FishingOperations.newFishingOperation();
        result.setId(id);
        int colIndex = 0;
        String name = (String)source[colIndex++];
        if (StringUtils.isNotBlank((CharSequence)name)) {
            result.setFishingOperationNumber(Integer.valueOf(name));
        }
        result.setSynchronizationStatus((String)source[colIndex++]);
        Short rankOrder = (Short)source[colIndex++];
        if (result.getFishingOperationNumber() == null) {
            Integer fishingOperationRankOrder = (Integer)this.queryUniqueTyped("fishingOperationRankOrder", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(id));
            result.setFishingOperationNumber(fishingOperationRankOrder);
        }
        result.setGearShootingStartDate(this.convertDatabase2UI((Timestamp)source[colIndex++]));
        result.setGearShootingEndDate(this.convertDatabase2UI((Timestamp)source[colIndex++]));
        result.setRecorderPerson(Lists.newArrayList());
        Iterator<Object[]> vesselPersonFeaturesList = this.queryList("fishingOperationVesselPersonFeatures", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(id));
        while (vesselPersonFeaturesList.hasNext()) {
            Object[] vesselPersonFeatures = vesselPersonFeaturesList.next();
            Integer personId = (Integer)vesselPersonFeatures[0];
            Person person = this.referentialService.getPerson(personId);
            Integer roleId = (Integer)vesselPersonFeatures[1];
            if (!VesselPersonRoleId.RECORDER_PERSON.getValue().equals(roleId)) continue;
            result.addRecorderPerson(person);
        }
        String comment = (String)source[colIndex++];
        result.setComment(comment);
        Integer gearId = (Integer)source[colIndex++];
        if (gearId != null) {
            fr.ifremer.tutti.persistence.entities.referential.Gear gear = this.referentialService.getGear(gearId);
            Preconditions.checkNotNull((Object)gear);
            Object toSet = GearWithOriginalRankOrders.newGearWithOriginalRankOrder(gear);
            toSet.setRankOrder(rankOrder);
            if (log.isDebugEnabled()) {
                log.debug((Object)("FishingOperation: " + id + ", use gear: " + gearId + " - " + rankOrder));
            }
            result.setGear((fr.ifremer.tutti.persistence.entities.referential.Gear)toSet);
        }
        if ((startVesselPosition = (VesselPosition)source[colIndex++]) == null) {
            result.setGearShootingStartLatitude(null);
            result.setGearShootingStartLongitude(null);
        } else {
            result.setGearShootingStartLatitude(this.convertLatitude2UI(startVesselPosition.getLatitude()));
            result.setGearShootingStartLongitude(this.convertLongitude2UI(startVesselPosition.getLongitude()));
        }
        VesselPosition endVesselPosition = (VesselPosition)source[colIndex++];
        if (endVesselPosition == null) {
            result.setGearShootingEndLatitude(null);
            result.setGearShootingEndLongitude(null);
        } else {
            result.setGearShootingEndLatitude(DEFAULT_EMPTY_LATITUDE.equals(endVesselPosition.getLatitude()) ? null : endVesselPosition.getLatitude());
            result.setGearShootingEndLongitude(DEFAULT_EMPTY_LONGITUDE.equals(endVesselPosition.getLongitude()) ? null : endVesselPosition.getLongitude());
        }
        Integer strataId = (Integer)source[colIndex++];
        if (strataId != null) {
            TuttiLocation strata = this.referentialService.getLocation(strataId.toString());
            result.setStrata(strata);
        }
        if ((subStrataId = (Integer)source[colIndex++]) != null) {
            TuttiLocation subStrata = this.referentialService.getLocation(subStrataId.toString());
            result.setSubStrata(subStrata);
        }
        if ((localiteId = (Integer)source[colIndex++]) != null) {
            TuttiLocation localite = this.referentialService.getLocation(localiteId.toString());
            result.setLocation(localite);
        }
        if ((vesselCode = (String)source[colIndex]) != null) {
            Vessel vessel = this.referentialService.getVessel(vesselCode);
            result.setVessel(vessel);
        }
        List<Vessel> secondaryVessel = this.getFishingOperationSecondaryVessel(id);
        result.setSecondaryVessel(secondaryVessel);
        this.getGearUseCaracteristics(id, result);
        this.getVesselUseCaracteristics(id, result);
        return result;
    }

    @Override
    public List<Vessel> getFishingOperationSecondaryVessel(String fishingOperationId) {
        Iterator<Object[]> secondaryVesselList = this.queryList("fishingOperationSecondaryVessel", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        ArrayList result = Lists.newArrayList();
        while (secondaryVesselList.hasNext()) {
            Boolean isCatchOnOperationVessel;
            Object[] next = secondaryVesselList.next();
            String secondaryVesselCode = (String)next[0];
            if (secondaryVesselCode == null || (isCatchOnOperationVessel = (Boolean)next[1]) != null && isCatchOnOperationVessel.booleanValue()) continue;
            Vessel vessel = this.referentialService.getVessel(secondaryVesselCode);
            result.add(vessel);
        }
        return result;
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.FishingOperation createFishingOperation(fr.ifremer.tutti.persistence.entities.data.FishingOperation bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getCruise());
        Preconditions.checkNotNull((Object)bean.getCruise().getId());
        if (bean.getGearShootingStartDate() != null && bean.getGearShootingEndDate() != null) {
            Preconditions.checkArgument((!bean.getGearShootingStartDate().equals(bean.getGearShootingEndDate()) ? 1 : 0) != 0);
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        FishingOperation fishingOperation = FishingOperation.Factory.newInstance();
        this.beanToEntity(bean, fishingOperation);
        this.fishingOperationDao.create(fishingOperation);
        bean.setId(String.valueOf(fishingOperation.getId()));
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.FishingOperation saveFishingOperation(fr.ifremer.tutti.persistence.entities.data.FishingOperation bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getCruise());
        Preconditions.checkNotNull((Object)bean.getCruise().getId());
        if (bean.getGearShootingStartDate() != null && bean.getGearShootingEndDate() != null) {
            Preconditions.checkArgument((!bean.getGearShootingStartDate().equals(bean.getGearShootingEndDate()) ? 1 : 0) != 0);
        }
        this.getCurrentSession().clear();
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        FishingOperation fishingOperation = this.fishingOperationDao.load(Integer.valueOf(bean.getId()));
        if (fishingOperation == null) {
            throw new DataRetrievalFailureException("Could not retrieve fishing operation with id=" + bean.getId());
        }
        this.beanToEntity(bean, fishingOperation);
        this.fishingOperationDao.update(fishingOperation);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public Collection<fr.ifremer.tutti.persistence.entities.data.FishingOperation> saveFishingOperations(Collection<fr.ifremer.tutti.persistence.entities.data.FishingOperation> beans) {
        this.getCurrentSession().clear();
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        ArrayList operations = Lists.newArrayList();
        for (fr.ifremer.tutti.persistence.entities.data.FishingOperation bean : beans) {
            FishingOperation fishingOperation = this.fishingOperationDao.load(Integer.valueOf(bean.getId()));
            if (fishingOperation == null) {
                throw new DataRetrievalFailureException("Could not retrieve fishing operation with id=" + bean.getId());
            }
            this.beanToEntity(bean, fishingOperation);
            operations.add(fishingOperation);
        }
        this.fishingOperationDao.update((Collection)operations);
        this.getCurrentSession().flush();
        return beans;
    }

    @Override
    public void deleteFishingOperation(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer fishingOperationId = Integer.valueOf(id);
        FishingOperation fishingOperation = this.fishingOperationDao.load(fishingOperationId);
        if (fishingOperation == null) {
            throw new DataRetrievalFailureException("Could not retrieve fishing operation with id=" + fishingOperationId);
        }
        this.accidentalBatchService.deleteAccidentalBatchForFishingOperation(id);
        this.getCurrentSession().flush();
        this.catchBatchService.deleteCatchBatch(id);
        this.getCurrentSession().flush();
        HashSet fishingAreas = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getGearUseFeatures())) {
            for (GearUseFeatures gearUseFeatures : fishingOperation.getGearUseFeatures()) {
                gearUseFeatures.setOperation(null);
                gearUseFeatures.getGearUseMeasurements().clear();
                if (!CollectionUtils.isNotEmpty((Collection)gearUseFeatures.getFishingAreas())) continue;
                for (FishingArea fishingArea : gearUseFeatures.getFishingAreas()) {
                    fishingArea.setGearUseFeatures(null);
                }
                fishingAreas.addAll(gearUseFeatures.getFishingAreas());
            }
            this.getCurrentSession().flush();
            fishingOperation.getGearUseFeatures().clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getVesselUseFeatures())) {
            for (VesselUseFeatures vesselUseFeatures : fishingOperation.getVesselUseFeatures()) {
                vesselUseFeatures.setOperation(null);
                vesselUseFeatures.getVesselUseMeasurements().clear();
                if (!CollectionUtils.isNotEmpty((Collection)vesselUseFeatures.getFishingAreas())) continue;
                for (FishingArea fishingArea : vesselUseFeatures.getFishingAreas()) {
                    fishingArea.setVesselUseFeatures(null);
                }
                fishingAreas.addAll(vesselUseFeatures.getFishingAreas());
            }
            this.getCurrentSession().flush();
            fishingOperation.getVesselUseFeatures().clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getVesselPositions())) {
            fishingOperation.getVesselPositions().clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getVesselPersonFeatures())) {
            fishingOperation.getVesselPersonFeatures().clear();
        }
        fishingOperation.setGearPhysicalFeatures(null);
        fishingOperation.setCatchBatch(null);
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getSamples())) {
            fishingOperation.getSamples().clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getOperationVesselAssociations())) {
            for (OperationVesselAssociation asso : fishingOperation.getOperationVesselAssociations()) {
                this.operationVesselAssociationDao.remove(asso);
            }
            fishingOperation.getOperationVesselAssociations().clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)fishingAreas)) {
            for (FishingArea fishingArea : fishingAreas) {
                fishingArea.setProduce(null);
                this.fishingArea2RegulationLocationDao.remove(fishingArea.getRegulationLocations());
                fishingArea.getRegulationLocations().clear();
            }
            this.getCurrentSession().flush();
            this.fishingAreaDao.remove((Collection)fishingAreas);
        }
        this.getCurrentSession().flush();
        if (CollectionUtils.isNotEmpty((Collection)fishingOperation.getProduces())) {
            fishingOperation.getProduces().clear();
            this.getCurrentSession().flush();
        }
        this.fishingOperationDao.remove(fishingOperation);
        this.getCurrentSession().flush();
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.OPERATION, fishingOperationId);
    }

    protected void getVesselUseCaracteristics(String fishingOperationId, fr.ifremer.tutti.persistence.entities.data.FishingOperation result) {
        Iterator<Object[]> list = this.queryList("fishingOperationVesselUseFeatures", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        CaracteristicMap vesselUseCaracteristics = new CaracteristicMap();
        while (list.hasNext()) {
            int colIndex = 0;
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[colIndex++];
            Float numericalValue = (Float)source[colIndex++];
            String alphanumericalValue = (String)source[colIndex++];
            Integer qualitativeValueId = (Integer)source[colIndex];
            if (PmfmId.TRAWL_DISTANCE.getValue().equals(pmfmId)) {
                result.setTrawlDistance(numericalValue);
                continue;
            }
            if (PmfmId.RECTILINEAR_OPERATION.getValue().equals(pmfmId)) {
                result.setFishingOperationRectiligne(QualitativeValueId.RECTILINEAR_OPERATION_YES.getValue().equals(qualitativeValueId));
                continue;
            }
            if (PmfmId.HAUL_VALID.getValue().equals(pmfmId)) {
                if (qualitativeValueId != null) {
                    result.setFishingOperationValid(QualitativeValueId.HAUL_VALID_YES.getValue().equals(qualitativeValueId));
                    continue;
                }
                result.setFishingOperationValid(null);
                continue;
            }
            if (PmfmId.STATION_NUMBER.getValue().equals(pmfmId)) {
                result.setStationNumber(alphanumericalValue);
                continue;
            }
            Caracteristic environmentCaracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = numericalValue;
            } else if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = alphanumericalValue;
            } else if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
                for (CaracteristicQualitativeValue qv : environmentCaracteristic.getQualitativeValue()) {
                    if (qualitativeValueId != Integer.parseInt(qv.getId())) continue;
                    value = qv;
                    break;
                }
            }
            vesselUseCaracteristics.put(environmentCaracteristic, value);
        }
        if (vesselUseCaracteristics.size() > 0) {
            result.setVesselUseFeatures(vesselUseCaracteristics);
        }
    }

    protected void getGearUseCaracteristics(String fishingOperationId, fr.ifremer.tutti.persistence.entities.data.FishingOperation result) {
        Iterator<Object[]> list = this.queryList("fishingOperationGearUseFeatures", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        CaracteristicMap gearShootingCaracteristics = new CaracteristicMap();
        while (list.hasNext()) {
            int colIndex = 0;
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[colIndex++];
            Float numericalValue = (Float)source[colIndex++];
            String alphanumericalValue = (String)source[colIndex++];
            Integer qualitativeValueId = (Integer)source[colIndex];
            if (PmfmId.MULTIRIG_AGGREGATION.getValue().equals(pmfmId) && alphanumericalValue != null && alphanumericalValue.matches("\\d+")) {
                result.setMultirigAggregation(alphanumericalValue);
                continue;
            }
            Caracteristic gearShootingCaracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = numericalValue;
            } else if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = alphanumericalValue;
            } else if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
                for (CaracteristicQualitativeValue qv : gearShootingCaracteristic.getQualitativeValue()) {
                    if (qualitativeValueId != Integer.parseInt(qv.getId())) continue;
                    value = qv;
                    break;
                }
            }
            gearShootingCaracteristics.put(gearShootingCaracteristic, value);
        }
        if (gearShootingCaracteristics.size() > 0) {
            result.setGearUseFeatures(gearShootingCaracteristics);
        }
    }

    protected void beanToEntity(fr.ifremer.tutti.persistence.entities.data.FishingOperation source, FishingOperation target) {
        FishingArea2RegulationLocation fa2rl;
        Date d;
        Date d2;
        VesselUseMeasurement vum;
        GearPhysicalMeasurement gpmMultirigCount;
        ArrayList notChangedRegulationLocation;
        FishingArea fishingArea;
        VesselUseFeatures vesselUseFeatures;
        GearUseFeatures gearUseFeatures;
        ScientificCruise scientificCruise;
        FishingTrip fishingTrip = target.getFishingTrip();
        if (fishingTrip == null) {
            scientificCruise = this.scientificCruiseDao.load(source.getCruise().getIdAsInt());
            fishingTrip = (FishingTrip)scientificCruise.getFishingTrips().iterator().next();
            fishingTrip.getOperations().add(target);
        } else {
            scientificCruise = fishingTrip.getScientificCruise();
        }
        target.setFishingTrip(fishingTrip);
        this.synchronizationStatusHelper.setDirty(fishingTrip);
        VesselPosition startPosition = null;
        VesselPosition endPosition = null;
        if (target.getVesselPositions() != null) {
            for (VesselPosition position : target.getVesselPositions()) {
                if (position.getDateTime() != null && position.getDateTime().getTime() == target.getStartDateTime().getTime()) {
                    startPosition = position;
                    continue;
                }
                if (position.getDateTime() != null && (target.getEndDateTime() == null || position.getDateTime().getTime() != target.getEndDateTime().getTime())) continue;
                endPosition = position;
            }
        }
        if (CollectionUtils.isEmpty((Collection)target.getGearUseFeatures())) {
            gearUseFeatures = GearUseFeatures.Factory.newInstance();
            gearUseFeatures.setOperation((Operation)target);
            if (target.getGearUseFeatures() == null) {
                target.setGearUseFeatures((Collection)Sets.newHashSet((Object[])new GearUseFeatures[]{gearUseFeatures}));
            } else {
                target.getGearUseFeatures().add(gearUseFeatures);
            }
        } else {
            gearUseFeatures = (GearUseFeatures)target.getGearUseFeatures().iterator().next();
        }
        HashSet notChangedGearUseMeasurements = new HashSet();
        if (gearUseFeatures.getGearUseMeasurements() != null) {
            notChangedGearUseMeasurements.addAll(gearUseFeatures.getGearUseMeasurements());
        }
        if (CollectionUtils.isEmpty((Collection)target.getVesselUseFeatures())) {
            vesselUseFeatures = VesselUseFeatures.Factory.newInstance();
            if (target.getVesselUseFeatures() == null) {
                target.setVesselUseFeatures((Collection)Sets.newHashSet((Object[])new VesselUseFeatures[]{vesselUseFeatures}));
                vesselUseFeatures.setOperation((Operation)target);
            } else {
                target.getVesselUseFeatures().add(vesselUseFeatures);
                vesselUseFeatures.setOperation((Operation)target);
            }
        } else {
            vesselUseFeatures = (VesselUseFeatures)target.getVesselUseFeatures().iterator().next();
        }
        HashSet notChangedVesselUseMeasurements = new HashSet();
        if (vesselUseFeatures.getVesselUseMeasurements() != null) {
            notChangedVesselUseMeasurements.addAll(vesselUseFeatures.getVesselUseMeasurements());
        }
        boolean withGear = source.getGear() != null;
        Short gearRankOrder = null;
        if (withGear) {
            gearRankOrder = source.getGear().getRankOrder();
        }
        if (gearRankOrder == null) {
            gearRankOrder = 1;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Use gear rankOrder: " + gearRankOrder));
        }
        GearPhysicalFeatures gearPhysicalFeatures = target.getGearPhysicalFeatures();
        if (withGear) {
            if (gearPhysicalFeatures == null) {
                gearPhysicalFeatures = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures(fishingTrip, source.getGear().getIdAsInt(), false);
                if (gearPhysicalFeatures == null) {
                    throw new DataIntegrityViolationException("An operation could not use a gear that is not declared in the cruise.");
                }
                target.setGearPhysicalFeatures(gearPhysicalFeatures);
                if (gearPhysicalFeatures.getOperations() == null) {
                    gearPhysicalFeatures.setOperations((Collection)Sets.newHashSet((Object[])new Operation[]{target}));
                } else {
                    gearPhysicalFeatures.getOperations().add(target);
                }
            }
        } else {
            gearUseFeatures.setGear(null);
            gearUseFeatures.setRankOrder(Short.valueOf((short)0));
        }
        if (CollectionUtils.isEmpty((Collection)gearUseFeatures.getFishingAreas())) {
            fishingArea = FishingArea.Factory.newInstance();
            if (gearUseFeatures.getFishingAreas() == null) {
                gearUseFeatures.setFishingAreas((Collection)Sets.newHashSet((Object[])new FishingArea[]{fishingArea}));
                fishingArea.setGearUseFeatures(gearUseFeatures);
            } else {
                gearUseFeatures.getFishingAreas().add(fishingArea);
                fishingArea.setGearUseFeatures(gearUseFeatures);
            }
            notChangedRegulationLocation = Lists.newArrayList();
        } else {
            fishingArea = (FishingArea)gearUseFeatures.getFishingAreas().iterator().next();
            notChangedRegulationLocation = Lists.newArrayList((Iterable)fishingArea.getRegulationLocations());
        }
        int cruiseMultirigCount = 1;
        if (gearPhysicalFeatures != null && (gpmMultirigCount = this.gearPhysicalFeaturesDao.getGearPhysicalMeasurement(gearPhysicalFeatures, PmfmId.MULTIRIG_NUMBER.getValue())) != null && gpmMultirigCount.getNumericalValue() != null) {
            cruiseMultirigCount = gpmMultirigCount.getNumericalValue().intValue();
        }
        if (source.getStationNumber() != null) {
            vum = this.measurementPersistenceHelper.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, PmfmId.STATION_NUMBER.getValue(), null, source.getStationNumber(), null);
            notChangedVesselUseMeasurements.remove(vum);
        }
        if (source.getFishingOperationNumber() != null) {
            target.setName(source.getFishingOperationNumber().toString());
        }
        if (source.getMultirigAggregation() != null) {
            int mutlirigNumber;
            if (source.getMultirigAggregation().matches("\\d+") && (mutlirigNumber = Integer.valueOf(source.getMultirigAggregation()).intValue()) > cruiseMultirigCount) {
                throw new DataIntegrityViolationException("An operation could not have a 'multirig number' greater than 'multirig count' defined in the cruise.");
            }
            GearUseMeasurement gum = this.measurementPersistenceHelper.setGearUseMeasurement(scientificCruise, gearUseFeatures, PmfmId.MULTIRIG_AGGREGATION.getValue(), null, source.getMultirigAggregation(), null);
            notChangedGearUseMeasurements.remove(gum);
        }
        if (source.getGearShootingStartDate() == null) {
            target.setStartDateTime(null);
            target.setFishingStartDateTime(null);
        } else if (source.getGearShootingStartDate() != null) {
            d2 = this.dateWithNoMiliSecond(source.getGearShootingStartDate());
            target.setStartDateTime(d2);
            target.setFishingStartDateTime(d2);
        }
        if (source.getGearShootingEndDate() == null) {
            target.setEndDateTime(null);
            target.setFishingEndDateTime(null);
        } else if (source.getGearShootingEndDate() != null) {
            d2 = this.dateWithNoMiliSecond(source.getGearShootingEndDate());
            target.setEndDateTime(d2);
            target.setFishingEndDateTime(d2);
        }
        if (source.getTrawlDistance() != null) {
            vum = this.measurementPersistenceHelper.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, PmfmId.TRAWL_DISTANCE.getValue(), source.getTrawlDistance(), null, null);
            notChangedVesselUseMeasurements.remove(vum);
        }
        vum = this.measurementPersistenceHelper.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, PmfmId.RECTILINEAR_OPERATION.getValue(), null, null, source.isFishingOperationRectiligne() ? QualitativeValueId.RECTILINEAR_OPERATION_YES.getValue() : QualitativeValueId.RECTILINEAR_OPERATION_NO.getValue());
        notChangedVesselUseMeasurements.remove(vum);
        if (source.getFishingOperationValid() != null) {
            vum = this.measurementPersistenceHelper.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, PmfmId.HAUL_VALID.getValue(), null, null, source.getFishingOperationValid() != false ? QualitativeValueId.HAUL_VALID_YES.getValue() : QualitativeValueId.HAUL_VALID_NO.getValue());
            notChangedVesselUseMeasurements.remove(vum);
        }
        target.setVessel(fishingTrip.getVessel());
        ArrayList vesselIds = Lists.newArrayList();
        if (!source.isSecondaryVesselEmpty()) {
            for (Vessel vessel : source.getSecondaryVessel()) {
                vesselIds.add(vessel.getId());
            }
        }
        this.setOperationVesselAssociation((Operation)target, vesselIds);
        if (target.getQualityFlag() == null) {
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        }
        if (target.getStartDateTime() == null) {
            d = this.dateWithNoSecondAndOneMiliSecond(scientificCruise.getDepartureDateTime());
            target.setStartDateTime(d);
            target.setFishingStartDateTime(d);
        }
        vesselUseFeatures.setStartDate(target.getStartDateTime());
        if (vesselUseFeatures.getStartDate() == null) {
            vesselUseFeatures.setStartDate(scientificCruise.getDepartureDateTime());
        }
        vesselUseFeatures.setEndDate(target.getEndDateTime());
        vesselUseFeatures.setVessel(target.getVessel());
        vesselUseFeatures.setProgram(scientificCruise.getProgram());
        vesselUseFeatures.setIsActive(isActive.ACTIVE.getValue());
        if (vesselUseFeatures.getCreationDate() == null) {
            d = this.newCreateDate();
            vesselUseFeatures.setCreationDate(d);
        }
        if (vesselUseFeatures.getQualityFlag() == null) {
            vesselUseFeatures.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        }
        gearUseFeatures.setStartDate(target.getStartDateTime());
        if (gearUseFeatures.getStartDate() == null) {
            gearUseFeatures.setStartDate(scientificCruise.getDepartureDateTime());
        }
        gearUseFeatures.setEndDate(target.getEndDateTime());
        gearUseFeatures.setVessel(target.getVessel());
        gearUseFeatures.setProgram(scientificCruise.getProgram());
        if (gearUseFeatures.getCreationDate() == null) {
            d = this.newCreateDate();
            gearUseFeatures.setCreationDate(d);
        }
        if (gearUseFeatures.getQualityFlag() == null) {
            gearUseFeatures.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        }
        if (!withGear) {
            gearUseFeatures.setGear(null);
            gearUseFeatures.setRankOrder(Short.valueOf((short)0));
        } else {
            gearUseFeatures.setGear((Gear)this.load(GearImpl.class, source.getGear().getIdAsInt()));
            gearUseFeatures.setRankOrder(gearRankOrder);
        }
        if (source.getGearShootingEndLatitude() != null || source.getGearShootingEndDate() != null || source.getGearShootingEndLongitude() != null) {
            if (startPosition == null) {
                startPosition = VesselPosition.Factory.newInstance();
                startPosition.setOperation((Operation)target);
                if (target.getVesselPositions() == null) {
                    target.setVesselPositions((Collection)Sets.newHashSet((Object[])new VesselPosition[]{startPosition}));
                }
                target.getVesselPositions().add(startPosition);
            }
            startPosition.setDateTime(target.getStartDateTime());
            startPosition.setLatitude(source.getGearShootingStartLatitude() == null ? DEFAULT_EMPTY_LATITUDE : source.getGearShootingStartLatitude());
            startPosition.setLongitude(source.getGearShootingStartLongitude() == null ? DEFAULT_EMPTY_LONGITUDE : source.getGearShootingStartLongitude());
            startPosition.setVessel(target.getVessel());
            startPosition.setProgram(scientificCruise.getProgram());
            startPosition.setRecorderDepartment(scientificCruise.getRecorderDepartment());
            startPosition.setQualityFlag(target.getQualityFlag());
        } else if (startPosition != null && target.getVesselPositions() != null) {
            target.getVesselPositions().remove(startPosition);
        }
        if (source.getGearShootingEndLatitude() != null || source.getGearShootingEndDate() != null || source.getGearShootingEndLongitude() != null) {
            if (endPosition == null) {
                endPosition = VesselPosition.Factory.newInstance();
                endPosition.setOperation((Operation)target);
                target.getVesselPositions().add(endPosition);
            }
            Date endDateTime = this.convertUI2DatabaseMandatoryDate(target.getEndDateTime(), startPosition.getDateTime(), true);
            endPosition.setDateTime(endDateTime);
            if (!endDateTime.equals(target.getEndDateTime())) {
                target.setEndDateTime(endDateTime);
                target.setFishingEndDateTime(endDateTime);
            }
            endPosition.setLatitude(this.convertUI2DatabaseMandatoryLatitude(source.getGearShootingEndLatitude()));
            endPosition.setLongitude(this.convertUI2DatabaseMandatoryLatitude(source.getGearShootingEndLongitude()));
            endPosition.setVessel(target.getVessel());
            endPosition.setProgram(scientificCruise.getProgram());
            endPosition.setRecorderDepartment(scientificCruise.getRecorderDepartment());
            endPosition.setQualityFlag(target.getQualityFlag());
        } else if (endPosition != null && target.getVesselPositions() != null) {
            target.getVesselPositions().remove(endPosition);
        }
        CaracteristicMap vesselUseCaracteristics = source.getVesselUseFeatures();
        if (MapUtils.isNotEmpty((Map)vesselUseCaracteristics)) {
            for (Caracteristic caracteristic : vesselUseCaracteristics.keySet()) {
                VesselUseMeasurement vum2 = this.measurementPersistenceHelper.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, caracteristic, (Serializable)vesselUseCaracteristics.get(caracteristic));
                notChangedVesselUseMeasurements.remove(vum2);
            }
        }
        TreeMap vesselPersonFeaturesMap = Maps.newTreeMap();
        VesselPersonRole recorderPersonRole = this.vesselPersonFeaturesPersistenceHelper.getRecorderPersonRole();
        short personRankOrder = 1;
        if (CollectionUtils.isNotEmpty(source.getRecorderPerson())) {
            for (Person person : source.getRecorderPerson()) {
                Integer personId = person.getIdAsInt();
                short s = personRankOrder;
                personRankOrder = (short)(personRankOrder + 1);
                this.vesselPersonFeaturesPersistenceHelper.fillVesselPersonFeatures((Map<Integer, VesselPersonFeatures>)vesselPersonFeaturesMap, personId, target, recorderPersonRole, s);
            }
        }
        if (target.getVesselPersonFeatures() == null) {
            target.setVesselPersonFeatures((Collection)Sets.newHashSet());
        }
        target.getVesselPersonFeatures().clear();
        target.getVesselPersonFeatures().addAll(vesselPersonFeaturesMap.values());
        target.setComments(source.getComment());
        CaracteristicMap gearUseCaracteristics = source.getGearUseFeatures();
        if (MapUtils.isNotEmpty((Map)gearUseCaracteristics)) {
            for (Caracteristic caracteristic : gearUseCaracteristics.keySet()) {
                GearUseMeasurement gum = this.measurementPersistenceHelper.setGearUseMeasurement(scientificCruise, gearUseFeatures, caracteristic, (Serializable)gearUseCaracteristics.get(caracteristic));
                notChangedGearUseMeasurements.remove(gum);
            }
        }
        if (vesselUseFeatures.getVesselUseMeasurements() != null && notChangedVesselUseMeasurements.size() > 0) {
            vesselUseFeatures.getVesselUseMeasurements().removeAll(notChangedVesselUseMeasurements);
        }
        if (gearUseFeatures.getGearUseMeasurements() != null && notChangedGearUseMeasurements.size() > 0) {
            gearUseFeatures.getGearUseMeasurements().removeAll(notChangedGearUseMeasurements);
        }
        Integer statisticalLocationId = null;
        if (source.getGearShootingStartLatitude() != null && source.getGearShootingStartLongitude() != null) {
            statisticalLocationId = this.locationService.getLocationIdByLatLong(source.getGearShootingStartLatitude(), source.getGearShootingStartLongitude());
        }
        if (statisticalLocationId == null && source.getGearShootingEndLatitude() != null && source.getGearShootingEndLongitude() != null) {
            statisticalLocationId = this.locationService.getLocationIdByLatLong(source.getGearShootingEndLatitude(), source.getGearShootingEndLongitude());
        }
        if (source.getStrata() != null && source.getStrata().getId() != null) {
            fa2rl = this.getFishingArea2RegulationLocation(fishingArea, source.getStrata().getIdAsInt(), true);
            notChangedRegulationLocation.remove(fa2rl);
            if (statisticalLocationId == null) {
                statisticalLocationId = source.getStrata().getIdAsInt();
            }
        }
        if (source.getSubStrata() != null && source.getSubStrata().getId() != null) {
            fa2rl = this.getFishingArea2RegulationLocation(fishingArea, source.getSubStrata().getIdAsInt(), true);
            notChangedRegulationLocation.remove(fa2rl);
            if (statisticalLocationId == null) {
                statisticalLocationId = source.getSubStrata().getIdAsInt();
            }
        }
        if (source.getLocation() != null && source.getLocation().getId() != null) {
            fa2rl = this.getFishingArea2RegulationLocation(fishingArea, source.getLocation().getIdAsInt(), true);
            notChangedRegulationLocation.remove(fa2rl);
            if (statisticalLocationId == null) {
                statisticalLocationId = source.getLocation().getIdAsInt();
            }
        }
        fishingArea.getRegulationLocations().removeAll(notChangedRegulationLocation);
        if (statisticalLocationId == null) {
            gearUseFeatures.getFishingAreas().remove(fishingArea);
            if (fishingArea.getRegulationLocations() != null) {
                fishingArea.getRegulationLocations().clear();
            }
        } else if (statisticalLocationId != null) {
            fishingArea.setLocation((Location)this.load(LocationImpl.class, statisticalLocationId));
        }
    }

    protected Float convertUI2DatabaseMandatoryLatitude(Float databaseValue) {
        return databaseValue != null ? databaseValue : DEFAULT_EMPTY_LATITUDE;
    }

    protected Float convertLatitude2UI(Float databaseValue) {
        return DEFAULT_EMPTY_LATITUDE.equals(databaseValue) ? null : databaseValue;
    }

    protected Float convertUI2DatabaseMandatoryLongitude(Float databaseValue) {
        return databaseValue != null ? databaseValue : DEFAULT_EMPTY_LONGITUDE;
    }

    protected Float convertLongitude2UI(Float databaseValue) {
        return DEFAULT_EMPTY_LONGITUDE.equals(databaseValue) ? null : databaseValue;
    }

    protected void setOperationVesselAssociation(Operation target, List<String> vesselCodes) {
        boolean noOperationVesselAssociations = target.getOperationVesselAssociations() == null;
        HashSet toAdd = Sets.newHashSet();
        HashSet notChanged = Sets.newHashSet();
        if (!noOperationVesselAssociations) {
            notChanged.addAll(target.getOperationVesselAssociations());
        }
        for (String vesselCode : vesselCodes) {
            OperationVesselAssociation ova = null;
            OperationVesselAssociationPK ovaPK = new OperationVesselAssociationPK();
            ovaPK.setVessel(this.load(VesselImpl.class, (Serializable)((Object)vesselCode)));
            ovaPK.setOperation((OperationImpl)target);
            if (vesselCode.equals(target.getVessel().getCode())) break;
            for (OperationVesselAssociation asso : notChanged) {
                if (!asso.getOperationVesselAssociationPk().equals((Object)ovaPK)) continue;
                ova = asso;
                break;
            }
            if (ova == null) {
                ova = OperationVesselAssociation.Factory.newInstance();
                ova.setOperationVesselAssociationPk(ovaPK);
            }
            ova.setIsCatchOnOperationVessel(Boolean.FALSE);
            toAdd.add(ova);
            notChanged.remove(ova);
        }
        if (!noOperationVesselAssociations) {
            for (OperationVesselAssociation operationVesselAssociation : notChanged) {
                this.operationVesselAssociationDao.remove(operationVesselAssociation);
            }
            target.getOperationVesselAssociations().removeAll(notChanged);
        }
        if (!toAdd.isEmpty()) {
            if (noOperationVesselAssociations) {
                target.setOperationVesselAssociations((Collection)Sets.newHashSet());
            }
            target.getOperationVesselAssociations().addAll(toAdd);
        }
    }

    protected FishingArea2RegulationLocation getFishingArea2RegulationLocation(FishingArea fishingArea, int regulationLocationId, boolean createIfNotExists) {
        Preconditions.checkNotNull((Object)fishingArea);
        FishingArea2RegulationLocationPK pk = new FishingArea2RegulationLocationPK();
        pk.setFishingArea((FishingAreaImpl)fishingArea);
        pk.setLocation(this.load(LocationImpl.class, Integer.valueOf(regulationLocationId)));
        FishingArea2RegulationLocation fa2rl = null;
        if (CollectionUtils.isNotEmpty((Collection)fishingArea.getRegulationLocations())) {
            for (FishingArea2RegulationLocation existingFa2rl : fishingArea.getRegulationLocations()) {
                FishingArea2RegulationLocationPK existingPk = existingFa2rl.getFishingArea2RegulationLocationPk();
                if (!Objects.equals(existingPk, pk)) continue;
                fa2rl = existingFa2rl;
                break;
            }
        }
        if (fa2rl != null || !createIfNotExists) {
            return fa2rl;
        }
        fa2rl = FishingArea2RegulationLocation.Factory.newInstance();
        fa2rl.setFishingArea2RegulationLocationPk(pk);
        if (fishingArea.getRegulationLocations() == null) {
            fishingArea.setRegulationLocations((Collection)Sets.newHashSet((Object[])new FishingArea2RegulationLocation[]{fa2rl}));
        } else {
            fishingArea.getRegulationLocations().add(fa2rl);
        }
        return fa2rl;
    }
}

