package fr.ifremer.tutti.ui.swing.util.comment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CommentAware;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class CommentEditorUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Tz09TQRCeFlosFVEICBESUBPj5dV48IJRCEqEVDEWE2Ivbt9byuL27bo7zz4uxj/BP0HvXky8eTIePHvwYvwXjPHg1Tj7+vqLlkiTbpud+b6d+eabdz8hZw0sH7A49kwUomhwb2ttd3e7dsB9vMOtb4RGZaD1yWQhW4Vi0Lm3CJeqZQcvpfDSumpoFfKwB71ShnGLh5Lbfc4RYbEf4VtbqnTCK7GOTJu1U9Qw1je/f2VfB6/eZgFiTdW5Vpb+h+p2MlqGrAgQpuilF6wkWVinMowI61TvhLtbl8zaB6zBn8NLGCtDXjNDZAgXT95ywpHgY40w4atGwyUKJlUd4cae8cSe4Q1uPIwQhRcJzzapBi9CIb003TXifu8Ggrgfb2qdUOYRRmuchQjXB3g0N1ZY5KHPPUIKFNy2adaa1EeXY8bvZd9R+iELuURYVqbuHdCwn6HSrapib2t3R6DkQZLjCAodnonLWxXfKCld7BrCeadhnLbTE3Lpkx1UEXmM6yrERNmZPswOhdYMZy51StN4L/SNl4zjdY3TnWymCjkT0TXCXHXQa48o1HLZ3BGXOcIk+nd2+tvHHx822tYaobdnhqb2bAaNXBtFwjutESZbvnJzLN1neqUKBcslrVWyNgtDCqukYSqO3jvn4C0b3GN2nyhyY98/fZ59+nUEshswLhULNpjL34QC7htSQckg1rdXk4pON0/ReZa+WRI5CgPuK8OQk+NH0USkV5HJJju02yGNPL2MSZSFIaJ0KqsVvvyZrrxfbQuToULnj03vipN7AnkRShHyZOvShRq6ZUVteRSo7uIMWyU4uks69fNici4PiJBByKFzLsJ8a0P6XO8lsThy4CtJX+7fVThuO07wXF6yQ0UvwZmbAUO2VBNhQK6+NfBIxp3jxPgP/ANteI8FAAA=";
    private static final Log log = LogFactory.getLog(CommentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CommentAware bean;
    protected CommentEditorUI commentDialog = this;
    protected JXTitledPanel commentEditorTopPanel;
    protected final CommentEditorUIHandler handler = new CommentEditorUIHandler();
    protected JTextArea textContent;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void openEditor(JComponent component) {
       handler.openEditor(component);
    }
    
    public void closeEditor() {
       handler.closeEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CommentEditorUI(TuttiUIContext context) {
        super(context.getMainUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public CommentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI() {
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CommentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CommentEditorUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__textContent(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(((JTextArea)event.getSource()).getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CommentAware getBean() {
        return bean;
    }

    public JXTitledPanel getCommentEditorTopPanel() {
        return commentEditorTopPanel;
    }

    public CommentEditorUIHandler getHandler() {
        return handler;
    }

    public JTextArea getTextContent() {
        return textContent;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(CommentAware bean) {
        CommentAware oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(commentEditorTopPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentEditorTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        commentEditorTopPanel.add($JScrollPane0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCommentEditorTopPanel() {
        $objectMap.put("commentEditorTopPanel", commentEditorTopPanel = new JXTitledPanel());
        
        commentEditorTopPanel.setName("commentEditorTopPanel");
        commentEditorTopPanel.setTitle(t("tutti.commentEditor.title"));
    }

    protected void createTextContent() {
        $objectMap.put("textContent", textContent = new JTextArea());
        
        textContent.setName("textContent");
        textContent.setColumns(15);
        textContent.setLineWrap(true);
        textContent.setWrapStyleWord(true);
        textContent.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textContent"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCommentDialog();
        addChildrenToCommentEditorTopPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textContent);
        // late initializer
        commentDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("commentDialog", commentDialog);
        createBean();
        createCommentEditorTopPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextContent();
        // inline creation of commentDialog
        setName("commentDialog");
        commentDialog.getContentPane().setLayout(new BorderLayout());
        setUndecorated(true);
        setAlwaysOnTop(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}