/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchroServiceUtils {
    private static final Log log = LogFactory.getLog(SynchroServiceUtils.class);

    public static void checkSchemas(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema, boolean allowMissingOptionalColumn, boolean allowAdditionalMandatoryColumnInSourceSchema, SynchroResult result) {
        try {
            if (allowMissingOptionalColumn) {
                SynchroServiceUtils.checkSchemasAllowMissingOptionalColumn(sourceSchema, targetSchema, allowAdditionalMandatoryColumnInSourceSchema, result);
            } else {
                SynchroServiceUtils.checkSchemasStrict(sourceSchema, targetSchema);
            }
        }
        catch (SynchroTechnicalException e) {
            result.setError(e);
        }
    }

    protected static void checkSchemasAllowMissingOptionalColumn(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema, boolean allowAdditionalMandatoryColumnInSourceSchema, SynchroResult result) {
        Set<String> sourceSchemaTableNames;
        Set<String> targetSchemaTableNames = targetSchema.getLoadedTableNames();
        if (!targetSchemaTableNames.equals(sourceSchemaTableNames = sourceSchema.getLoadedTableNames())) {
            HashSet missingTargetTables = Sets.newHashSet();
            for (String targetTableName : targetSchemaTableNames) {
                if (sourceSchemaTableNames.contains(targetTableName)) continue;
                missingTargetTables.add(targetTableName);
            }
            HashSet missingSourceTables = Sets.newHashSet();
            for (String sourceTableName : sourceSchemaTableNames) {
                if (targetSchemaTableNames.contains(sourceTableName)) continue;
                missingSourceTables.add(sourceTableName);
            }
            throw new SynchroTechnicalException(String.format("Incompatible schemas.\nMissing tables in source database: %s\nMissing tables in target database: %s", missingTargetTables, missingSourceTables));
        }
        for (String tableName : targetSchemaTableNames) {
            Set<String> sourceColumnNames;
            SynchroTableMetadata targetTable = targetSchema.getTable(tableName);
            SynchroTableMetadata sourceTable = sourceSchema.getTable(tableName);
            HashSet targetColumnNames = Sets.newHashSet(targetTable.getColumnNames());
            if (!targetColumnNames.equals(sourceColumnNames = sourceTable.getColumnNames())) {
                TreeSet missingMandatoryColumns = Sets.newTreeSet();
                HashSet missingSourceColumnNames = Sets.newHashSet(sourceColumnNames);
                for (String targetColumnName : targetTable.getColumnNames()) {
                    if (!sourceColumnNames.contains(targetColumnName)) {
                        SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(targetColumnName);
                        if (targetColumn.isNullable()) {
                            log.debug((Object)String.format("Optional column not found in source database: %s.%s. Will be ignore.", tableName, targetColumnName));
                            result.addMissingOptionalColumnName(tableName, targetColumnName);
                            targetColumnNames.remove(targetColumnName);
                        } else {
                            log.warn((Object)String.format("Column not found in source database: %s.%s", tableName, targetColumnName));
                            missingMandatoryColumns.add(targetColumnName);
                        }
                    }
                    missingSourceColumnNames.remove(targetColumnName);
                }
                for (String sourceColumnName : missingSourceColumnNames) {
                    SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(sourceColumnName);
                    if (allowAdditionalMandatoryColumnInSourceSchema || sourceColumn.isNullable()) {
                        log.debug((Object)String.format("Optional column not found in target database: %s.%s. Will be ignore.", tableName, sourceColumnName));
                        result.addMissingOptionalColumnName(tableName, sourceColumnName);
                        continue;
                    }
                    log.warn((Object)String.format("Column not found in target database: %s.%s. Will be ignore.", tableName, sourceColumnName));
                    missingMandatoryColumns.add(sourceColumnName);
                }
                if (CollectionUtils.isNotEmpty((Collection)missingMandatoryColumns)) {
                    throw new SynchroTechnicalException(String.format("Incompatible schema of table: %s. Missing mandatory columns: %s", tableName, missingMandatoryColumns));
                }
            }
            for (String columnName : targetColumnNames) {
                SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(columnName);
                SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(columnName);
                if (targetColumn.isProtected()) continue;
                SynchroMetadataUtils.checkType(tableName, targetColumn, sourceColumn);
            }
        }
    }

    protected static void checkSchemasStrict(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema) {
        Set<String> sourceSchemaTableNames = sourceSchema.getLoadedTableNames();
        Set<String> targetSchemaTableNames = targetSchema.getLoadedTableNames();
        if (!targetSchemaTableNames.equals(sourceSchemaTableNames)) {
            throw new SynchroTechnicalException("Incompatible schemas: missing tables");
        }
        for (String tableName : sourceSchemaTableNames) {
            SynchroTableMetadata sourceTable = sourceSchema.getTable(tableName);
            SynchroTableMetadata targetTable = targetSchema.getTable(tableName);
            Set<String> sourceColumnNames = sourceTable.getColumnNames();
            Set<String> targetColumnNames = targetTable.getColumnNames();
            if (!targetColumnNames.equals(sourceColumnNames)) {
                throw new SynchroTechnicalException("Incompatible schema of table: " + tableName);
            }
            for (String columnName : targetColumnNames) {
                SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(columnName);
                SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(columnName);
                if (targetColumn.isProtected()) continue;
                SynchroMetadataUtils.checkType(tableName, targetColumn, sourceColumn);
            }
        }
    }
}

