/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import oracle.sql.TIMESTAMP;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class OracleInterceptor
extends SynchroInterceptorBase {
    private Map<TableMetadata, int[]> columnIndexesByTable = Maps.newHashMap();
    private SynchroTableDao lastDao = null;
    private int[] lastIndexes = null;

    @Override
    public boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
        boolean isOracleDialect = meta.getDialect().getClass().getName().contains("Oracle");
        if (!isOracleDialect) {
            return false;
        }
        Map<String, ColumnMetadata> columns = SynchroTableMetadata.getColumns(table);
        ArrayList columnIndexesList = Lists.newArrayList();
        int index = 0;
        for (ColumnMetadata column : columns.values()) {
            if (column.getTypeCode() == 91 || column.getTypeCode() == 93) {
                columnIndexesList.add(index);
            }
            ++index;
        }
        if (columnIndexesList.isEmpty()) {
            return false;
        }
        int[] columnIndexes = this.getColumnIndexes(table);
        if (columnIndexes == null) {
            return false;
        }
        this.columnIndexesByTable.put(table, columnIndexes);
        return true;
    }

    @Override
    public boolean enableOnRead() {
        return true;
    }

    @Override
    protected String doCreateSelectQuery(SynchroTableMetadata table, String queryName, String sql) {
        return sql;
    }

    @Override
    protected void doOnRead(Object[] data, SynchroTableDao dao) throws SQLException {
        if (dao != this.lastDao) {
            this.lastIndexes = this.getColumnMapIndexes(dao);
            this.lastDao = dao;
        }
        for (int index : this.lastIndexes) {
            Object value = data[index];
            if (value == null || !(value instanceof TIMESTAMP)) continue;
            data[index] = ((TIMESTAMP)value).timestampValue();
        }
    }

    @Override
    public boolean enableOnWrite() {
        return true;
    }

    @Override
    protected void doOnWrite(Object[] data, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException {
        if (dao != this.lastDao) {
            this.lastIndexes = this.getColumnMapIndexes(dao);
            this.lastDao = dao;
        }
        for (int index : this.lastIndexes) {
            Object value = data[index];
            if (value == null || !(value instanceof TIMESTAMP)) continue;
            data[index] = ((TIMESTAMP)value).timestampValue();
        }
    }

    protected int[] getColumnMapIndexes(SynchroTableDao dao) {
        TableMetadata table = dao.getTable().getDelegate();
        int[] columnIndexes = this.columnIndexesByTable.get(table);
        if (columnIndexes == null) {
            columnIndexes = this.getColumnIndexes(table);
            this.columnIndexesByTable.put(table, columnIndexes);
        }
        return columnIndexes;
    }

    protected int[] getColumnIndexes(TableMetadata table) {
        Map<String, ColumnMetadata> columns = SynchroTableMetadata.getColumns(table);
        if (columns == null) {
            return null;
        }
        ArrayList columnIndexesList = Lists.newArrayList();
        int index = 0;
        for (ColumnMetadata column : columns.values()) {
            if (column.getTypeCode() == 91 || column.getTypeCode() == 93) {
                columnIndexesList.add(index);
            }
            ++index;
        }
        if (columnIndexesList.isEmpty()) {
            return null;
        }
        int[] columnIndexes = new int[columnIndexesList.size()];
        index = 0;
        for (Integer columnIndex : columnIndexesList) {
            columnIndexes[index] = columnIndex;
        }
        return columnIndexes;
    }
}

