/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.config;

import java.io.File;
import java.net.URL;
import java.util.Locale;
import org.hibernate.dialect.HSQLDialect;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public enum AdagioConfigurationOption implements ConfigOptionDef
{
    BASEDIR("adagio.basedir", I18n.n((String)"adagio.config.option.basedir.description", (Object[])new Object[0]), "${user.home}/.adagio", File.class),
    DATA_DIRECTORY("adagio.data.directory", I18n.n((String)"adagio.config.option.data.directory.description", (Object[])new Object[0]), "${adagio.basedir}/data", File.class),
    I18N_DIRECTORY("adagio.i18n.directory", I18n.n((String)"adagio.config.option.i18n.directory.description", (Object[])new Object[0]), "${adagio.basedir}/i18n", File.class),
    TMP_DIRECTORY("adagio.tmp.directory", I18n.n((String)"adagio.config.option.tmp.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/temp", File.class),
    DB_DIRECTORY("adagio.persistence.db.directory", I18n.n((String)"adagio.config.option.persistence.db.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/db", File.class),
    DB_ATTACHMENT_DIRECTORY("adagio.persistence.db.attachment.directory", I18n.n((String)"adagio.config.option.persistence.db.attachment.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/meas_files", File.class),
    DB_CACHE_DIRECTORY("adagio.persistence.db.cache.directory", I18n.n((String)"adagio.config.option.persistence.db.cache.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/dbcache", File.class),
    DB_NAME("adagio.persistence.db.name", I18n.n((String)"adagio.config.option.persistence.db.name.description", (Object[])new Object[0]), "allegro", String.class),
    DB_HOST("adagio.persistence.db.host", I18n.n((String)"adagio.config.option.persistence.db.host.description", (Object[])new Object[0]), "", String.class),
    DB_PORT("adagio.persistence.db.port", I18n.n((String)"adagio.config.option.persistence.db.port.description", (Object[])new Object[0]), "", String.class),
    DB_VALIDATION_QUERY("adagio.persistence.db.validation-query", I18n.n((String)"adagio.persistence.db.validation-query.description", (Object[])new Object[0]), "SELECT COUNT(*) FROM STATUS", String.class),
    DATASOURCE_TYPE("adagio.persistence.datasource.type", I18n.n((String)"adagio.persistence.datasource.type.description", (Object[])new Object[0]), "local", String.class),
    DATASOURCE_JNDI_NAME("adagio.persistence.jndi-name", I18n.n((String)"adagio.config.option.persistence.jndi-name.description", (Object[])new Object[0]), "adagio-ds", String.class),
    JDBC_USERNAME("adagio.persistence.jdbc.username", I18n.n((String)"adagio.config.option.persistence.jdbc.username.description", (Object[])new Object[0]), "sa", String.class),
    JDBC_PASSWORD("adagio.persistence.jdbc.password", I18n.n((String)"adagio.config.option.persistence.jdbc.password.description", (Object[])new Object[0]), "", String.class),
    JDBC_URL("adagio.persistence.jdbc.url", I18n.n((String)"adagio.config.option.persistence.jdbc.url.description", (Object[])new Object[0]), "jdbc:hsqldb:file:${adagio.persistence.db.directory}/${adagio.persistence.db.name}", String.class),
    JDBC_CATALOG("adagio.persistence.jdbc.catalog", I18n.n((String)"adagio.config.option.persistence.jdbc.catalog.description", (Object[])new Object[0]), null, String.class),
    JDBC_SCHEMA("adagio.persistence.jdbc.schema", I18n.n((String)"adagio.config.option.persistence.jdbc.schema.description", (Object[])new Object[0]), "PUBLIC", String.class),
    JDBC_DRIVER("adagio.persistence.jdbc.driver", I18n.n((String)"adagio.config.option.persistence.jdbc.driver.description", (Object[])new Object[0]), "org.hsqldb.jdbcDriver", Class.class),
    JDBC_BATCH_SIZE("adagio.persistence.jdbc.batch-size", I18n.n((String)"adagio.config.option.persistence.jdbc.batch-size.description", (Object[])new Object[0]), "15", Integer.class),
    HIBERNATE_DIALECT("adagio.persistence.hibernate.dialect", I18n.n((String)"adagio.config.option.persistence.hibernate.dialect.description", (Object[])new Object[0]), HSQLDialect.class.getName(), Class.class),
    DEBUG_ENTITY_LOAD("adagio.persistence.hibernate.load.debug", I18n.n((String)"adagio.config.option.persistence.hibernate.load.debug.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE),
    STATUS_CODE_TEMPORARY("adagio.enumeration.StatusCode.TEMPORARY", I18n.n((String)"adagio.enumeration.StatusCode.TEMPORARY.description", (Object[])new Object[0]), String.format("${%sStatusCode.TEMPORARY}", "adagio.enumeration."), String.class),
    STATUS_CODE_ENABLE("adagio.enumeration.StatusCode.ENABLE", I18n.n((String)"adagio.enumeration.StatusCode.ENABLE.description", (Object[])new Object[0]), String.format("${%sStatusCode.ENABLE}", "adagio.enumeration."), String.class),
    PROGRAM_CODE_VESSEL_REGISTRY("adagio.enumeration.ProgramCode.SIH", I18n.n((String)"adagio.enumeration.ProgramCode.SIH.description", (Object[])new Object[0]), String.format("${%sProgramCode.SIH}", "adagio.enumeration."), String.class),
    VERSION("adagio.version", I18n.n((String)"adagio.config.option.persistence.version.description", (Object[])new Object[0]), "3.5.4", Version.class),
    SITE_URL("adagio.site.url", I18n.n((String)"adagio.config.option.site.url.description", (Object[])new Object[0]), "http://www.ifremer.fr/sih-adagio", URL.class),
    ORGANIZATION_NAME("adagio.organizationName", I18n.n((String)"adagio.config.option.organizationName.description", (Object[])new Object[0]), "Ifremer", String.class),
    INCEPTION_YEAR("adagio.inceptionYear", I18n.n((String)"adagio.config.option.inceptionYear.description", (Object[])new Object[0]), "2011", Integer.class),
    DB_BACKUP_DIRECTORY("adagio.persistence.db.backup.directory", I18n.n((String)"adagio.config.option.persistence.db.backup.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/dbbackup", File.class, false),
    DB_ENUMERATION_RESOURCE("adagio.persistence.db.enumeration.resource", I18n.n((String)"adagio.config.option.persistence.db.enumeration.resource", (Object[])new Object[0]), "classpath*:adagio-db-enumerations.properties", String.class, false),
    HIBERNATE_SHOW_SQL("adagio.persistence.hibernate.showSql", I18n.n((String)"adagio.config.option.persistence.hibernate.showSql.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE, false),
    HIBERNATE_USE_SQL_COMMENT("adagio.persistence.hibernate.useSqlComment", I18n.n((String)"adagio.config.option.persistence.hibernate.useSqlComment.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE, false),
    HIBERNATE_FORMAT_SQL("adagio.persistence.hibernate.formatSql", I18n.n((String)"adagio.config.option.persistence.hibernate.formatSql.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE, false),
    HIBERNATE_SECOND_LEVEL_CACHE("adagio.persistence.hibernate.useSecondLevelCache", I18n.n((String)"adagio.config.option.persistence.hibernate.useSecondLevelCache.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE, false),
    HIBERNATE_CLIENT_QUERIES_FILE("adagio.persistence.hibernate.queriesFile", I18n.n((String)"adagio.config.option.persistence.hibernate.queriesFile.description", (Object[])new Object[0]), "queries-failsafe.hbm.xml", String.class, false),
    LIQUIBASE_RUN_AUTO("adagio.persistence.liquibase.should.run", I18n.n((String)"adagio.config.option.liquibase.should.run.description", (Object[])new Object[0]), Boolean.FALSE.toString(), Boolean.TYPE, false),
    LIQUIBASE_CHANGE_LOG_PATH("adagio.persistence.liquibase.changelog.path", I18n.n((String)"adagio.config.option.liquibase.changelog.path.description", (Object[])new Object[0]), "classpath:fr/ifremer/adagio/core/db/changelog/db-changelog-master.xml", String.class, false),
    LIQUIBASE_DIFF_TYPES("adagio.persistence.liquibase.diff.types", I18n.n((String)"adagio.config.option.liquibase.diff.types.description", (Object[])new Object[0]), null, String.class, false),
    LIQUIBASE_OUTPUT_FILE("adagio.persistence.liquibase.output.file", I18n.n((String)"adagio.config.option.liquibase.output.file.description", (Object[])new Object[0]), null, File.class, false),
    CACHE_BACTH_TREE("adagio.persistence.batch.use_tree_cache", I18n.n((String)"adagio.config.option.batch.use_tree_cache.description", (Object[])new Object[0]), Boolean.TRUE.toString(), Boolean.TYPE, false),
    CSV_SEPARATOR("adagio.csv.separator", I18n.n((String)"adagio.config.option.csv.separator.description", (Object[])new Object[0]), ";", Character.TYPE, false),
    I18N_LOCALE("adagio.i18n.locale", I18n.n((String)"adagio.config.option.i18n.locale.description", (Object[])new Object[0]), Locale.FRANCE.getCountry(), Locale.class, false),
    SERVER_PORT("adagio.server.port", I18n.n((String)"adagio.config.option.server.port.description", (Object[])new Object[0]), "8888", Integer.class, false);

    private final String key;
    private final String description;
    private final Class<?> type;
    private String defaultValue;
    private boolean isTransient;
    private boolean isFinal;

    private AdagioConfigurationOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isTransient;
    }

    private AdagioConfigurationOption(String key, String description, String defaultValue, Class<?> type) {
        this(key, description, defaultValue, type, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean newValue) {
    }

    @Override
    public void setFinal(boolean newValue) {
    }
}

