/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.validator.NuitonValidatorResult;

public class ValidateCruiseUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ValidateCruiseUIModel.class);
    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";
    public static final String PROPERTY_READY_TO_SYNCH = "readyToSynch";
    protected FishingOperation selectedFishingOperation;
    protected final Map<FishingOperation, NuitonValidatorResult> validator = new HashMap<FishingOperation, NuitonValidatorResult>();
    protected boolean readyToSynch;
    protected Cruise cruise;

    public FishingOperation getSelectedFishingOperation() {
        return this.selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        FishingOperation oldValue = this.getSelectedFishingOperation();
        this.selectedFishingOperation = selectedFishingOperation;
        this.firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, oldValue, selectedFishingOperation);
    }

    public Map<FishingOperation, NuitonValidatorResult> getValidator() {
        return new HashMap<FishingOperation, NuitonValidatorResult>(this.validator);
    }

    public Set<FishingOperation> getFishingOperations() {
        return ImmutableSet.builder().addAll(this.validator.keySet()).build();
    }

    public NuitonValidatorResult getValidatorResult(FishingOperation fishingOperation) {
        return this.validator.get(fishingOperation);
    }

    public void addValidatorResults(Map<FishingOperation, NuitonValidatorResult> validator) {
        for (Map.Entry<FishingOperation, NuitonValidatorResult> entry : validator.entrySet()) {
            this.validator.put(entry.getKey(), entry.getValue());
        }
    }

    public void addValidatorResult(FishingOperation fishingOperation, NuitonValidatorResult validatorResult) {
        this.validator.put(fishingOperation, validatorResult);
    }

    public void computeReadyToSynch() {
        boolean result = Cruises.isDirty(this.cruise);
        if (result) {
            for (NuitonValidatorResult nuitonValidatorResult : this.validator.values()) {
                if (nuitonValidatorResult.hasErrorMessagess()) {
                    result = false;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("there is some errors: " + nuitonValidatorResult.getFieldsForError()));
                    }
                } else {
                    if (!nuitonValidatorResult.hasFatalMessages()) continue;
                    result = false;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("there is some fatal errors: " + nuitonValidatorResult.getFieldsForFatal()));
                    }
                }
                break;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Cruise is not dirty");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New readyToSynch value: " + result));
        }
        this.setReadyToSynch(result);
    }

    public boolean isReadyToSynch() {
        return this.readyToSynch;
    }

    public void setReadyToSynch(boolean readyToSynch) {
        this.readyToSynch = readyToSynch;
        this.firePropertyChange(PROPERTY_READY_TO_SYNCH, null, readyToSynch);
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
        this.computeReadyToSynch();
    }

    public Cruise getCruise() {
        return this.cruise;
    }
}

