/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentId;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.GearUseMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.VesselUseMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId2;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="measurementPersistenceHelper")
public class MeasurementPersistenceHelper
extends AbstractPersistenceService {
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;

    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (value == null) {
            return;
        }
        switch (caracteristic.getCaracteristicType()) {
            case NUMBER: {
                measurement.setNumericalValue((Float)value);
                break;
            }
            case QUALITATIVE: {
                Integer qvId = null;
                if (value instanceof CaracteristicQualitativeValue) {
                    qvId = Integer.valueOf(((CaracteristicQualitativeValue)value).getId());
                } else if (value instanceof Integer) {
                    qvId = (Integer)value;
                }
                QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
                measurement.setQualitativeValue(qv);
                break;
            }
            case TEXT: {
                measurement.setAlphanumericalValue((String)((Object)value));
            }
        }
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, this.getRecorderDepartmentId(), true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public QuantificationMeasurement setWeightMeasurementQuantificationMeasurement(Batch batch, Float weightValue) {
        Collection quantificationMeasurements = batch.getQuantificationMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement(batch, PmfmId2.WEIGHT_MEASURED.getValue(), this.getRecorderDepartmentId(), weightValue, true);
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        return quantificationMeasurement;
    }

    public QuantificationMeasurement getWeightMeasurementQuantificationMeasurement(Batch batch) {
        QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.getQuantificationMeasurement(batch, PmfmId2.WEIGHT_MEASURED.getValue());
        return quantificationMeasurement;
    }

    public SortingMeasurement getInheritedSortingMeasurement(SortingBatch sortingBatch) {
        return this.catchBatchDao.getInheritedSortingMeasurement(sortingBatch, PmfmId2.SORTED_UNSORTED.getValue());
    }

    public VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            vesselUseMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            vesselUseMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            vesselUseMeasurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId));
        }
        return vesselUseMeasurement;
    }

    public VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Caracteristic caracteristic, Serializable value) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, Integer.valueOf(caracteristic.getId()), true);
        this.setMeasurement((Measurement)vesselUseMeasurement, caracteristic, value);
        return vesselUseMeasurement;
    }

    public VesselUseMeasurement getVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, boolean createIfNotExists) {
        VesselUseMeasurement vesselUseMeasurement = null;
        if (vesselUseFeatures.getVesselUseMeasurements() != null) {
            for (VesselUseMeasurement vum : vesselUseFeatures.getVesselUseMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                vesselUseMeasurement = vum;
                break;
            }
        }
        if (vesselUseMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            vesselUseMeasurement = VesselUseMeasurement.Factory.newInstance();
            vesselUseMeasurement.setVesselUseFeatures(vesselUseFeatures);
            if (vesselUseFeatures.getVesselUseMeasurements() == null) {
                vesselUseFeatures.setVesselUseMeasurements((Collection)Sets.newHashSet((Object[])new VesselUseMeasurement[]{vesselUseMeasurement}));
            } else {
                vesselUseFeatures.getVesselUseMeasurements().add(vesselUseMeasurement);
            }
            vesselUseMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            vesselUseMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            vesselUseMeasurement.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        return vesselUseMeasurement;
    }

    protected VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, Serializable value) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, pmfmId, true);
        if (value instanceof String) {
            vesselUseMeasurement.setAlphanumericalValue((String)((Object)value));
        } else if (value instanceof Float) {
            vesselUseMeasurement.setNumericalValue((Float)value);
        } else if (value instanceof Integer) {
            vesselUseMeasurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, value));
        }
        return vesselUseMeasurement;
    }

    public GearUseMeasurement setGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        GearUseMeasurement gearUseMeasurement = this.getGearUseMeasurement(scientificCruise, gearUseFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            gearUseMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            gearUseMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId);
            gearUseMeasurement.setQualitativeValue(qv);
        }
        return gearUseMeasurement;
    }

    public GearUseMeasurement setGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Caracteristic caracteristic, Serializable value) {
        GearUseMeasurement gearUseMeasurement = this.getGearUseMeasurement(scientificCruise, gearUseFeatures, Integer.valueOf(caracteristic.getId()), true);
        this.setMeasurement((Measurement)gearUseMeasurement, caracteristic, value);
        return gearUseMeasurement;
    }

    protected GearUseMeasurement getGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Integer pmfmId, boolean createIfNotExists) {
        GearUseMeasurement gearUseMeasurement = null;
        if (gearUseFeatures.getGearUseMeasurements() != null) {
            for (GearUseMeasurement vum : gearUseFeatures.getGearUseMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                gearUseMeasurement = vum;
                break;
            }
        }
        if (gearUseMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            gearUseMeasurement = GearUseMeasurement.Factory.newInstance();
            gearUseMeasurement.setGearUseFeatures(gearUseFeatures);
            if (gearUseFeatures.getGearUseMeasurements() == null) {
                gearUseFeatures.setGearUseMeasurements((Collection)Sets.newHashSet((Object[])new GearUseMeasurement[]{gearUseMeasurement}));
            } else {
                gearUseFeatures.getGearUseMeasurements().add(gearUseMeasurement);
            }
            gearUseMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            gearUseMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            Pmfm pmfm = (Pmfm)this.getCurrentSession().load(PmfmImpl.class, (Serializable)pmfmId);
            gearUseMeasurement.setPmfm(pmfm);
        }
        return gearUseMeasurement;
    }

    public String toString(Measurement measurement) {
        Pmfm pmfm = (Pmfm)this.load(PmfmImpl.class, measurement.getPmfm().getId());
        String value = null;
        if (measurement.getQualitativeValue() != null) {
            QualitativeValue qualitativeValue = measurement.getQualitativeValue();
            String qualitativeName = this.load(QualitativeValueImpl.class, qualitativeValue.getId()).getName();
            value = qualitativeName + " (" + qualitativeValue.getId() + ")";
        } else if (measurement.getNumericalValue() != null) {
            value = "" + measurement.getNumericalValue();
        } else if (measurement.getAlphanumericalValue() != null) {
            value = measurement.getAlphanumericalValue();
        }
        return "[id:" + measurement.getId() + "] - " + pmfm.getParameter().getName() + " (" + pmfm.getId() + ") / " + value;
    }

    public SurveyMeasurement setSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        SurveyMeasurement result = this.getSurveyMeasurement(fishingTrip, pmfmId);
        if (result == null) {
            result = this.createSurveyMeasurement(fishingTrip, pmfmId, numericalValue, alphanumericalValue, qualitativevalueId);
        }
        return result;
    }

    public SurveyMeasurement removeSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId) {
        SurveyMeasurement result = this.getSurveyMeasurement(fishingTrip, pmfmId);
        if (result != null) {
            result.setFishingTrip(null);
            fishingTrip.getSurveyMeasurements().remove(result);
        }
        return result;
    }

    protected SurveyMeasurement createSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        SurveyMeasurement result = SurveyMeasurement.Factory.newInstance();
        result.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        result.setDepartment(fishingTrip.getRecorderDepartment());
        Pmfm pmfm = (Pmfm)this.load(PmfmImpl.class, pmfmId);
        result.setPmfm(pmfm);
        result.setFishingTrip(fishingTrip);
        if (alphanumericalValue != null) {
            result.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            result.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            result.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId));
        }
        if (fishingTrip.getSurveyMeasurements() == null) {
            fishingTrip.setSurveyMeasurements((Collection)Sets.newHashSet());
        }
        fishingTrip.getSurveyMeasurements().add(result);
        return result;
    }

    protected SurveyMeasurement getSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId) {
        SurveyMeasurement result = null;
        for (SurveyMeasurement vum : fishingTrip.getSurveyMeasurements()) {
            if (!pmfmId.equals(vum.getPmfm().getId())) continue;
            result = vum;
            break;
        }
        return result;
    }

    public Integer getRecorderDepartmentId() {
        return DepartmentId.UNKOWN_RECODER_DEPARTMENT.getValue();
    }
}

