/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.data.engine.core.security.ClassSecurity;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;

class DataAccessClassLoader
extends URLClassLoader {
    private static final Pattern sm_odaInterfacesPattern = Pattern.compile("org\\.eclipse\\.birt\\.data\\.oda\\.[a-zA-Z]+");
    private static String sm_className = DataAccessClassLoader.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    DataAccessClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
        sm_logger.exiting(sm_className, "DataAccessClassLoader", this);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String methodName = "findClass";
        sm_logger.entering(sm_className, methodName, name);
        Matcher matcher = sm_odaInterfacesPattern.matcher(name);
        if (matcher.matches()) {
            return ClassSecurity.loadClass(ClassSecurity.getClassLoader(this.getClass()), name);
        }
        Class<?> foundClass = super.findClass(name);
        sm_logger.exiting(sm_className, methodName, foundClass);
        return foundClass;
    }
}

