package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.validator.NuitonValidatorResult;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class ValidateCruiseUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ValidateCruiseUIModel.class);

    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";

    public static final String PROPERTY_READY_TO_SYNCH = "readyToSynch";

    protected FishingOperation selectedFishingOperation;

    protected final Map<FishingOperation, NuitonValidatorResult> validator = new HashMap<FishingOperation, NuitonValidatorResult>();

    protected boolean readyToSynch;

    protected Cruise cruise;

    public FishingOperation getSelectedFishingOperation() {
        return selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        Object oldValue = getSelectedFishingOperation();
        this.selectedFishingOperation = selectedFishingOperation;
        firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, oldValue, selectedFishingOperation);
    }

    public Map<FishingOperation, NuitonValidatorResult> getValidator() {
        return new HashMap<FishingOperation, NuitonValidatorResult>(validator);
    }

    public Set<FishingOperation> getFishingOperations() {
        return ImmutableSet.<FishingOperation>builder().addAll(validator.keySet()).build();
    }

    public NuitonValidatorResult getValidatorResult(FishingOperation fishingOperation) {
        return validator.get(fishingOperation);
    }

    public void addValidatorResults(Map<FishingOperation, NuitonValidatorResult> validator) {
        for (Map.Entry<FishingOperation, NuitonValidatorResult> entry : validator.entrySet()) {
            this.validator.put(entry.getKey(), entry.getValue());
        }
//        computeReadyToSynch();
    }

    public void addValidatorResult(FishingOperation fishingOperation, NuitonValidatorResult validatorResult) {
        validator.put(fishingOperation, validatorResult);
//        computeReadyToSynch();
    }

    public void computeReadyToSynch() {
        boolean result = Cruises.isDirty(cruise);
        if (result) {
            for (NuitonValidatorResult nuitonValidatorResult : validator.values()) {
                if (nuitonValidatorResult.hasErrorMessagess() ) {
                    result = false;
                    if (log.isInfoEnabled()) {
                        log.info("there is some errors: "+nuitonValidatorResult.getFieldsForError());
                    }
                    break;
                }
                if ( nuitonValidatorResult.hasFatalMessages()) {
                    result = false;
                    if (log.isInfoEnabled()) {
                        log.info("there is some fatal errors: "+nuitonValidatorResult.getFieldsForFatal());
                    }
                    break;
                }
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Cruise is not dirty");
            }
        }
        if (log.isInfoEnabled()) {
            log.info("New readyToSynch value: " + result);
        }
        setReadyToSynch(result);
    }

    public boolean isReadyToSynch() {
        return readyToSynch;
    }

    public void setReadyToSynch(boolean readyToSynch) {
        this.readyToSynch = readyToSynch;
        firePropertyChange(PROPERTY_READY_TO_SYNCH, null /*force to fire the changes*/, readyToSynch);
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
        computeReadyToSynch();
    }

    public Cruise getCruise() {
        return cruise;
    }
}
