
package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectSpeciesUIModel.java 1385 2013-11-24 23:27:27Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/species/SelectSpeciesUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;

import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SelectSpeciesUIModel extends AbstractTuttiBeanUIModel<SelectSpeciesUIModel, SelectSpeciesUIModel> {

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SELECTED_SPECIES = "selectedSpecies";

    protected List<Species> species = Lists.newArrayList();

    protected Species selectedSpecies;

    public SelectSpeciesUIModel() {
        super(null, null);
    }

    public List<Species> getSpecies() {
        return species;
    }

    public void setSpecies(List<Species> species) {
        Object oldValue = getSpecies();
        this.species = Lists.newArrayList(species);
        firePropertyChange(PROPERTY_SPECIES, oldValue, this.species);
    }

    public Species getSelectedSpecies() {
        return selectedSpecies;
    }

    public void setSelectedSpecies(Species selectedSpecies) {
        Object oldValue = getSelectedSpecies();
        this.selectedSpecies = selectedSpecies;
        firePropertyChange(PROPERTY_SELECTED_SPECIES, oldValue, selectedSpecies);
    }

    @Override
    protected SelectSpeciesUIModel newEntity() {
        return new SelectSpeciesUIModel();
    }
}
