/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGStyleSheetProcessingInstruction;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGOMDocument
extends AbstractStylableDocument
implements SVGDocument,
SVGConstants {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages", ((Object)((Object)this)).getClass().getClassLoader());
    protected String referrer = "";
    protected URL url;
    protected transient boolean readonly;

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(documentType, dOMImplementation);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localizableSupport.setLocale(locale);
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        try {
            return super.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return this.localizableSupport.formatMessage(string, objectArray);
        }
    }

    public String getTitle() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Node node = this.getDocumentElement().getFirstChild();
        while (node != null) {
            string = node.getNamespaceURI();
            if (string != null && string.equals("http://www.w3.org/2000/svg") && node.getLocalName().equals("title")) {
                bl = ((SVGLangSpace)node).getXMLspace().equals("preserve");
                node = node.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 3) {
                        stringBuffer.append(node.getNodeValue());
                    }
                    node = node.getNextSibling();
                }
                break;
            }
            node = node.getNextSibling();
        }
        string = stringBuffer.toString();
        return bl ? XMLSupport.preserveXMLSpace((String)string) : XMLSupport.defaultXMLSpace((String)string);
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.url == null ? null : this.url.toString();
    }

    public URL getURLObject() {
        return this.url;
    }

    public void setURLObject(URL uRL) {
        this.url = uRL;
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), (AbstractDocument)this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment((AbstractDocument)this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, (AbstractDocument)this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, (AbstractDocument)this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, (AbstractDocument)this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if ("xml-stylesheet".equals(string)) {
            return new SVGStyleSheetProcessingInstruction(string2, (AbstractDocument)this, (StyleSheetFactory)this.getImplementation());
        }
        return new GenericProcessingInstruction(string, string2, (AbstractDocument)this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), (AbstractDocument)this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, (AbstractDocument)this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), (AbstractDocument)this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), (AbstractDocument)this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)((Object)((AbstractDocument)this).implementation);
        return sVGDOMImplementation.createElementNS((AbstractDocument)this, string, string2);
    }

    public boolean isId(Attr attr) {
        if (attr.getNamespaceURI() != null) {
            return false;
        }
        return "id".equals(attr.getNodeName());
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)node);
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)node);
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

