package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: CaracteristicColumnIdentifier.java 1564 2014-01-31 10:56:26Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/CaracteristicColumnIdentifier.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;

import java.io.Serializable;

/**
 * To identify a column that represents a caracteristic.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5
 */
public class CaracteristicColumnIdentifier<R> extends ColumnIdentifier<R> {

    private static final long serialVersionUID = 1L;

    public static <R> CaracteristicColumnIdentifier newCaracteristicId(
            Caracteristic caracteristic,
            String propertyName,
            String headerI18nKey,
            String headerTipI18nKey) {

        return new CaracteristicColumnIdentifier<R>(caracteristic, propertyName,
                                                    headerI18nKey,
                                                    headerTipI18nKey
        );
    }

    protected Caracteristic caracteristic;

    protected CaracteristicColumnIdentifier(Caracteristic caracteristic,
                                            String propertyName,
                                            String headerI18nKey,
                                            String headerTipI18nKey) {
        super(propertyName, headerI18nKey, headerTipI18nKey);
        this.caracteristic = caracteristic;
    }

    @Override
    public Object getValue(R entry) {
        CaracteristicMap map = (CaracteristicMap) super.getValue(entry);
        Serializable result = map.get(caracteristic);
        return result;
    }

    @Override
    public void setValue(R entry, Object value) {
        CaracteristicMap map = (CaracteristicMap) super.getValue(entry);
        Preconditions.checkNotNull(map, "caracteristicMap (" + getPropertyName() + ") is null in " + entry);
        map.put(caracteristic, (Serializable) value);
        // reset the map in bean to fire property
        super.setValue(entry, map);
    }
}
