/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BookmarkContent
implements Cloneable {
    private static final int ENDING = 0;
    private static final int BOOKMARK = 1;
    private static final int ELEMENT_ID = 2;
    private static final int PAGE_NUMBER = 3;
    private String bookmark;
    private long elementId = -1L;
    private long pageNumber = -1L;

    public BookmarkContent() {
    }

    public BookmarkContent(String bookmark, long elementId) {
        this.bookmark = bookmark;
        this.elementId = elementId;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public long getElementId() {
        return this.elementId;
    }

    public void setBookmark(String value) {
        this.bookmark = value;
    }

    public void setElementId(int elementId) {
        this.elementId = elementId;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long number) {
        this.pageNumber = number;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public BookmarkContent copy() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return (BookmarkContent)obj;
    }

    public void writeStream(DataOutput out) throws IOException {
        if (this.bookmark != null) {
            out.writeInt(1);
            out.writeUTF(this.bookmark);
        }
        if (this.elementId != -1L) {
            out.writeInt(2);
            out.writeLong(this.elementId);
        }
        if (this.pageNumber != -1L) {
            out.writeInt(3);
            out.writeLong(this.pageNumber);
        }
        out.writeInt(0);
    }

    public void readStream(DataInput in) throws IOException {
        int type = in.readInt();
        while (type != 0) {
            switch (type) {
                case 1: {
                    this.bookmark = in.readUTF();
                    break;
                }
                case 2: {
                    this.elementId = in.readLong();
                    break;
                }
                case 3: {
                    this.pageNumber = in.readLong();
                }
            }
            type = in.readInt();
        }
    }
}

